#!/usr/bin/env python
# Copyright (C) 2000-2001 The OpenRPG Project
#
#   openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: player_list.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: player_list.py,v 1.7 2003/08/16 10:06:28 snowdog_ Exp $
#
# Description: This is the main entry point of the oprg application
#

__version__ = "$Id: player_list.py,v 1.7 2003/08/16 10:06:28 snowdog_ Exp $"

from orpg.orpg_windows import *
import orpg.dirpath


# global definitions
global ROLE_GM; ROLE_GM = "GM"
global ROLE_PLAYER; ROLE_PLAYER = "PLAYER"
global ROLE_LURKER; ROLE_LURKER = "LURKER"


#########################
#player frame window
#########################
PLAYER_BOOT = wxNewId()
PLAYER_WHISPER = wxNewId()
PLAYER_WHISPER_TOGGLE = wxNewId()
PLAYER_WHISPER_GROUP = wxNewId()
PLAYER_IGNORE = wxNewId()
PLAYER_ROLE_MENU = wxNewId()
PLAYER_ROLE_LURKER = wxNewId()
PLAYER_ROLE_PLAYER = wxNewId()
PLAYER_ROLE_GM = wxNewId()
PLAYER_MODERATE_MENU = wxNewId()
PLAYER_MODERATE_ROOM_ON = wxNewId()
PLAYER_MODERATE_ROOM_OFF = wxNewId()
PLAYER_MODERATE_GIVE_VOICE = wxNewId()
PLAYER_MODERATE_TAKE_VOICE = wxNewId()
PLAYER_SHOW_VERSION = wxNewId()

#---------------------------------------------------------
# [START] Snowdog Password/Room Name altering code 12/02
#---------------------------------------------------------

PLAYER_COMMAND_MENU = wxNewId()
PLAYER_COMMAND_PASSWORD_ALTER = wxNewId()
PLAYER_COMMAND_ROOM_RENAME = wxNewId()

#---------------------------------------------------------
# [END] Snowdog Password/Room Name altering code 12/02
#---------------------------------------------------------


class player_list(wxListCtrl):
    def __init__( self, parent, openrpg ):
##        wxListCtrl.__init__( self, parent, -1, wxDefaultPosition, wxDefaultSize, wxLC_REPORT|wxSUNKEN_BORDER|wxEXPAND )
        wxListCtrl.__init__( self, parent, -1, wxDefaultPosition, wxDefaultSize, wxLC_REPORT|wxSUNKEN_BORDER|wxEXPAND|wxLC_HRULES )

        self.myopenrpg = openrpg
        self.session = self.myopenrpg.get_component("session")
        # Create in image list -- for whatever reason...guess it will be nice when we can tell which is a bot
        self.whisperCount = 0
        self._imageList = wxImageList( 16, 16, false )
        img = wxImage(orpg.dirpath.dir_struct["icon"]+"player.gif", wxBITMAP_TYPE_GIF).ConvertToBitmap()
        self._imageList.Add( img )
        img = wxImage(orpg.dirpath.dir_struct["icon"]+"player-whisper.gif", wxBITMAP_TYPE_GIF).ConvertToBitmap()
        self._imageList.Add( img )
        self.SetImageList( self._imageList, wxIMAGE_LIST_SMALL )

        # Create our column headers
        self.InsertColumn( 0, "ID" )
        self.InsertColumn( 1, "Player" )
        self.InsertColumn( 2, "Status" )

        # Create the role menu
        self.roleMenu = wxMenu()
        self.roleMenu.SetTitle( "Assign Role" )
        self.roleMenu.Append( PLAYER_ROLE_LURKER, "Lurker" )
        self.roleMenu.Append( PLAYER_ROLE_PLAYER, "Player" )
        self.roleMenu.Append( PLAYER_ROLE_GM, "GM" )

        # Create the moderation menu
        self.moderateMenu = wxMenu()
        self.moderateMenu.SetTitle( "Moderate" )
        self.moderateMenu.Append( PLAYER_MODERATE_ROOM_ON, "Room Moderation ON" )
        self.moderateMenu.Append( PLAYER_MODERATE_ROOM_OFF, "Room Moderation OFF" )
        self.moderateMenu.AppendSeparator()
        self.moderateMenu.Append( PLAYER_MODERATE_GIVE_VOICE, "Give Voice" )
        self.moderateMenu.Append( PLAYER_MODERATE_TAKE_VOICE, "Take Voice" )

#---------------------------------------------------------
# [START] Snowdog Password/Room Name altering code 12/02
#---------------------------------------------------------


        # Create the room control menu
        self.commandMenu = wxMenu()
        self.commandMenu.SetTitle( "Room Controls" )
        self.commandMenu.Append( PLAYER_COMMAND_PASSWORD_ALTER, "Password" )
        self.commandMenu.Append( PLAYER_COMMAND_ROOM_RENAME, "Room Name" )
        self.commandMenu.AppendSeparator()

#---------------------------------------------------------
# [END] Snowdog Password/Room Name altering code 12/02
#---------------------------------------------------------

        # Create the pop up menu
        self.menu = wxMenu()
        self.menu.SetTitle( "Player Menu" )
        self.menu.Append( PLAYER_BOOT, "Boot" )
        self.menu.AppendSeparator()
        self.menu.Append( PLAYER_IGNORE, "Toggle &Ignore" )
        self.menu.AppendSeparator()
        self.menu.Append( PLAYER_WHISPER, "Whisper" )
        self.menu.Append( PLAYER_WHISPER_TOGGLE, "Toggle Whisper Group" )
        self.menu.Append( PLAYER_WHISPER_GROUP, "Whisper To Group" )
        self.menu.Enable( PLAYER_WHISPER_GROUP, false )
        self.menu.AppendSeparator()
        self.menu.AppendMenu( PLAYER_MODERATE_MENU, "Moderate", self.moderateMenu )
        self.menu.AppendMenu( PLAYER_COMMAND_MENU, "Room Control", self.commandMenu )
        self.menu.AppendSeparator()
        self.menu.AppendMenu( PLAYER_ROLE_MENU, "Assign Role", self.roleMenu )
        self.menu.AppendSeparator()
        self.menu.Append( PLAYER_SHOW_VERSION, "Version" )

        # Event processing for our menu
        EVT_MENU( self, PLAYER_BOOT, self.on_menu_item )
        EVT_MENU( self, PLAYER_IGNORE, self.on_menu_item )
        EVT_MENU( self, PLAYER_WHISPER, self.on_menu_item )
        EVT_MENU( self, PLAYER_WHISPER_TOGGLE, self.on_menu_item )
        EVT_MENU( self, PLAYER_WHISPER_GROUP, self.on_menu_item )
        EVT_MENU( self, PLAYER_MODERATE_ROOM_ON, self.on_menu_moderate )
        EVT_MENU( self, PLAYER_MODERATE_ROOM_OFF, self.on_menu_moderate )
        EVT_MENU( self, PLAYER_MODERATE_GIVE_VOICE, self.on_menu_moderate )
        EVT_MENU( self, PLAYER_MODERATE_TAKE_VOICE, self.on_menu_moderate )
        EVT_MENU( self, PLAYER_ROLE_LURKER, self.on_menu_role_change )
        EVT_MENU( self, PLAYER_ROLE_PLAYER, self.on_menu_role_change )
        EVT_MENU( self, PLAYER_ROLE_GM, self.on_menu_role_change )
        EVT_MENU( self, PLAYER_SHOW_VERSION, self.on_menu_item )
#---------------------------------------------------------
# [START] Snowdog Password/Room Name altering code 12/02
#---------------------------------------------------------
        EVT_MENU( self, PLAYER_COMMAND_PASSWORD_ALTER, self.on_menu_password )
        EVT_MENU( self, PLAYER_COMMAND_ROOM_RENAME, self.on_menu_room_rename )
#---------------------------------------------------------
# [END] Snowdog Password/Room Name altering code 12/02
#---------------------------------------------------------
        EVT_LEFT_DCLICK(self,self.on_d_lclick)
        EVT_RIGHT_DOWN( self, self.on_menu )
        #EVT_SIZE( self, self.on_size )

        #self.on_size(None)
        self.sized = 1

#---------------------------------------------------------
# [START] Snowdog Password/Room Name altering code 12/02
#
#       Revised 8/03 to add support for password manager
#---------------------------------------------------------


    def on_menu_password( self, evt ):
        id = evt.GetId()
        session = self.myopenrpg.get_component("session")
        password_manager = self.myopenrpg.get_component("password_manager")
        chat = self.myopenrpg.get_component("chat")
        boot_pwd = password_manager.GetPassword("admin",int(session.group_id))
        if boot_pwd != None:
            alter_pwd_dialog = wxTextEntryDialog(self,"Enter new room password: (blank for no password)","Alter Room Password")
            if alter_pwd_dialog.ShowModal() == wxID_OK:
                new_pass = alter_pwd_dialog.GetValue()
                chat.InfoPost( "Requesting password change on server..." )
                session.set_room_pass(new_pass, boot_pwd)


    def on_menu_room_rename( self, evt ):
        id = evt.GetId()
        session = self.myopenrpg.get_component("session")
        password_manager = self.myopenrpg.get_component("password_manager")
        chat = self.myopenrpg.get_component("chat")
        boot_pwd = password_manager.GetPassword("admin",int(session.group_id))
        if boot_pwd != None:
            alter_name_dialog = wxTextEntryDialog(self,"Enter new room name: ","Change Room Name")
            if alter_name_dialog.ShowModal() == wxID_OK:
                new_name = alter_name_dialog.GetValue()
                chat.InfoPost( "Requesting room name change on server..." )
                session.set_room_name(new_name, boot_pwd)

#---------------------------------------------------------
# [END] Snowdog Password/Room Name altering code 12/02
#---------------------------------------------------------



    def on_menu_moderate( self, evt ):
        "Change the moderated status of a room or player."

        id = evt.GetId()
        chat = self.myopenrpg.get_component( "chat" )
        playerID = self.GetItemData( self.selected_item )

        moderationString = None
        moderateRoomBase = "/moderate %s"
        moderatePlayerBase = "/moderate %d=%s"
        infoRoomBase = "Attempting to %s moderation in the current room..."
        infoPlayerBase = "Attempting to %s voice to %s (%d)..."

        if id == PLAYER_MODERATE_ROOM_ON:
            moderationString = (moderateRoomBase % "on")
            infoString = (infoRoomBase % "ENABLE")

        if id == PLAYER_MODERATE_ROOM_OFF:
            moderationString = (moderateRoomBase % "off")
            infoString = (infoRoomBase % "DISABLE")
            
        elif id == PLAYER_MODERATE_GIVE_VOICE:
            moderationString = (moderatePlayerBase % (playerID, "on"))
            infoString = (infoPlayerBase % ("GIVE", chat.session.get_player_by_player_id( str(playerID) )[0], playerID))
            
        elif id == PLAYER_MODERATE_TAKE_VOICE:
            moderationString = (moderatePlayerBase % (playerID, "off"))
            infoString = (infoPlayerBase % ("TAKE", chat.session.get_player_by_player_id( str(playerID) )[0], playerID))
        
        # Now, send it to the server
        if moderationString:
            chat.chat_cmds.docmd( moderationString )

            # Now, provide local feedback as to what we requested
            chat.InfoPost( infoString )



    def on_menu_role_change( self, evt ):
        "Change the role of the selected id."

        id = evt.GetId()
        chat = self.myopenrpg.get_component( "chat" )
        playerID = self.GetItemData( self.selected_item )

        roleString = None
        roleBase = "/role %d=%s"
        infoBase = "Attempting to assign the role of %s to (%d) %s..."
        
        # Do type specific processing
        if id == PLAYER_ROLE_LURKER:
            roleName = ROLE_LURKER
            roleString = (roleBase % ( playerID, ROLE_LURKER ))

        elif id == PLAYER_ROLE_PLAYER:
            roleName = ROLE_PLAYER
            roleString = (roleBase % ( playerID, ROLE_PLAYER ))

        elif id == PLAYER_ROLE_GM:
            roleName = ROLE_GM
            roleString = (roleBase % ( playerID, ROLE_GM ))

        # Now, send it to the server
        if roleString:
            chat.chat_cmds.docmd( roleString )

            # Now, provide local feedback as to what we requested
            displayName = chat.session.get_player_by_player_id( str(playerID) )[0]
            infoString = (infoBase % ( roleName, playerID, displayName ))
            chat.InfoPost( infoString )

    def on_d_lclick(self,evt):
        pos = wxPoint(evt.GetX(),evt.GetY())
        (item, flag) = self.HitTest(pos)
        id = self.GetItemText(item)
        chat = self.myopenrpg.get_component("chat")
#        if wx.wxKeyEvent.ShiftDown():
#            chat_text = chat.get_chat_text()
#            print chat_text.find("/w")
        chat.set_chat_text("/w " + id + "=")

    def on_menu_item(self,evt):
        id = evt.GetId()
        session = self.myopenrpg.get_component("session")
        password_manager = self.myopenrpg.get_component("password_manager")
        
        if id == PLAYER_BOOT:
            id = str(self.GetItemData(self.selected_item))
            boot_pwd = password_manager.GetPassword("admin",int(session.group_id))
            if boot_pwd != None:
                session.boot_player(id,boot_pwd)

        elif id == PLAYER_WHISPER:
            id = self.GetItemText(self.selected_item)
            chat = self.myopenrpg.get_component("chat")
            chat.set_chat_text("/w " + id + "=")

        elif id == PLAYER_WHISPER_TOGGLE:
            # Fetch the current image index and toggle it back and forth
            item = self.GetItem( self.selected_item )
            if item.GetImage():
                item.SetImage( 0 )
                self.whisperCount -= 1
            else:
                item.SetImage( 1 )
                self.whisperCount += 1

            self.SetItem( item )

            # Toggle the group whisper menu item
            if self.whisperCount:
                self.menu.Enable( PLAYER_WHISPER_GROUP, true )
            else:
                self.menu.Enable( PLAYER_WHISPER_GROUP, false )
                
        elif id == PLAYER_WHISPER_GROUP:
            # Obtain the complete list of items, detect which ones have whisper turned on
            ic = self.GetItemCount()
            index = 0
            idString = ""
            first = 0
            while index < ic:
                item = self.GetItem( index )
                if item.GetImage():
                    if not first:
                        idString += item.GetText()
                        first = 1
                    else:
                        idString += "," + item.GetText()
                index += 1

            chat = self.myopenrpg.get_component("chat")
            chat.set_chat_text("/w " + idString + "=")

        elif id == PLAYER_IGNORE:
            id = str(self.GetItemData(self.selected_item))
            chat = self.myopenrpg.get_component("chat")
            (result,id,name) = session.toggle_ignore(id)
            if result == 0:
                  chat.Post(chat.colorize(chat.syscolor, "Player " + name + " with ID:" + id +" no longer ignored"))
            else:
                  chat.Post(chat.colorize(chat.syscolor, "Player " + name + " with ID:" + id +" now being ignored"))

        elif id == PLAYER_SHOW_VERSION:
            id = str(self.GetItemData(self.selected_item))
            version_string = session.players[id][4]
            if version_string:
                wxMessageBox("Running client version " + version_string,"Version")
            else:
                wxMessageBox("No client version available for this player","Version")



    def on_menu(self,evt):
        pos = wxPoint(evt.GetX(),evt.GetY())
        (item, flag) = self.HitTest(pos)
        if item > -1:
            self.selected_item = item

            #  This if-else block makes the menu item to boot players active or inactive, as appropriate
            if 0:     #self.myopenrpg.get_component("session").group_id == "0":
                self.menu.Enable(PLAYER_BOOT,0)
                self.menu.SetLabel(PLAYER_BOOT,"Can't boot from Lobby")
            else:
                self.menu.Enable(PLAYER_BOOT,1)
                self.menu.SetLabel(PLAYER_BOOT,"Boot")

            self.PopupMenu(self.menu,pos)



    def add_player(self,player):
        i = self.InsertImageStringItem(0,player[2],0)
        self.SetStringItem(i,1,self.strip_html(player))
        self.SetItemData(i,int(player[2]))
        self.SetStringItem (i, 2,player[3])
        self.colorize_player_list()
        self.Refresh()

        # play sound
        setobj = self.myopenrpg.get_component('settings')
        sound_file = setobj.get_setting("AddSound")
        sound_player = orpg.tools.orpg_sound.orpg_sound(setobj.get_setting("UnixSoundPlayer"));
        sound_player.play(sound_file)


    def del_player(self,player):
        i = self.FindItemData(-1,int(player[2]))
        self.DeleteItem(i)

        # play sound
        setobj = self.myopenrpg.get_component('settings')
        sound_file = setobj.get_setting("DelSound")
        sound_player = orpg.tools.orpg_sound.orpg_sound(setobj.get_setting("UnixSoundPlayer"));
        sound_player.play(sound_file)

        ic = self.GetItemCount()
        self.whisperCount = 0
        index = 0
        while index < ic:
            item = self.GetItem( index )
            if item.GetImage():
                self.whisperCount += 1
            index += 1
        self.colorize_player_list()
        self.Refresh()
    
    #  This method updates the player info
    #
    #  self:  reference to this PlayerList
    #  player:  reference to a player structure(list)
    #
    #  Returns:  None
    #
    def update_player(self,player):
        i = self.FindItemData(-1,int(player[2]))  #  finds the right list box index
        self.SetStringItem(i,1,self.strip_html(player))
        self.SetStringItem(i,2,player[3])
        item = self.GetItem(i)
        self.colorize_player_list()
        self.Refresh()

    def colorize_player_list(self):
        session = self.myopenrpg.get_component("session")
        settings = self.myopenrpg.get_component('settings')
        mode = settings.get_setting("ColorizeRoles")
        if mode.lower() == "off":
            return
        players = session.players

        for m in players.keys():
            item_list_location = self.FindItemData(-1,int(m))
            if item_list_location == -1: continue
            player_info = session.get_player_by_player_id(m)
            item = self.GetItem(item_list_location)
            role = player_info[7].lower()
            color = wxGREEN
            if role == "lurker":
                color = wxColour(red=160,green=160,blue=160)
            elif role == "player":
                color = wxBLACK
            elif role == "gm":
                color = wxRED
            if self.session.group_id != "0":
                item.SetTextColour(color)
            self.SetItem(item)

    def reset(self):
        self.whisperCount = 0
        self.menu.Enable( PLAYER_WHISPER_GROUP, false )
        self.DeleteAllItems()



    def strip_html(self,player):
        ret_string = ""
        x = 0
        in_tag = 0

        for x in range(len(player[0])) :
            if player[0][x] == "<" or player[0][x] == ">" or in_tag == 1 :
                if player[0][x] == "<" :
                    in_tag = 1
                elif player[0][x] == ">" :
                    in_tag = 0
                else :
                    pass
            else :
                ret_string = ret_string + player[0][x]
        return ret_string



    def size_cols(self):
        # moved skip here to see if it breaks       
        w,h = self.GetClientSizeTuple()
        w /= 8
        self.SetColumnWidth( 0, w*2 )
        self.SetColumnWidth( 1, w*3 )
        self.SetColumnWidth( 2, w*3 )
           
