/**********************************************************************
 *
 *	FILE:			ConeSector.cpp
 *
 *	DESCRIPTION:	Read/Write osgSim::ConeSector in binary format to disk.
 *
 *	CREATED BY:		Auto generated by iveGenerator.exe
 *					and later modified by Rune Schmidt Jensen.
 *
 *	HISTORY:		Created 9.9.2003
 *
 **********************************************************************/

#include "Exception.h"
#include "ConeSector.h"

using namespace ive;

void ConeSector::write(DataOutputStream* out){
	// Write ConeSector's identification.
	out->writeInt(IVECONESECTOR);
	// Write ConeSector's properties.
	out->writeVec3(getAxis());
	out->writeFloat(getAngle());
    out->writeFloat(getFadeAngle());
}

void ConeSector::read(DataInputStream* in){
	// Peek on ConeSector's identification.
	int id = in->peekInt();
	if(id == IVECONESECTOR){
		// Read ConeSector's identification.
		id = in->readInt();
		// Read ConeSector's properties
		setAxis(in->readVec3());
        float angle = in->readFloat();
        float fadeangle = in->readFloat();;
        setAngle(angle, fadeangle);
	}
	else{
		throw Exception("ConeSector::read(): Expected ConeSector identification.");
	}
}
