/**********************************************************************
 *
 *    FILE:            TextureCubeMap.cpp
 *
 *    DESCRIPTION:    Read/Write osg::TextureCubeMap in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 21.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "TextureCubeMap.h"
#include "Texture.h"
#include "Image.h"

using namespace ive;

void TextureCubeMap::write(DataOutputStream* out){
    // Write TextureCubeMap's identification.
    out->writeInt(IVETEXTURECUBEMAP);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Texture*  tex = dynamic_cast<osg::Texture*>(this);
    if(tex){
        ((ive::Texture*)(tex))->write(out);
    }
    else
        throw Exception("TextureCubeMap::write(): Could not cast this osg::TextureCubeMap to an osg::Texture.");
    // Write TextureCubeMap's properties.

    // Write texture size
    int width,height;
    getTextureSize(width, height);
    out->writeInt(width);
    out->writeInt(height);

    // Write number of mipmap levels
    out->writeInt(getNumMipmapLevels());

    // Should we include images date in stream
    bool includeImg = out->getIncludeImageData();
    out->writeBool(includeImg);

    writeImage(out,includeImg,getImage(osg::TextureCubeMap::POSITIVE_X));
    writeImage(out,includeImg,getImage(osg::TextureCubeMap::NEGATIVE_X));
    writeImage(out,includeImg,getImage(osg::TextureCubeMap::POSITIVE_Y));
    writeImage(out,includeImg,getImage(osg::TextureCubeMap::NEGATIVE_Y));
    writeImage(out,includeImg,getImage(osg::TextureCubeMap::POSITIVE_Z));
    writeImage(out,includeImg,getImage(osg::TextureCubeMap::NEGATIVE_Z));

}


void TextureCubeMap::writeImage(DataOutputStream* out,bool includeImg,osg::Image* image)
{
    if(includeImg)
    {
        // Write images if any
        out->writeBool(image!=0);
        if(image)
            ((ive::Image*)(image))->write(out);
    }
    else
    {
        if (image && !(image->getFileName().empty())){
            out->writeString(image->getFileName());
        }
        else{ 
            out->writeString("");
        }    
    }
}

void TextureCubeMap::read(DataInputStream* in)
{
    // Peek on TextureCubeMap's identification.
    int id = in->peekInt();
    if(id == IVETEXTURECUBEMAP){
        // Read TextureCubeMap's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Texture* tex = dynamic_cast<osg::Texture*>(this);
        if(tex){
            ((ive::Texture*)(tex))->read(in);
        }
        else
            throw Exception("TextureCubeMap::read(): Could not cast this osg::TextureCubeMap to an osg::Texture.");
        // Read TextureCubeMap's properties

        // Read texture size
        int width = in->readInt();
        int height = in->readInt();
        setTextureSize(width, height);

        // Read number of mipmap levels
        setNumMipmapLevels((unsigned int)in->readInt());

        // Should we read image data from stream
        bool includeImg = in->readBool();

        setImage(osg::TextureCubeMap::POSITIVE_X,readImage(in, includeImg));
        setImage(osg::TextureCubeMap::NEGATIVE_X,readImage(in, includeImg));
        setImage(osg::TextureCubeMap::POSITIVE_Y,readImage(in, includeImg));
        setImage(osg::TextureCubeMap::NEGATIVE_Y,readImage(in, includeImg));
        setImage(osg::TextureCubeMap::POSITIVE_Z,readImage(in, includeImg));
        setImage(osg::TextureCubeMap::NEGATIVE_Z,readImage(in, includeImg));
        
    }
    else{
        throw Exception("TextureCubeMap::read(): Expected TextureCubeMap identification.");
    }
}

osg::Image* TextureCubeMap::readImage(DataInputStream* in, bool includeImg)
{        
    if(includeImg)
    {
        // Read image data from stream
        if(in->readBool())
        {
            osg::Image* image = new osg::Image();
            ((ive::Image*)image)->read(in);
            return image;
        }
    }
    else
    {
        // Only read image name from stream.
        std::string filename = in->readString();
        if(filename.compare("")!=0)
        {
            osg::Image* image = in->readImage(filename);
            return image;
        }
    }
    return 0;
}
