#ifdef WIN32
#include <windows.h>
#define usleep(x)	Sleep((x)/1000)
#else
#include <unistd.h>
#endif

#if defined( __APPLE__)
#include <OpenGL/gl.h>
#else
#include <GL/gl.h>
#endif
#include <Producer/RenderSurface>
#include <Producer/KeyboardMouse>

using namespace Producer;

class KBMCB : public KeyboardMouseCallback
{
  public:

	KBMCB(): 
			_toggleFullScreen(false),
			_toggleResize(false) ,
			_toggleCursor(false) ,
			_quit(false)
			{}

	void keyPress( KeySymbol key )
	{
		switch( key )
		{
			case 'C' :
			case 'c':
				_toggleCursor = true;
				break;

			case 'R' :
			case 'r' :
				_toggleResize = true;
				break;

			case 'F' :
			case 'f' :
				_toggleFullScreen = true;
				break;
				
			case 0xFF1B :
			case 0x1B:
				_quit = true;
				break;
		}
	}

	bool toggleFullScreen() { return checkToggle( _toggleFullScreen ); }
	bool toggleResize() { return checkToggle(_toggleResize); }
	bool toggleCursor() { return checkToggle(_toggleCursor); }
	bool quit() { return _quit; }

  private:
	bool _toggleFullScreen;
	bool _toggleResize;
	bool _toggleCursor;
	bool _quit;

	bool checkToggle( bool &toggle )
	{
		if( toggle == true )
		{
			toggle = false;
			return true;
		}
		return false;
	}

};

main()
{
	RenderSurface rs;
	rs.setWindowRect( 100, 200, 640, 480 );
	rs.useBorder(false);
	rs.useCursor(false);
	rs.realize();


	KBMCB kbmcb;
	KeyboardMouse kbm(&rs);
	kbm.setCallback( &kbmcb );
	kbm.startThread();

	bool resizeToggle = false;
	bool cursorToggle = true;

	glClearColor( 0.2f, 0.2f, 0.4f, 1.0f );
	while( !kbmcb.quit() )
	{
		usleep(25000);
		if( kbmcb.toggleFullScreen() )
		{
			if( rs.isFullScreen() )
				rs.fullScreen(false);
			else
				rs.fullScreen(true);
		}

		if( kbmcb.toggleResize() )
		{
			resizeToggle = !resizeToggle;
			if( resizeToggle )
			    rs.setWindowRect( 300, 300, 100, 100 );
			else
			    rs.setWindowRect( 100, 200, 640, 480 );
		}

		if( kbmcb.toggleCursor() )
		{
			cursorToggle = !cursorToggle;
			rs.useCursor( cursorToggle );
		}
		glClear( GL_COLOR_BUFFER_BIT );
		rs.swapBuffers();
	}

}
