/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.demos;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MenuComponent;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import java.util.Random;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.blocks.RpcDispatcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DrawRepl
implements MouseMotionListener,
WindowListener,
ActionListener,
Runnable {
    private Graphics graphics;
    private Frame mainFrame;
    private Panel panel;
    private Panel sub_panel;
    private byte[] buf;
    private ByteArrayOutputStream out;
    private DataOutputStream outstream;
    private ByteArrayInputStream inp;
    private DataInputStream instream;
    private int x;
    private int y;
    private Hashtable colors;
    private Random random;
    private int col_val;
    private Color current_color;
    private Button clear_button;
    private Button leave_button;
    private String groupname;
    private final Font default_font;
    private EventQueue event_queue;
    private Thread mythread;
    private RpcDispatcher dispatcher;
    private Channel channel;

    public static void main(String[] args) {
        DrawRepl draw = new DrawRepl();
        draw.go();
    }

    private final Color SelectColor() {
        this.col_val = Math.abs(this.random.nextInt()) % 8 + 1;
        Color ret = (Color)this.colors.get(new Integer(this.col_val));
        if (ret == null) {
            ret = Color.red;
        }
        return ret;
    }

    AWTEvent copyEvent(Component src, AWTEvent evt) {
        if (evt instanceof MouseEvent) {
            MouseEvent mev = (MouseEvent)evt;
            return new MouseEvent(src, evt.getID(), mev.getWhen(), mev.getModifiers(), mev.getX(), mev.getY(), mev.getClickCount(), mev.isPopupTrigger());
        }
        if (evt instanceof KeyEvent) {
            KeyEvent kev = (KeyEvent)evt;
            return new KeyEvent(src, evt.getID(), kev.getWhen(), kev.getModifiers(), kev.getKeyCode(), kev.getKeyChar());
        }
        if (evt instanceof ActionEvent) {
            return new ActionEvent(src, evt.getID(), ((ActionEvent)evt).getActionCommand(), ((ActionEvent)evt).getModifiers());
        }
        if (evt instanceof PaintEvent) {
            return new PaintEvent(src, evt.getID(), ((PaintEvent)evt).getUpdateRect());
        }
        if (evt instanceof FocusEvent) {
            return new FocusEvent(src, evt.getID(), ((FocusEvent)evt).isTemporary());
        }
        if (evt instanceof ComponentEvent) {
            return new ComponentEvent(src, evt.getID());
        }
        return null;
    }

    void dispatch(Object src, AWTEvent evt) {
        if (src instanceof Component) {
            ((Component)src).dispatchEvent(evt);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(evt);
        } else {
            System.err.println("++++++++++");
        }
    }

    public Component findComponent(Container parent, String comp_name) {
        Component retval = null;
        if (comp_name != null && comp_name.equals(parent.getName())) {
            return parent;
        }
        int ncomponents = parent.getComponentCount();
        Component[] components = parent.getComponents();
        int i = ncomponents - 1;
        while (i >= 0) {
            Component comp = components[i];
            if (comp != null) {
                if (comp instanceof Container) {
                    retval = this.findComponent((Container)comp, comp_name);
                    if (retval != null) {
                        return retval;
                    }
                } else if (comp_name.equals(comp.getName())) {
                    return comp;
                }
            }
            --i;
        }
        return retval;
    }

    public void processEvent(String comp_name, AWTEvent evt) {
        AWTEvent copy_evt = null;
        Component src = this.findComponent(this.mainFrame, comp_name);
        if (src == null) {
            System.err.println("processEvent(): src is null");
            return;
        }
        System.out.println("Received " + evt.getClass().getName());
        copy_evt = this.copyEvent(src, evt);
        if (copy_evt == null) {
            System.err.println("copy_evt is NULL");
            return;
        }
        this.dispatch(src, copy_evt);
    }

    void processLocally(AWTEvent evt) {
        this.dispatch(evt.getSource(), evt);
    }

    public void run() {
        while (true) {
            try {
                String comp_name;
                AWTEvent evt = this.event_queue.getNextEvent();
                Object obj = evt.getSource();
                if (obj == null) {
                    System.err.println("src is NULL");
                    continue;
                }
                if (obj instanceof Component) {
                    comp_name = ((Component)obj).getName();
                } else if (obj instanceof MenuComponent) {
                    comp_name = ((MenuComponent)obj).getName();
                } else {
                    System.err.println("src is of type " + obj.getClass().getName());
                    continue;
                }
                if (evt instanceof FocusEvent || evt instanceof PaintEvent) {
                    System.out.println(evt.getClass().getName() + " not copied");
                    this.processLocally(evt);
                    continue;
                }
                System.out.println("MCasting " + evt.getClass().getName() + " event...");
                this.dispatcher.callRemoteMethods(null, "processEvent", comp_name, evt, 6, 0L);
                continue;
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }

    public void go() {
        this.mainFrame = new Frame();
        this.panel = new Panel();
        this.sub_panel = new Panel();
        this.event_queue = this.mainFrame.getToolkit().getSystemEventQueue();
        this.mythread.start();
        this.mainFrame.setSize(200, 200);
        this.mainFrame.add("Center", this.panel);
        this.clear_button = new Button("Clear");
        this.clear_button.setFont(this.default_font);
        this.clear_button.addActionListener(this);
        this.leave_button = new Button("Exit");
        this.leave_button.setFont(this.default_font);
        this.leave_button.addActionListener(this);
        this.sub_panel.add("South", this.clear_button);
        this.sub_panel.add("South", this.leave_button);
        this.mainFrame.add("South", this.sub_panel);
        this.mainFrame.addWindowListener(this);
        this.panel.addMouseMotionListener(this);
        this.mainFrame.setVisible(true);
        this.graphics = this.panel.getGraphics();
        this.current_color = this.SelectColor();
        if (this.current_color == null) {
            this.current_color = Color.red;
        }
        this.graphics.setColor(this.current_color);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        this.graphics.fillOval(this.x, this.y, 10, 10);
    }

    public void clearPanel() {
        System.out.println("CLEAR");
        Rectangle bounds = this.panel.getBounds();
        this.graphics.clearRect(0, 0, bounds.width, bounds.height);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Clear")) {
            this.clearPanel();
        } else if (command.equals("Exit")) {
            this.mainFrame.setVisible(false);
            System.exit(0);
        } else {
            System.out.println("Unknown action");
        }
    }

    private final /* synthetic */ void this() {
        this.graphics = null;
        this.mainFrame = null;
        this.panel = null;
        this.sub_panel = null;
        this.buf = new byte[128];
        this.out = new ByteArrayOutputStream();
        this.colors = new Hashtable();
        this.random = new Random(System.currentTimeMillis());
        this.col_val = 1;
        this.current_color = Color.red;
        this.groupname = "DrawReplGroup";
        this.default_font = new Font("Helvetica", 0, 12);
        this.event_queue = null;
        this.mythread = null;
    }

    public DrawRepl() {
        this.this();
        this.colors.put(new Integer(1), Color.white);
        this.colors.put(new Integer(2), Color.black);
        this.colors.put(new Integer(3), Color.red);
        this.colors.put(new Integer(4), Color.orange);
        this.colors.put(new Integer(5), Color.green);
        this.colors.put(new Integer(6), Color.magenta);
        this.colors.put(new Integer(7), Color.cyan);
        this.colors.put(new Integer(8), Color.blue);
        this.mythread = new Thread(this);
        try {
            this.channel = new JChannel();
            this.dispatcher = new RpcDispatcher(this.channel, null, null, this);
            this.channel.connect(this.groupname);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(0);
        }
    }
}

