/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.blocks.ConnectionTable;
import org.javagroups.log.Trace;
import org.javagroups.protocols.TcpHeader;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TCP
extends Protocol
implements ConnectionTable.Receiver,
ConnectionTable.ConnectionListener {
    private ConnectionTable ct;
    private Address local_addr;
    private String group_addr;
    private InetAddress bind_addr;
    private int start_port;
    private Vector members;
    private long reaper_interval;
    private long conn_expire_time;
    boolean loopback;

    public String toString() {
        return "Protocol TCP(local address: " + this.local_addr + ')';
    }

    public String getName() {
        return "TCP";
    }

    public void startUpHandler() {
    }

    public void start() throws Exception {
        if (this.reaper_interval == 0L && this.conn_expire_time == 0L) {
            this.ct = new ConnectionTable(this, this.bind_addr, this.start_port);
        } else {
            if (this.reaper_interval == 0L) {
                this.reaper_interval = 5000L;
                Trace.warn("TCP.start()", "reaper_interval was 0, set it to " + this.reaper_interval);
            }
            if (this.conn_expire_time == 0L) {
                this.conn_expire_time = 300000L;
                Trace.warn("TCP.start()", "conn_expire_time was 0, set it to " + this.conn_expire_time);
            }
            this.ct = new ConnectionTable(this, this.bind_addr, this.start_port, this.reaper_interval, this.conn_expire_time);
        }
        this.ct.addConnectionListener(this);
        this.local_addr = this.ct.getLocalAddress();
        this.passUp(new Event(8, this.local_addr));
    }

    public void stop() {
        this.ct.stop();
    }

    public void down(Event evt) {
        if (evt.getType() != 1) {
            this.handleDownEvent(evt);
            return;
        }
        Message msg = (Message)evt.getArg();
        if (this.group_addr != null) {
            msg.putHeader(this.getName(), new TcpHeader(this.group_addr));
        }
        Address dest_addr = msg.getDest();
        if (this.observer != null) {
            this.observer.passDown(evt);
        }
        if (dest_addr == null) {
            if (this.group_addr == null) {
                Trace.warn("TCP.down()", "dest address of message is null, and sending to default address fails as group_addr is null, too ! Discarding message.");
                return;
            }
            this.sendMulticastMessage(msg);
        } else {
            this.sendUnicastMessage(msg);
        }
    }

    public void receive(Message msg) {
        TcpHeader hdr = null;
        Event evt = new Event(1, msg);
        if (this.observer != null) {
            this.observer.up(evt, this.up_queue.size());
        }
        if (Trace.trace) {
            Trace.info("TCP.receive()", "received msg " + msg);
        }
        if ((hdr = (TcpHeader)msg.removeHeader(this.getName())) != null) {
            String ch_name = null;
            if (hdr.group_addr != null) {
                ch_name = hdr.group_addr;
            }
            if (ch_name != null && !this.group_addr.equals(ch_name) && !ch_name.equals("DIAG_GROUP-BELA-322649")) {
                Trace.warn("TCP.receive()", "discarded message from different group (" + ch_name + "). Sender was " + msg.getSrc());
                return;
            }
        }
        this.passUp(evt);
    }

    public void connectionOpened(Address peer_addr) {
        if (Trace.trace) {
            Trace.info("TCP.connectionOpened()", "opened connection to " + peer_addr);
        }
    }

    public void connectionClosed(Address peer_addr) {
        if (peer_addr != null && Trace.trace) {
            Trace.info("TCP.connectionClosed()", "closed connection to " + peer_addr);
        }
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("start_port");
        if (str != null) {
            this.start_port = new Integer(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("bind_addr")) != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                Trace.fatal("TCP.setProperties()", "(bind_addr): host " + str + " not known");
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("reaper_interval")) != null) {
            this.reaper_interval = Long.parseLong(str);
            props.remove("reaper_interval");
        }
        if ((str = props.getProperty("conn_expire_time")) != null) {
            this.conn_expire_time = Long.parseLong(str);
            props.remove("conn_expire_time");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = new Boolean(str);
            props.remove("loopback");
        }
        if (props.size() > 0) {
            System.err.println("TCP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    private final void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    private final void sendUnicastMessage(Message msg) {
        IpAddress dest = (IpAddress)msg.getDest();
        if (!(dest instanceof IpAddress)) {
            Trace.error("TCP.sendUnicastMessage()", "destination address is not of type IpAddress !");
            return;
        }
        this.setSourceAddress(msg);
        if (this.loopback && this.local_addr != null && dest != null && dest.equals(this.local_addr)) {
            Message copy = msg.copy();
            Header hdr = copy.getHeader(this.getName());
            if (hdr != null && hdr instanceof TcpHeader) {
                copy.removeHeader(this.getName());
            }
            copy.setSrc(this.local_addr);
            copy.setDest(this.local_addr);
            Event evt = new Event(1, copy);
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            this.passUp(evt);
            return;
        }
        this.ct.send(msg);
    }

    private final void sendMulticastMessage(Message msg) {
        Vector mbrs = (Vector)this.members.clone();
        int i = 0;
        while (i < mbrs.size()) {
            Address dest = (Address)mbrs.elementAt(i);
            msg.setDest(dest);
            this.sendUnicastMessage(msg);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    int i = 0;
                    while (true) {
                        if (i >= tmpvec.size()) {
                            return;
                        }
                        this.members.addElement(tmpvec.elementAt(i));
                        ++i;
                    }
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                return;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(3));
                return;
            }
            case 4: {
                this.passUp(new Event(5));
                return;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.ct = null;
        this.local_addr = null;
        this.group_addr = null;
        this.bind_addr = null;
        this.start_port = 7800;
        this.members = new Vector();
        this.reaper_interval = 0L;
        this.conn_expire_time = 0L;
        this.loopback = false;
    }

    public TCP() {
        this.this();
    }
}

