/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.HashMap;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.stack.Retransmitter;
import org.javagroups.util.Queue;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AckSenderWindow
implements Retransmitter.RetransmitCommand {
    RetransmitCommand retransmit_command;
    HashMap msgs;
    long[] interval;
    Retransmitter retransmitter;
    Queue msg_queue;
    int window_size;
    int min_threshold;
    boolean use_sliding_window;
    boolean queueing;
    Protocol transport;

    public void setWindowSize(int window_size, int min_threshold) {
        this.window_size = window_size;
        this.min_threshold = min_threshold;
        if (min_threshold > window_size) {
            this.min_threshold = window_size;
            this.window_size = min_threshold;
            Trace.warn("AckSenderWindow.setWindowSize()", "min_threshold (" + min_threshold + ") has to be less than window_size ( " + window_size + "). Values are swapped");
        }
        if (this.window_size <= 0) {
            this.window_size = this.min_threshold > 0 ? (int)((double)this.min_threshold * 1.5) : 500;
            Trace.warn("AckSenderWindow.setWindowSize()", "window_size is <= 0, setting it to " + this.window_size);
        }
        if (this.min_threshold <= 0) {
            this.min_threshold = this.window_size > 0 ? (int)((double)this.window_size * 0.5) : 250;
            Trace.warn("AckSenderWindow.setWindowSize()", "min_threshold is <= 0, setting it to " + this.min_threshold);
        }
        if (Trace.trace) {
            Trace.info("AckSenderWindow.setWindowSize()", "window_size=" + this.window_size + ", min_threshold=" + this.min_threshold);
        }
        this.use_sliding_window = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            this.msgs.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
            this.retransmitter.reset();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(long seqno, Message msg) {
        Long tmp = new Long(seqno);
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            if (this.msgs.containsKey(tmp)) {
                return;
            }
            if (!this.use_sliding_window) {
                this.addMessage(seqno, tmp, msg);
            } else if (this.queueing) {
                this.addToQueue(seqno, msg);
            } else if (this.msgs.size() + 1 > this.window_size) {
                this.queueing = true;
                this.addToQueue(seqno, msg);
            } else {
                this.addMessage(seqno, tmp, msg);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ack(long seqno) {
        Long tmp = new Long(seqno);
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            block5: {
                Entry entry;
                this.msgs.remove(tmp);
                this.retransmitter.remove(seqno);
                if (!this.use_sliding_window || !this.queueing || this.msgs.size() >= this.min_threshold) break block5;
                while (this.msgs.size() < this.window_size && (entry = this.removeFromQueue()) != null) {
                    this.addMessage(entry.seqno, new Long(entry.seqno), entry.msg);
                }
                if (this.msgs.size() + 1 > this.window_size) {
                    return;
                }
                this.queueing = false;
            }
            return;
        }
    }

    public String toString() {
        return this.msgs.keySet().toString() + " (retransmitter: " + this.retransmitter.toString() + ')';
    }

    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        if (this.retransmit_command != null) {
            long i = first_seqno;
            while (i <= last_seqno) {
                Message msg = (Message)this.msgs.get(new Long(i));
                if (msg != null) {
                    this.retransmit_command.retransmit(i, msg);
                }
                ++i;
            }
        }
    }

    void addMessage(long seqno, Long tmp, Message msg) {
        if (this.transport != null) {
            this.transport.passDown(new Event(1, msg));
        }
        this.msgs.put(tmp, msg);
        this.retransmitter.add(seqno, seqno);
    }

    void addToQueue(long seqno, Message msg) {
        try {
            this.msg_queue.add(new Entry(seqno, msg));
        }
        catch (Exception ex) {
            Trace.error("AckSenderWindow.addToQueue()", "exception=" + ex);
        }
    }

    Entry removeFromQueue() {
        try {
            return this.msg_queue.size() == 0 ? null : (Entry)this.msg_queue.remove();
        }
        catch (Exception ex) {
            Trace.error("AckSenderWindow.removeFromQueue()", "exception=" + ex);
            return null;
        }
    }

    public static void main(String[] args) {
        long[] xmit_timeouts = new long[]{1000L, 2000L, 3000L, 4000L};
        AckSenderWindow win = new AckSenderWindow(new Dummy(), xmit_timeouts);
        Trace.init();
        int NUM = 1000;
        int i = 1;
        while (i < 1000) {
            win.add(i, new Message());
            ++i;
        }
        System.out.println(win);
        Util.sleep(5000L);
        i = 1;
        while (i < 1000) {
            if (i % 2 == 0) {
                win.ack(i);
            }
            ++i;
        }
        System.out.println(win);
        Util.sleep(4000L);
        i = 1;
        while (i < 1000) {
            if (i % 2 != 0) {
                win.ack(i);
            }
            ++i;
        }
        System.out.println(win);
        Util.sleep(4000L);
        System.out.println("--done--");
    }

    private final /* synthetic */ void this() {
        this.retransmit_command = null;
        this.msgs = new HashMap();
        this.interval = new long[]{1000L, 2000L, 3000L, 4000L};
        this.retransmitter = new Retransmitter(null, this);
        this.msg_queue = new Queue();
        this.window_size = -1;
        this.min_threshold = -1;
        this.use_sliding_window = false;
        this.queueing = false;
        this.transport = null;
    }

    public AckSenderWindow(RetransmitCommand com) {
        this.this();
        this.retransmit_command = com;
        this.retransmitter.setRetransmitTimeouts(this.interval);
    }

    public AckSenderWindow(RetransmitCommand com, long[] interval) {
        this.this();
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public AckSenderWindow(RetransmitCommand com, long[] interval, Protocol transport) {
        this.this();
        this.retransmit_command = com;
        this.interval = interval;
        this.transport = transport;
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    class Entry {
        long seqno;
        Message msg;

        Entry(long seqno, Message msg) {
            this.seqno = seqno;
            this.msg = msg;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Dummy
    implements RetransmitCommand {
        long last_xmit_req;
        long curr_time;

        public void retransmit(long seqno, Message msg) {
            if (Trace.trace) {
                Trace.info("Dummy.retransmit()", "seqno=" + seqno);
            }
            this.curr_time = System.currentTimeMillis();
        }

        private final /* synthetic */ void this() {
            this.last_xmit_req = 0L;
        }

        Dummy() {
            this.this();
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3);
    }
}

