# --
# Kernel/Language/it.pm - provides it language translation
# Copyright (C) 2003 Remo Catelotti <Remo.Catelotti at bull.it>
#               2003 Gabriele Santilli <gsantilli at omnibus.net>
# --
# $Id: it.pm,v 1.13 2004/08/24 08:20:42 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::it;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.13 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation Tue Aug 24 10:09:14 2004 by 

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D/%M/%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %Y %T';
    $Self->{DateInputFormat} = '%D/%M/%Y';
    $Self->{DateInputFormatLong} = '%D/%M/%Y - %T';

    %Hash = (
    # Template: AAABase
      ' 2 minutes' => ' 2 minuti',
      ' 5 minutes' => ' 5 minuti',
      ' 7 minutes' => ' 7 minuti',
      '(Click here to add)' => '',
      '...Back' => '',
      '10 minutes' => '10 minuti',
      '15 minutes' => '15 minuti',
      'Added User "%s"' => '',
      'AddLink' => 'Aggiungi link',
      'Admin-Area' => 'Area Amministrazione',
      'agent' => 'operatore',
      'Agent-Area' => '',
      'all' => 'tutti',
      'All' => 'Tutti',
      'Attention' => 'Attenzione',
      'Back' => 'Indietro',
      'before' => '',
      'Bug Report' => 'Segnala anomalie',
      'Calendar' => '',
      'Cancel' => 'Annulla',
      'change' => 'modifica',
      'Change' => 'Modifica',
      'change!' => 'Modifica!',
      'click here' => 'clicca qui',
      'Comment' => 'Commento',
      'Contract' => '',
      'Crypt' => '',
      'Crypted' => '',
      'Customer' => 'Cliente',
      'customer' => 'cliente',
      'Customer Info' => 'Informazioni Cliente',
      'day' => 'giorno',
      'day(s)' => '',
      'days' => 'giorni',
      'description' => 'descrizione',
      'Description' => 'Descrizione',
      'Directory' => '',
      'Dispatching by email To: field.' => 'Smistamento in base al campo To:.',
      'Dispatching by selected Queue.' => 'Smistamento in base alla coda selezionata.',
      'Don\'t show closed Tickets' => '',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Non lavorare con l\'operatore con ID 1 (System account)! Crea dei nuovi utenti!',
      'Done' => 'Fatto',
      'end' => 'fine pagina',
      'Error' => 'Errore',
      'Example' => 'Esempio',
      'Examples' => 'Esempi',
      'Facility' => 'Funzione',
      'FAQ-Area' => '',
      'Feature not active!' => 'Funzione non attiva!',
      'go' => 'vai',
      'go!' => 'vai!',
      'Group' => 'Gruppo',
      'History::AddNote' => 'Added note (%s)',
      'History::Bounce' => 'Bounced to "%s".',
      'History::CustomerUpdate' => 'Updated: %s',
      'History::EmailAgent' => 'Email sent to customer.',
      'History::EmailCustomer' => 'Added email. %s',
      'History::FollowUp' => 'FollowUp for [%s]. %s',
      'History::Forward' => 'Forwarded to "%s".',
      'History::Lock' => 'Locked ticket.',
      'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
      'History::Misc' => '%s',
      'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
      'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
      'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
      'History::PhoneCallAgent' => 'Agent called customer.',
      'History::PhoneCallCustomer' => 'Customer called us.',
      'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
      'History::Remove' => '%s',
      'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
      'History::SendAnswer' => 'Email sent to "%s".',
      'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
      'History::SendAutoReject' => 'AutoReject sent to "%s".',
      'History::SendAutoReply' => 'AutoReply sent to "%s".',
      'History::SendCustomerNotification' => 'Notification sent to "%s".',
      'History::SetPendingTime' => 'Updated: %s',
      'History::StateUpdate' => 'Old: "%s" New: "%s"',
      'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
      'History::TicketLinkAdd' => 'Added link to ticket "%s".',
      'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',
      'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
      'History::Unlock' => 'Unlocked ticket.',
      'History::WebRequestCustomer' => 'Customer request via web.',
      'Hit' => 'Accesso',
      'Hits' => 'Accessi',
      'hour' => 'ora',
      'hours' => 'ore',
      'Ignore' => 'Ignora',
      'invalid' => 'non valido',
      'Invalid SessionID!' => 'ID di sessione non valido!',
      'Language' => 'Lingua',
      'Languages' => 'Lingue',
      'last' => '',
      'Line' => 'Linea',
      'Lite' => '',
      'Login failed! Your username or password was entered incorrectly.' => 'Accesso fallito! Nome utente o password non corretti.',
      'Logout successful. Thank you for using OTRS!' => 'Disconnessione avvenuta con successo. Grazie per aver usato OTRS!',
      'Message' => 'Messaggio',
      'minute' => 'minuto',
      'minutes' => 'minuti',
      'Module' => 'Modulo',
      'Modulefile' => 'Archivio del modulo',
      'month(s)' => '',
      'Name' => 'Nome',
      'New Article' => '',
      'New message' => 'Nuovo messaggio',
      'New message!' => 'Nuovo messaggio!',
      'Next' => '',
      'Next...' => '',
      'No' => 'No',
      'no' => 'no',
      'No entry found!' => 'Vuoto!',
      'No Permission!' => '',
      'No such Ticket Number "%s"! Can\'t link it!' => '',
      'No suggestions' => 'Non ci sono suggerimenti',
      'none' => 'nessuno',
      'none - answered' => 'nessuno - risposto',
      'none!' => 'nessuno!',
      'Normal' => '',
      'off' => 'spento',
      'Off' => 'Spento',
      'On' => 'Acceso',
      'on' => 'acceso',
      'Online Agent: %s' => '',
      'Online Customer: %s' => '',
      'Password' => 'Password',
      'Passwords dosn\'t match! Please try it again!' => '',
      'Pending till' => 'In attesa per',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Per favore rispondi a questi ticket prima di tornare alla lista dei ticket!',
      'Please contact your admin' => 'Per favore contatta il tuo amministratore',
      'please do not edit!' => 'per favore non modificare!',
      'possible' => 'possibile',
      'Preview' => '',
      'QueueView' => 'Lista ticket',
      'reject' => 'respinto',
      'replace with' => 'sostituisci con',
      'Reset' => 'Ripristina',
      'Salutation' => 'Titolo',
      'Session has timed out. Please log in again.' => 'Sessione scaduta. Per favore, effettua di nuovo l\'accesso.',
      'Show closed Tickets' => '',
      'Sign' => '',
      'Signature' => 'Firme',
      'Signed' => '',
      'Size' => '',
      'Sorry' => 'Spiacente',
      'Stats' => 'Statistiche',
      'Subfunction' => 'Sotto-funzione',
      'submit' => 'Accetta',
      'submit!' => 'accetta!',
      'system' => 'sistema',
      'Take this Customer' => '',
      'Take this User' => 'Prendi questo Utente',
      'Text' => 'Testo',
      'The recommended charset for your language is %s!' => 'Il set di caratteri raccomandato per la tua lingua  %s!',
      'Theme' => 'Tema',
      'There is no account with that login name.' => 'Nome utente non valido.',
      'Ticket Number' => '',
      'Timeover' => 'Tempo scaduto',
      'To: (%s) replaced with database email!' => '',
      'top' => 'inizio pagina',
      'Type' => 'Tipo',
      'update' => 'aggiorna',
      'Update' => '',
      'update!' => 'aggiorna!',
      'Upload' => '',
      'User' => 'Utenti',
      'Username' => 'Nome utente',
      'Valid' => 'Valido',
      'Warning' => 'Attenzione',
      'week(s)' => '',
      'Welcome to OTRS' => 'Benvenuto in OTRS',
      'Word' => 'Parola',
      'wrote' => 'ha scritto',
      'year(s)' => '',
      'Yes' => 'S',
      'yes' => 's',
      'You got new message!' => 'Hai un nuovo messaggio!',
      'You have %s new message(s)!' => 'Hai %s nuovi messaggi!',
      'You have %s reminder ticket(s)!' => 'Hai %s ticket(s) memorizzati',

    # Template: AAAMonth
      'Apr' => 'Apr',
      'Aug' => 'Ago',
      'Dec' => 'Dic',
      'Feb' => 'Feb',
      'Jan' => 'Gen',
      'Jul' => 'Lug',
      'Jun' => 'Giu',
      'Mar' => 'Mar',
      'May' => 'Mag',
      'Nov' => 'Nov',
      'Oct' => 'Ott',
      'Sep' => 'Set',

    # Template: AAAPreferences
      'Closed Tickets' => 'Ticket chiusi',
      'CreateTicket' => '',
      'Custom Queue' => 'Coda personale',
      'Follow up notification' => 'Notifica di risposta',
      'Frontend' => 'Interfaccia',
      'Mail Management' => 'Gestione posta',
      'Max. shown Tickets a page in Overview.' => '',
      'Max. shown Tickets a page in QueueView.' => '',
      'Move notification' => 'Notifica spostamento',
      'New ticket notification' => 'Notifica nuovo ticket',
      'Other Options' => 'Altre opzioni',
      'PhoneView' => 'Inserisci ticket',
      'Preferences updated successfully!' => 'Preferenze modificate con successo!',
      'QueueView refresh time' => 'Tempo di aggiornamento lista ticket',
      'Screen after new ticket' => '',
      'Select your default spelling dictionary.' => 'Seleziona il dizionario',
      'Select your frontend Charset.' => 'Seleziona il set di caratteri da usare.',
      'Select your frontend language.' => 'Scegli la lingua per la tua interfaccia.',
      'Select your frontend QueueView.' => 'Scegli l\'interfaccia per la lista messaggi.',
      'Select your frontend Theme.' => 'Scegli il tema per la tua interfaccia.',
      'Select your QueueView refresh time.' => 'Scegli il tempo di aggiornamento della lista ticket.',
      'Select your screen after creating a new ticket.' => '',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Mandami una notifica se un cliente risponde ad un ticket che ho io in gestione.',
      'Send me a notification if a ticket is moved into one of "My Queues".' => '',
      'Send me a notification if a ticket is unlocked by the system.' => 'Mandami una notifica se un ticket viene sbloccato dal sistema.',
      'Send me a notification if there is a new ticket in "My Queues".' => '',
      'Show closed tickets.' => 'Mostra i ticket chiusi.',
      'Spelling Dictionary' => 'Dizionario',
      'Ticket lock timeout notification' => 'Notifica scadenza gestione ticket',
      'TicketZoom' => '',

    # Template: AAATicket
      '1 very low' => '1 molto bassa',
      '2 low' => '2 bassa',
      '3 normal' => '3 normale',
      '4 high' => '4 alta',
      '5 very high' => '5 molto alta',
      'Action' => 'Azione',
      'Age' => 'Tempo trascorso',
      'Article' => 'Articolo',
      'Attachment' => 'Allegato',
      'Attachments' => 'Allegati',
      'Bcc' => 'Ccn',
      'Bounce' => 'Rispedisci al mittente',
      'Cc' => 'Cc',
      'Close' => 'Chiudi',
      'closed' => '',
      'closed successful' => 'chiuso',
      'closed unsuccessful' => 'non risolto',
      'Compose' => 'Componi',
      'Created' => 'Creato',
      'Createtime' => 'Creato alle',
      'email' => 'eMail',
      'eMail' => '',
      'email-external' => 'eMail esterna',
      'email-internal' => 'eMail interna',
      'Forward' => 'Inoltra',
      'From' => 'Da',
      'high' => 'alto',
      'History' => 'Storico',
      'If it is not displayed correctly,' => 'Se non  visualizzato correttamente,',
      'lock' => 'prendi in gestione',
      'Lock' => 'Prendi in gestione',
      'low' => 'basso',
      'Move' => 'Sposta',
      'new' => 'nuovo',
      'normal' => 'normale',
      'note-external' => 'Nota esterna',
      'note-internal' => 'Nota interna',
      'note-report' => 'Nota report',
      'open' => 'aperto',
      'Owner' => 'Operatore',
      'Pending' => 'In attesa',
      'pending auto close+' => 'in attesa di chiusura automatica+',
      'pending auto close-' => 'in attesa di chiusura automatica-',
      'pending reminder' => 'in attesa di risposta',
      'phone' => 'Telefono',
      'plain' => '',
      'Priority' => 'Priorit',
      'Queue' => 'Coda',
      'removed' => 'rimosso',
      'Sender' => 'Mittente',
      'sms' => '',
      'State' => 'Stato',
      'Subject' => 'Oggetto',
      'This is a' => 'Questo  un',
      'This is a HTML email. Click here to show it.' => 'Questa  una email in HTML. Clicca qui per visualizzarla.',
      'This message was written in a character set other than your own.' => 'Questo messaggio  stato scritto in un set di caratteri diverso dal tuo.',
      'Ticket' => '',
      'Ticket "%s" created!' => '',
      'To' => 'A',
      'to open it in a new window.' => 'per aprirlo in una nuova finestra.',
      'Unlock' => 'Abbandona gestione',
      'unlock' => 'abbandona gestione',
      'very high' => 'molto alto',
      'very low' => 'molto basso',
      'View' => 'Vista',
      'webrequest' => 'richiesta da web',
      'Zoom' => 'Dettagli',

    # Template: AAAWeekDay
      'Fri' => 'Ven',
      'Mon' => 'Lun',
      'Sat' => 'Sab',
      'Sun' => 'Dom',
      'Thu' => 'Mar',
      'Tue' => 'Gio',
      'Wed' => 'Mer',

    # Template: AdminAttachmentForm
      'Add' => '',
      'Attachment Management' => 'Gestione allegati',

    # Template: AdminAutoResponseForm
      'Auto Response From' => 'Risposta automatica da',
      'Auto Response Management' => 'Gestione risposte automatiche',
      'Note' => 'Nota',
      'Response' => 'Risposta',
      'to get the first 20 character of the subject' => 'per avere i primi 20 caratteri dell\'oggetto',
      'to get the first 5 lines of the email' => 'per avere le prime 5 linee del messaggio',
      'to get the from line of the email' => 'per avere il mittente del messaggio',
      'to get the realname of the sender (if given)' => 'per avere il nome del mittente (se indicato)',
      'to get the ticket id of the ticket' => 'per avere l\'id del ticket',
      'to get the ticket number of the ticket' => 'per avere il numero del ticket',
      'Useable options' => 'Opzioni utilizzabili',

    # Template: AdminCustomerUserForm
      'Customer User Management' => 'Gestione clienti',
      'Customer user will be needed to have an customer histor and to to login via customer panels.' => '',
      'Result' => '',
      'Search' => '',
      'Search for' => '',
      'Select Source (for add)' => '',
      'Source' => '',
      'The message being composed has been closed.  Exiting.' => 'La finestra con il messaggio che si stava componendo  stata chiusa. Sto uscendo.',
      'This values are read only.' => '',
      'This values are required.' => '',
      'This window must be called from compose window' => 'Questa finestra deve essere aperta dalla finestra di composizione dei mesaggi',

    # Template: AdminCustomerUserGroupChangeForm
      'Change %s settings' => 'Modifica impostazioni di %s',
      'Customer User <-> Group Management' => '',
      'Full read and write access to the tickets in this group/queue.' => '',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => '',
      'Permission' => 'Permessi',
      'Read only access to the ticket in this group/queue.' => '',
      'ro' => '',
      'rw' => '',
      'Select the user:group permissions.' => '',

    # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'Modifica impostazioni Utente <-> Gruppo',

    # Template: AdminEmail
      'Admin-Email' => 'Invia messaggio agli operatori',
      'Body' => 'Testo',
      'OTRS-Admin Info!' => 'Informazioni dall\'amministratore di OTRS',
      'Recipents' => 'Destinatari',
      'send' => 'Invia',

    # Template: AdminEmailSent
      'Message sent to' => 'Messaggio inviato a',

    # Template: AdminGenericAgent
      '(e. g. 10*5155 or 105658*)' => '',
      '(e. g. 234321)' => '',
      '(e. g. U5150)' => '',
      '-' => '',
      'Add Note' => 'Aggiungi nota',
      'Agent' => '',
      'and' => '',
      'CMD' => '',
      'Customer User Login' => '',
      'CustomerID' => 'Codice cliente',
      'CustomerUser' => 'Cliente',
      'Days' => '',
      'Delete' => '',
      'Delete tickets' => '',
      'Edit' => '',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => '',
      'GenericAgent' => '',
      'Hours' => '',
      'Job-List' => '',
      'Jobs' => '',
      'Last run' => '',
      'Minutes' => '',
      'Modules' => '',
      'New Agent' => '',
      'New Customer' => '',
      'New Owner' => '',
      'New Priority' => '',
      'New Queue' => 'Nuova coda ',
      'New State' => '',
      'New Ticket Lock' => '',
      'No time settings.' => '',
      'Param 1' => '',
      'Param 2' => '',
      'Param 3' => '',
      'Param 4' => '',
      'Param 5' => '',
      'Param 6' => '',
      'Save' => '',
      'Save Job as?' => '',
      'Schedule' => '',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '',
      'Ticket created' => '',
      'Ticket created between' => '',
      'Ticket Lock' => '',
      'TicketFreeText' => '',
      'Times' => '',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => '',

    # Template: AdminGroupForm
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Creare nuovi gruppi per gestire i permessi di accesso per diversi gruppi di agenti (p.es. sezione vendite, supporto tecnico, ecc.)',
      'Group Management' => 'Gestione gruppo',
      'It\'s useful for ASP solutions.' => ' utile per soluzioni ASP',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Il gruppo admin ha accesso all\'area amministrazione mentre il gruppo stats ha accesso alle statistiche.',

    # Template: AdminLog
      'System Log' => 'Log di sistema',
      'Time' => '',

    # Template: AdminNavigationBar
      'AdminEmail' => 'Messaggio agli operatori',
      'Attachment <-> Response' => 'Allegati <-> Risposte',
      'Auto Response <-> Queue' => 'Risposte automatiche <-> Code',
      'Auto Responses' => 'Risposte automatiche',
      'Customer User' => 'Clienti',
      'Customer User <-> Groups' => '',
      'Email Addresses' => 'Indirizzi Email',
      'Groups' => 'Gruppi',
      'Logout' => 'Esci',
      'Misc' => 'Varie',
      'Notifications' => '',
      'PGP Keys' => '',
      'PostMaster Filter' => '',
      'PostMaster POP3 Account' => 'PostMaster Impostazioni POP3',
      'Responses' => 'Risposte',
      'Responses <-> Queue' => 'Risposte <-> Code',
      'Role' => '',
      'Role <-> Group' => '',
      'Role <-> User' => '',
      'Roles' => '',
      'Select Box' => 'Selezionare una funzione',
      'Session Management' => 'Gestione sessioni',
      'SMIME Certificates' => '',
      'Status' => 'Stato',
      'System' => 'Sistema',
      'User <-> Groups' => 'Utenti <-> Gruppi',

    # Template: AdminNotificationForm
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
      'Notification Management' => '',
      'Notifications are sent to an agent or a customer.' => '',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => '',

    # Template: AdminPGPForm
      'Bit' => '',
      'Expires' => '',
      'File' => '',
      'Fingerprint' => '',
      'FIXME: WHAT IS PGP?' => '',
      'Identifier' => '',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => '',
      'Key' => 'Etichetta',
      'PGP Key Management' => '',

    # Template: AdminPOP3Form
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Tutti i messaggi in arrivo saranno smistati nella coda selezionata!',
      'Dispatching' => 'Smistamento',
      'Host' => '',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',
      'POP3 Account Management' => 'Gestione accessi POP3',
      'Trusted' => 'Fidato',

    # Template: AdminPostMasterFilter
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '',
      'Filtername' => '',
      'Header' => '',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',
      'Match' => '',
      'PostMaster Filter Management' => '',
      'Set' => '',
      'Value' => 'Valore',

    # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Response Management' => 'Gestione Code <-> Risposte automatiche',

    # Template: AdminQueueAutoResponseTable

    # Template: AdminQueueForm
      '0 = no escalation' => '0 = nessuna escalation',
      '0 = no unlock' => '0 = nessuno sblocco automatico',
      'Customer Move Notify' => 'Notifica il cliente degli spostamenti',
      'Customer Owner Notify' => 'Notifica il cliente del cambio operatore',
      'Customer State Notify' => 'Notifica il cliente del cambio di stato',
      'Escalation time' => 'Tempo di escalation',
      'Follow up Option' => 'Opzioni per le risposte',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Se un ticket  chiuso e il cliente invia una risposta, il ticket viene assegnato al vecchio operatore.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Se un ticket non viene risposto entro questo limite di tempo, sar l\'unico ticket ad essere mostrato.',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Se un operatore prende in gestione un ticket ma non risponde entro il tempo specificato, il ticket viene sbloccato in modo da essere accessibile agli altri operatori.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS invia una notifica via email al cliente se il ticket viene spostato.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS invia una notifica via email al cliente se l\'operatore assegnato al ticket cambia.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS invia una notifica via email al cliente se lo stato del ticket cambia.',
      'Queue Management' => 'Gestione delle code',
      'Sub-Queue of' => 'Sottocoda di',
      'Systemaddress' => 'Indirizzo di sistema',
      'The salutation for email answers.' => 'Il saluto generato automaticamente per le risposte via email.',
      'The signature for email answers.' => 'La firma generata automaticamente per le risposte via email.',
      'Ticket lock after a follow up' => 'Assegnazione ticket dopo una risposta',
      'Unlock timeout' => 'Tempo di sblocco automatico',
      'Will be the sender address of this queue for email answers.' => 'Sar l\'indirizzo email usato come mittente per le risposte inviate via email.',

    # Template: AdminQueueResponsesChangeForm
      'Std. Responses <-> Queue Management' => 'Gestione Risposte standard <-> Code',

    # Template: AdminQueueResponsesForm
      'Answer' => 'Risposta',

    # Template: AdminResponseAttachmentChangeForm
      'Std. Responses <-> Std. Attachment Management' => 'Gestione Risposte standard <-> Allegati standard',

    # Template: AdminResponseAttachmentForm

    # Template: AdminResponseForm
      'A response is default text to write faster answer (with default text) to customers.' => 'Una risposta  un testo predefinito usato per compilare pi rapidamente le risposte per i clienti.',
      'All Customer variables like defined in config option CustomerUser.' => '',
      'Don\'t forget to add a new response a queue!' => 'Non dimenticare di aggiungere una risposta per ogni coda!',
      'Next state' => 'Stato successivo',
      'Response Management' => 'Gestione risposte',
      'The current ticket state is' => '',
      'Your email address is new' => '',

    # Template: AdminRoleForm
      'Create a role and put groups in it. Then add the role to the users.' => '',
      'It\'s useful for a lot of users and groups.' => '',
      'Role Management' => '',

    # Template: AdminRoleGroupChangeForm
      'create' => 'crea',
      'move_into' => '',
      'owner' => '',
      'Permissions to change the ticket owner in this group/queue.' => '',
      'Permissions to change the ticket priority in this group/queue.' => '',
      'Permissions to create tickets in this group/queue.' => '',
      'Permissions to move tickets into this group/queue.' => '',
      'priority' => '',
      'Role <-> Group Management' => '',

    # Template: AdminRoleGroupForm
      'Change role <-> group settings' => '',

    # Template: AdminRoleUserChangeForm
      'Active' => '',
      'Role <-> User Management' => '',
      'Select the role:user relations.' => '',

    # Template: AdminRoleUserForm
      'Change user <-> role settings' => '',

    # Template: AdminSMIMEForm
      'Add Certificate' => '',
      'Add Private Key' => '',
      'FIXME: WHAT IS SMIME?' => '',
      'Hash' => '',
      'In this way you can directly edit the certification and private keys in file system.' => '',
      'Secret' => '',
      'SMIME Certificate Management' => '',

    # Template: AdminSalutationForm
      'customer realname' => 'nome del cliente',
      'for agent firstname' => 'per il nome dell\'operatore',
      'for agent lastname' => 'per il cognome dell\'operatore',
      'for agent login' => 'per il nome utente dell\'operatore',
      'for agent user id' => 'per l\'id utente dell\'operatore',
      'Salutation Management' => 'Gestione saluti',

    # Template: AdminSelectBoxForm
      'Limit' => 'Limite',
      'SQL' => '',

    # Template: AdminSelectBoxResult
      'Select Box Result' => 'Seleziona il risultato',

    # Template: AdminSession
      'kill all sessions' => 'Termina tutte le sessioni',
      'kill session' => 'Termina sessione',
      'Overview' => '',
      'Session' => '',
      'Sessions' => '',
      'Uniq' => '',

    # Template: AdminSignatureForm
      'Signature Management' => 'Gestione firme',

    # Template: AdminStateForm
      'See also' => '',
      'State Type' => 'Tipologia',
      'System State Management' => 'Gestione stati ticket',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => '',

    # Template: AdminSystemAddressForm
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Tutte le email in arrivo indirizzate a questo indirizzo (campo To:) saranno smistate nella coda selezionata!',
      'Email' => 'eMail',
      'Realname' => 'Nome',
      'System Email Addresses Management' => 'Gestione indirizzi di sistema',

    # Template: AdminUserForm
      'Don\'t forget to add a new user to groups!' => 'Non dimenticare di aggiungere i nuovi operatori ad un gruppo!',
      'Firstname' => 'Nome',
      'Lastname' => 'Cognome',
      'User Management' => 'Gestione operatori',
      'User will be needed to handle tickets.' => 'Gli operatori sono necessari per gestire i ticket.',

    # Template: AdminUserGroupChangeForm
      'User <-> Group Management' => 'Gestione Utenti <-> Gruppi',

    # Template: AdminUserGroupForm

    # Template: AgentBook
      'Address Book' => '',
      'Discard all changes and return to the compose screen' => 'Annulla tutte le modifiche e torna alla composizione del messaggio',
      'Return to the compose screen' => 'Torna alla composizione del messaggio',

    # Template: AgentBounce
      'A message should have a To: recipient!' => 'Manca il destinatario del messaggio!',
      'Bounce ticket' => 'Rispedisci al mittente',
      'Bounce to' => 'Rispedisci a',
      'Inform sender' => 'Informa il mittente',
      'Next ticket state' => 'Stato successivo del ticket',
      'Send mail!' => 'Invia messaggio!',
      'You need a email address (e. g. customer@example.com) in To:!' => ' necessario inserire un indirizzo email (p.es. cliente@esempio.it) come destinatario!',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'La tua email con il numero di ticket "<OTRS_TICKET>" assegnato a "<OTRS_BOUNCE_TO>". Contattare questo indirizzo per ulteriori informazioni.',

    # Template: AgentBulk
      '$Text{"Note!' => '',
      'A message should have a subject!' => 'Il messaggio deve avere un oggetto!',
      'Note type' => 'Tipologia della nota',
      'Note!' => 'Nota!',
      'Options' => 'Opzioni',
      'Spell Check' => 'Verifica ortografica',
      'Ticket Bulk Action' => '',

    # Template: AgentClose
      ' (work units)' => ' (unit di lavoro)',
      'A message should have a body!' => '',
      'Close ticket' => 'Ticket chiuso',
      'Close type' => 'Tipologia chiusura',
      'Close!' => 'Ticket Chiuso!',
      'Note Text' => 'Nota',
      'Time units' => 'Tempo',
      'You need to account time!' => 'Devi inserire il tempo speso per la risposta!',

    # Template: AgentCompose
      'A message must be spell checked!' => 'Il messaggio deve subire il controllo ortografico!',
      'Attach' => 'Allega',
      'Compose answer for ticket' => 'Componi la risposta per il ticket',
      'for pending* states' => 'per gli stati di attesa*',
      'Is the ticket answered' => 'Il ticket  stato risposto?',
      'Pending Date' => 'Attesa fino a',

    # Template: AgentCrypt

    # Template: AgentCustomer
      'Change customer of ticket' => 'Modifica il cliente del ticket',
      'Search Customer' => 'Ricerca cliente',
      'Set customer user and customer id of a ticket' => 'Imposta l\'id cliente di un ticket',

    # Template: AgentCustomerHistory
      'All customer tickets.' => '',
      'Customer history' => 'Storico del cliente',

    # Template: AgentCustomerMessage
      'Follow up' => 'Risposta',

    # Template: AgentCustomerView
      'Customer Data' => 'Dati del cliente',

    # Template: AgentEmailNew
      'All Agents' => '',
      'Clear To' => '',
      'Compose Email' => '',
      'new ticket' => 'Nuovo Ticket',

    # Template: AgentForward
      'Article type' => 'Tipo articolo',
      'Date' => 'Data',
      'End forwarded message' => 'Fine del messaggio inoltrato',
      'Forward article of ticket' => 'Inoltro articolo del ticket',
      'Forwarded message from' => 'Messaggio inoltrato da',
      'Reply-To' => 'Rispondi a',

    # Template: AgentFreeText
      'Change free text of ticket' => 'Cambia il testo del ticket',

    # Template: AgentHistoryForm
      'History of' => 'Storico di',

    # Template: AgentHistoryRow

    # Template: AgentInfo
      'Info' => 'Informazioni',

    # Template: AgentLookup
      'Lookup' => '',

    # Template: AgentMailboxNavBar
      'All messages' => 'Tutti i messaggi',
      'down' => 'decrescente',
      'Mailbox' => '',
      'New' => 'Nuovi',
      'New messages' => 'Nuovi messaggi',
      'Open' => 'Aperti',
      'Open messages' => 'Messaggi aperti',
      'Order' => 'Ordine',
      'Pending messages' => 'Messaggi in attesa',
      'Reminder' => 'Richiamo',
      'Reminder messages' => 'Messaggio di richiamo',
      'Sort by' => 'Ordina per',
      'Tickets' => 'Ticket',
      'up' => 'crescente',

    # Template: AgentMailboxTicket
      '"}' => '',
      '"}","14' => '',
      'Add a note to this ticket!' => '',
      'Change the ticket customer!' => '',
      'Change the ticket owner!' => '',
      'Change the ticket priority!' => '',
      'Close this ticket!' => '',
      'Shows the detail view of this ticket!' => '',
      'Unlock this ticket!' => '',

    # Template: AgentMove
      'Move Ticket' => 'Sposta il ticket',
      'Previous Owner' => '',
      'Queue ID' => '',

    # Template: AgentNavigationBar
      'Agent Preferences' => '',
      'Bulk Action' => '',
      'Bulk Actions on Tickets' => '',
      'Create new Email Ticket' => '',
      'Create new Phone Ticket' => '',
      'Email-Ticket' => '',
      'Locked tickets' => 'Ticket in gestione',
      'new message' => 'Nuovi messaggi',
      'Overview of all open Tickets' => '',
      'Phone-Ticket' => '',
      'Preferences' => 'Preferenze',
      'Search Tickets' => '',
      'Ticket selected for bulk action!' => '',
      'You need min. one selected Ticket!' => '',

    # Template: AgentNote
      'Add note to ticket' => 'Aggiungi una nota al ticket',

    # Template: AgentOwner
      'Change owner of ticket' => 'Assegna il ticket ad un altro operatore',
      'Message for new Owner' => 'Messaggio per l\'operatore',

    # Template: AgentPending
      'Pending date' => 'In attesa fino a',
      'Pending type' => 'Tipo di attesa',
      'Set Pending' => 'Imposta attesa',

    # Template: AgentPhone
      'Phone call' => 'Chiamata telefonica',

    # Template: AgentPhoneNew
      'Clear From' => 'Cancella il campo mittente',

    # Template: AgentPlain
      'ArticleID' => 'Codice articolo',
      'Download' => '',
      'Plain' => '',
      'TicketID' => 'Codice ticket',

    # Template: AgentPreferencesCustomQueue
      'My Queues' => '',
      'You also get notified about this queues via email if enabled.' => '',
      'Your queue selection of your favorite queues.' => '',

    # Template: AgentPreferencesForm

    # Template: AgentPreferencesGeneric

    # Template: AgentPreferencesPassword
      'Change Password' => 'Cambia password',
      'New password' => 'Nuova password',
      'New password again' => 'Nuova password (conferma)',

    # Template: AgentPriority
      'Change priority of ticket' => 'Modifica la priorit del ticket',

    # Template: AgentSpelling
      'Apply these changes' => 'Applica le modifiche',
      'Spell Checker' => 'Verifica ortografica',
      'spelling error(s)' => 'Errori di ortografia',

    # Template: AgentStatusView
      'D' => 'D',
      'of' => 'di',
      'Site' => 'Pagina',
      'sort downward' => 'ordine decrescente',
      'sort upward' => 'ordine crescente',
      'Ticket Status' => 'Stato ticket',
      'U' => 'C',

    # Template: AgentTicketLink
      'Delete Link' => '',
      'Link' => '',
      'Link to' => '',

    # Template: AgentTicketLocked
      'Ticket locked!' => 'Ticket gi preso in gestione!',
      'Ticket unlock!' => 'Ticket libero!',

    # Template: AgentTicketPrint

    # Template: AgentTicketPrintHeader
      'Accounted time' => 'Tempo addebitato',
      'Escalation in' => '',

    # Template: AgentUtilSearch
      'Profile' => '',
      'Result Form' => '',
      'Save Search-Profile as Template?' => '',
      'Search-Template' => '',
      'Select' => '',
      'Ticket Search' => 'Ricerca Ticket',
      'Yes, save it with name' => '',

    # Template: AgentUtilSearchByCustomerID
      'Customer history search' => 'Ricerca storico cliente',
      'Customer history search (e. g. "ID342425").' => 'Ricerca storico cliente (es: "ID342425")',
      'No * possible!' => 'Qui non  possibile usare l\'asterisco (*)!',

    # Template: AgentUtilSearchResult
      'Change search options' => '',
      'Results' => 'Risultati',
      'Search Result' => '',
      'Total hits' => 'Totale risultati',

    # Template: AgentUtilSearchResultPrint

    # Template: AgentUtilSearchResultShort

    # Template: AgentUtilTicketStatus
      'All closed tickets' => 'Tutti i ticket chiusi',
      'All open tickets' => 'Tutti i ticket aperti',
      'closed tickets' => 'ticket chiusi',
      'open tickets' => 'ticket aperti',
      'or' => 'oppure',
      'Provides an overview of all' => 'Visione generale di tutti i',
      'So you see what is going on in your system.' => 'Per vedere come vanno le cose nel sistema.',

    # Template: AgentZoomAgentIsCustomer
      'Compose Follow up' => 'Componi risposta',
      'Your own Ticket' => 'I tuoi ticket',

    # Template: AgentZoomAnswer
      'Compose Answer' => 'Componi risposta',
      'Contact customer' => 'Contatta il cliente',
      'phone call' => 'chiamata telefonica',

    # Template: AgentZoomArticle
      'Split' => 'Spezza',

    # Template: AgentZoomBody
      'Change queue' => 'Cambia coda',

    # Template: AgentZoomHead
      'Change the ticket free fields!' => '',
      'Free Fields' => 'Campi liberi',
      'Link this ticket to an other one!' => '',
      'Lock it to work on it!' => '',
      'Print' => 'Stampa',
      'Print this ticket!' => '',
      'Set this ticket to pending!' => '',
      'Shows the ticket history!' => '',

    # Template: AgentZoomStatus
      '"}","18' => '',
      'Locked' => '',
      'SLA Age' => '',

    # Template: Copyright
      'printed by' => 'stampato da',

    # Template: CustomerAccept

    # Template: CustomerCreateAccount
      'Create Account' => 'Registrati',
      'Login' => '',

    # Template: CustomerError
      'Traceback' => '',

    # Template: CustomerFAQArticleHistory
      'FAQ History' => '',

    # Template: CustomerFAQArticlePrint
      'Category' => '',
      'Keywords' => '',
      'Last update' => '',
      'Problem' => '',
      'Solution' => '',
      'Symptom' => '',

    # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => '',

    # Template: CustomerFAQArticleView
      'FAQ Article' => '',
      'Modified' => '',

    # Template: CustomerFAQOverview
      'FAQ Overview' => '',

    # Template: CustomerFAQSearch
      'FAQ Search' => '',
      'Fulltext' => '',
      'Keyword' => '',

    # Template: CustomerFAQSearchResult
      'FAQ Search Result' => '',

    # Template: CustomerFooter
      'Powered by' => '',

    # Template: CustomerLostPassword
      'Lost your password?' => 'Hai dimenticato la tua password?',
      'Request new password' => 'Richiedi password',

    # Template: CustomerMessage

    # Template: CustomerMessageNew

    # Template: CustomerNavigationBar
      'CompanyTickets' => '',
      'Create new Ticket' => 'Crea nuovo Ticket',
      'FAQ' => 'FAQ',
      'MyTickets' => '',
      'New Ticket' => 'Nuovo Ticket',
      'Welcome %s' => 'Benvenuto %s',

    # Template: CustomerPreferencesForm

    # Template: CustomerPreferencesGeneric

    # Template: CustomerPreferencesPassword

    # Template: CustomerStatusView

    # Template: CustomerTicketSearch

    # Template: CustomerTicketSearchResultPrint

    # Template: CustomerTicketSearchResultShort

    # Template: CustomerTicketZoom

    # Template: CustomerWarning

    # Template: Error
      'Click here to report a bug!' => 'Clicca qui per segnalare un bug!',

    # Template: FAQArticleDelete
      'FAQ Delete' => '',
      'You really want to delete this article?' => '',

    # Template: FAQArticleForm
      'A article should have a title!' => '',
      'Comment (internal)' => '',
      'Filename' => '',
      'Title' => '',

    # Template: FAQArticleHistory

    # Template: FAQArticlePrint

    # Template: FAQArticleSystemHistory

    # Template: FAQArticleView

    # Template: FAQArticleViewSmall

    # Template: FAQCategoryForm
      'FAQ Category' => '',
      'Name is required!' => '',

    # Template: FAQLanguageForm
      'FAQ Language' => '',

    # Template: FAQNavigationBar

    # Template: FAQOverview

    # Template: FAQSearch

    # Template: FAQSearchResult

    # Template: Footer
      'Top of Page' => 'Inizio Pagina',

    # Template: FooterSmall

    # Template: InstallerBody
      'Create Database' => 'Crea database ',
      'Drop Database' => 'Cancella database',
      'Finished' => 'Operazione terminata',
      'System Settings' => 'Impostazioni di sistema',
      'Web-Installer' => 'Web-Installer',

    # Template: InstallerFinish
      'Admin-User' => 'Utente amministratore',
      'After doing so your OTRS is up and running.' => 'Dopo di ci OTRS sar pronto all\'uso.',
      'Have a lot of fun!' => 'Divertiti con OTRS!',
      'Restart your webserver' => 'Riavvia il tuo server web',
      'Start page' => 'Pagina iniziale',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Per poter usare OTRS devi inserire questa riga di comando in una shell come utente root.',
      'Your OTRS Team' => 'Il team OTRS',

    # Template: InstallerLicense
      'accept license' => 'accetto la licenza',
      'don\'t accept license' => 'non accetto la licenza',
      'License' => 'Licenza',

    # Template: InstallerStart
      'Create new database' => 'Crea un nuovo database',
      'DB Admin Password' => 'Password del DB Admin',
      'DB Admin User' => 'Nome utente DB Admin',
      'DB Host' => '',
      'DB Type' => 'Tipo di DBMS',
      'default \'hot\'' => '\'hot\' predefinito',
      'Delete old database' => 'Cancella il vecchio database',
      'next step' => 'Fase successiva',
      'OTRS DB connect host' => '',
      'OTRS DB Name' => '',
      'OTRS DB Password' => '',
      'OTRS DB User' => '',
      'your MySQL DB should have a root password! Default is empty!' => 'dovresti impostare una password di root per il tuo server MySQL!',

    # Template: InstallerSystem
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Controlla il record MX per i domini degli indirizzi email quando si compone un messaggio. Non usare se il vostro server con OTRS ha una connessione dial-up!)',
      '(Email of the system admin)' => '(Indirizzo email dell\'amministratore di sistema)',
      '(Full qualified domain name of your system)' => '(Nome di dominio completo (FQDN) del sistema)',
      '(Logfile just needed for File-LogModule!)' => '(File di log --- necessario solo per il log su file (File-LogModule))',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(ID del sistema. Ogni ID di sessione e numero di ticket inizia con questo numero)',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Prefisso per il numero di ticket --- es. "N.ro Ticket:" o "Ticket#" ecc.)',
      '(Used default language)' => '(Lingua predefinita)',
      '(Used log backend)' => '(Modulo da usare per il log)',
      '(Used ticket number format)' => '(Formato del numero dei ticket)',
      'CheckMXRecord' => 'Verifica record MX',
      'Default Charset' => 'Set di caratteri predefinito',
      'Default Language' => 'Lingua predefinita',
      'Logfile' => 'File di log',
      'LogModule' => 'Modulo di log',
      'Organization' => 'Azienda',
      'System FQDN' => 'FQDN del sistema',
      'SystemID' => 'ID del sistema',
      'Ticket Hook' => 'Prefisso ticket',
      'Ticket Number Generator' => 'Generatore numero ticket',
      'Use utf-8 it your database supports it!' => '',
      'Webfrontend' => 'Interfaccia web',

    # Template: LostPassword

    # Template: NoPermission
      'No Permission' => 'Autorizzazione negata',

    # Template: Notify

    # Template: PrintFooter
      'URL' => '',

    # Template: QueueView
      'All tickets' => 'Ticket totali',
      'Page' => '',
      'Queues' => 'Code',
      'Tickets available' => 'Ticket disponibili',
      'Tickets shown' => 'Ticket mostrati',

    # Template: SystemStats

    # Template: Test
      'OTRS Test Page' => 'Pagina di test OTRS',

    # Template: TicketEscalation
      'Ticket escalation!' => '',

    # Template: TicketView

    # Template: TicketViewLite

    # Template: Warning

    # Template: css
      'Home' => '',

    # Template: customer-css
      'Contact' => 'Contatti',
      'Online-Support' => 'Supporto in linea',
      'Products' => 'Prodotti',
      'Support' => 'Supporto',

    # Misc
      '"}","15' => '',
      '"}","30' => '',
      '(E-Mail of the system admin)' => '(Indirizzo email dell\'amministratore di sistema)',
      'A message should have a From: recipient!' => 'Un messaggio dovrebbe avere un mittente!',
      'Add auto response' => 'Aggiungi risposta automatica',
      'AgentFrontend' => 'Area Tecnici',
      'Article free text' => 'Testo libero articolo',
      'Change Response <-> Attachment settings' => 'Modifica impostazioni Risposte <-> Allegati',
      'Change answer <-> queue settings' => 'Modifica impostazioni Risposta <-> Coda',
      'Change auto response settings' => 'Modifica impostazioni risposta automatica',
      'Charset' => 'Set di caratteri',
      'Charsets' => 'Set di caratteri',
      'Create' => 'Crea',
      'Customer called' => 'Il cliente ha chiamato',
      'Customer info' => 'Informazioni sul cliente',
      'Customer user will be needed to to login via customer panels.' => 'Qui  possibile inserire gli utenti che possono fare il login nel pannello clienti.',
      'FAQ State' => '',
      'Fulltext search' => 'Ricerca integrale sul testo',
      'Fulltext search (e. g. "Mar*in" or "Baue*" or "martin+hallo")' => 'Ricerca integrale sul testo (es: "Mar*in" oppure "Baue*" oppure "martin+ciao")',
      'Graphs' => 'Grafici',
      'Handle' => 'Manipolare',
      'If your account is trusted, the x-otrs header (for priority, ...) will be used!' => 'Se si tratta di un account fidato, verranno usati gli header X-OTRS per la gestione dei ticket!',
      'In Queue' => 'Nella Coda',
      'Lock Ticket' => '',
      'Max Rows' => 'Numero massimo di linee',
      'My Tickets' => 'Lista Ticket',
      'New state' => 'Nuovo stato',
      'New ticket via call.' => 'Nuovo ticket via telefono.',
      'New user' => 'Nuovo operatore',
      'Pending!' => 'In attesa!',
      'Phone call at %s' => 'Chiamata telefonica di %s',
      'Please go away!' => '',
      'PostMasterFilter Management' => '',
      'Screen after new phone ticket' => '',
      'Search in' => 'Cerca in',
      'Select source:' => '',
      'Select your custom queues' => 'Scegli le code da visualizzare nella tua coda personale',
      'Select your screen after creating a new ticket via PhoneView.' => '',
      'Send me a notification if a ticket is moved into a custom queue.' => 'Mandami una notifica se un ticket viene spostato in una delle code visualizzate nella mia coda personale.',
      'Send me a notification if there is a new ticket in my custom queues.' => 'Mandami una notifica se c\' un nuovo ticket in una delle code visualizzate nella mia coda personale.',
      'SessionID' => 'ID sessione',
      'Set customer id of a ticket' => 'Imposta il cliente associato al ticket',
      'Short Description' => '',
      'Show all' => 'Mostra tutti i',
      'System Charset Management' => 'Gestione del set di caratteri di sistema',
      'System Language Management' => 'Gestione lingua del sistema',
      'Ticket free text' => 'Testo del ticket',
      'Ticket-Overview' => 'Sommario Ticket',
      'Utilities' => 'Utilit',
      'With Priority' => 'Con priorit',
      'With State' => 'Con stato',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further inforamtions.' => 'La tua email a cui  stato assegnato il numero di ticket "<OTRS_TICKET>"  stata rispedita a "<OTRS_BOUNCE_TO>". Contatta questo indirizzo per ulteriori informazioni.',
      'auto responses set' => 'Risposta automatica inserita',
      'by' => 'da',
      'invalid-temporarily' => 'temporaneamente invalido',
      'search' => 'Cerca',
      'search (e. g. 10*5155 or 105658*)' => 'Cerca (es: 10*5155 oppure 105658*)',
      'store' => 'salva',
      'tickets' => 'ticket',
      'valid' => 'valido',
    );

    # $$STOP$$
    $Self->{Translation} = \%Hash;
}
# --
1;
