/*
 * PIMPPA - Mark offline files
 *
 * Goes through the filebase and determines which files
 * are not available and marks them as FILE_OFFLINE.
 *
 * For speed, this assumes that most of the files 
 * are actually OFFLINE.
 *
 * Naturally (and for speed?), it doesn't affect the 
 * files on area 0.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>

#include "pimppa.h"

int mark_offline(void)
{
	MYSQL *src_db, *dst_db;
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	unsigned long online_files=0;
	unsigned long total_files=0;
	DIR *dirri;
	struct dirent *dirdata;

/********* Connect databases *******************************/

	src_db=p_connect();
	if(!src_db)
		return(0);

	dst_db=p_connect();
	if(!dst_db)
	{
		mysql_close(src_db);
		return(0);
	}

/* memory leak test, failed: no leak

	p_query(dst_db, "SELECT file_name FROM p_files");
	sql_res=mysql_store_result(dst_db);
	if(sql_res)
	{
		while((sql_row=mysql_fetch_row(sql_res)))
		{
		}
		mysql_free_result(sql_res);
	}
	
	fprintf(stderr, "Sleeping\n");
	sleep(15);
	
	exit(0);
*/

/******** set all files as offline ********/

	fprintf(stderr, "Setting all files as offline...\n");
	p_query(dst_db, "UPDATE p_files "
			"SET file_flags=(file_flags | %ld)", 
		FILE_OFFLINE);

/******* get total file amount ************/

	fprintf(stderr, "Getting total file amount...\n");
	p_query(src_db, "SELECT count(*) FROM p_files");
	if(mysql_error(src_db)[0])
		return(-1);
	if((sql_res=mysql_store_result(src_db)))
	{
		sql_row=mysql_fetch_row(sql_res);
		total_files=atoi(sql_row[0]);
	
		mysql_free_result(sql_res);
	}
		
/******** go through all the directories *******/

	fprintf(stderr, "Checking files...\n");

	p_query(src_db, "SELECT area_id, area_path " 
			"FROM p_areas WHERE area_id>0");
	if(mysql_error(src_db)[0])
		return(-1);
	sql_res=mysql_use_result(src_db);

	while((sql_row=mysql_fetch_row(sql_res)))
	{
		dirri=opendir(sql_row[1]);
		if(!dirri)
		{
			fprintf(stderr, "Argh, unable to open %s\n", sql_row[1]);
			continue;
		}
		
		while((dirdata=readdir(dirri)))
		{
			char escaped_fn[2*P_LEN_FILE_NAME+1];

			mysql_escape_string(escaped_fn, dirdata->d_name, 
								strlen(dirdata->d_name));
		
			p_query(dst_db, "UPDATE p_files "
					"SET file_flags=(file_flags & %ld) "
					"WHERE file_area=%s AND file_name='%s'",
				~FILE_OFFLINE, sql_row[0], escaped_fn);
			if(mysql_error(dst_db)[0])
				fprintf(stderr, "%s\n", mysql_error(dst_db));

			online_files++;
		
			if(online_files%500==0)
				printf("[%6ld/%6ld] online\n", online_files, total_files);
		}
		
		closedir(dirri);
	}

	mysql_free_result(sql_res);
	
	mysql_close(src_db);
	mysql_close(dst_db);
	
	return(online_files);
}
	

int main(int argc, char *argv[])
{
	int online_files;

	printf("Checking for online files...\n");
		
	online_files=mark_offline();

	fprintf(stderr, "Done, %d files are online.\n", online_files);
		
	return(0);
}

