/*****
*
* Copyright (C) 2001, 2002 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#include <libprelude/list.h>
#include <libprelude/plugin-common.h>
#include <libprelude/prelude-io.h>
#include <libprelude/prelude-message.h>
#include <libprelude/idmef-tree.h>
#include <libprelude/idmef-tree-func.h>


typedef struct {        
        /*
         * impact of the event
         */
        idmef_impact_t *impact;

        /*
         * 
         */
        idmef_confidence_t *confidence;

        /*
         * alert classification
         */
        idmef_classification_t classification;

        struct list_head additional_data_list;
} nids_alert_t;


int nids_alert_init_subsystem(void);


void nids_alert_init(nids_alert_t *alert);


void nids_alert(plugin_generic_t *plugin, packet_container_t *packet,
                nids_alert_t *alert, const char *description, ...);
