package AtomicData::H24Time;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: H24Time.pm,v 1.1 2000/11/23 23:36:15 muaddib Exp $

use strict;

=head1 NAME

AtomicData::H24Time - Datatype for an http address.

=head1 SYNOPSIS

see AtomicData.pm

=head1 DESCRIPTION

Implements data encapsulation for an Time.

=cut

use AtomicData::Text;
@AtomicData::H24Time::ISA = qw (AtomicData::Text);

=head1 METHODS

see AtomicData.pm for further methods.

=head2 _canonicalize

 instance/private
 (int $value) _canonicalize (int $raw_value)

DESCRIPTION:

Will accept a value and return the cannonical form or return undef and
set C<$this->{_can_failed}>.

=cut

sub _canonicalize {
  my ($this, $val) = @_;

  $val = $this->SUPER::_canonicalize($val);

  if ($val =~ /a-zA-Z/) { #two bits of text? Hmmm...
    $this->{_can_failed} = ['Confusing text string found.'];
    return undef;
  }
  
  #try and determine what seperators they are using
  my ($sep1, $sep2) = $val =~ /\d{1,2}(\D+)\d{1,2}(\D+)/;
  if ($sep1 ne $sep2) {
    $this->{_can_failed} = ['It appears that different seperators are being used to deliniate the time.'];
    return undef;
  }
  elsif ($sep1 ne ':') {
    ##$sep1 might be a meta charecter.  must make meta safe.
    $sep1 = quotemeta $sep1;
    $val =~ s/$sep1/:/g;
  }

  #add leading zeros if necessary
  $val =~ s/^(\d:)/0$1/;
  $val =~ s/^(\d{2}:)(\d:)/${1}0$2/;
  $val =~ /(\d+)$/;
  
  if (length($val) < 7) {
    $this->{_can_failed} = ['Unrecognizeable Time.'];
    return;
  }
  
  my $zero_pad = '0'x(2-length($1));
  substr($val, 6, 0) = $zero_pad;

  if (length($val) < 8) {
    $this->{_can_failed} = ['Unrecognizeable Time.'];
    return;
  }

  #now, we use oracle to test the time relationships
  #ask("select to_date(:p0, 'HH24:MI:SS') from dual", [$val]);

  return $val;
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
