########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Set/__init__.py,v 1.6 2004/08/20 21:11:03 mbrown Exp $
"""
Implementation of '4ss set' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command sets properties, such as access permissions \
or arbitrary user data, for a resource in a 4Suite repository. A \
subcommand specifying which type of property to set is required. See \
the help message for a subcommand for specific usage info."""

# command modules to register as subcommands
import Acl
import Owner
import Strobe
import UserData

g_subCommands = [
    Acl,
    Owner,
    Strobe,
    UserData,
    ]


def Register():
    from Ft.Lib.CommandLine import Options, Command
    sc = map(lambda x: x.Register(), g_subCommands)
    cmd = Command.Command('set',
                          "Set properties on a resource in a repository",
                          None,
                          __doc__,
                          subCommands = sc,
                          fileName = __file__,
                          )

    return cmd

