/* Copyright (C) 2003 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

/* Host interface.  Every application containing the VM must provide
 * the VM with an implementation of this interface.
 *
 * This implementation does nothing more than the simple stdio-based
 * one from the portable Tads 3 sources (tads3/vmhostsi.h), but this
 * might change in the future.
 */

#ifndef QTADSVMHOSTIFC_H
#define QTADSVMHOSTIFC_H

#include "resload.h"
#include "vmhosttx.h"

class QTadsCVmHostIfc: public CVmHostIfcText {
  protected:
	// Character mapping file resource loader.
	CResLoader* cmap_loader_;

	// Current I/O safety level.
	int io_safety_;

  public:
	QTadsCVmHostIfc( const char* argv0 );

	virtual
	~QTadsCVmHostIfc()
	{
		// Delete our character map resource loader.
		delete cmap_loader_;
	}

	// Get the I/O safety level.
	// We'll allow any file operations.
	virtual int
	get_io_safety()
	{
		return io_safety_;
	}

	// Set I/O safety level.
	virtual void
	set_io_safety( int level )
	{
		io_safety_ = level;
	}

	// Get the resource loader.
	virtual CResLoader*
	get_cmap_res_loader()
	{
		return cmap_loader_;
	}

	// Get the resource path.
	virtual const char*
	get_res_path()
	{
		return 0;
	}

	// Get an image file name.
	virtual vmhost_gin_t
	get_image_name( char*, size_t )
	{
		return VMHOST_GIN_IGNORED;
	}
};

#endif // QTADSVMHOSTIFC_H
