/***************************************************************************
                          despeckledialog.cpp  -  description
                             -------------------
    begin                : Sun May 26 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*****************************************************************************
 * The algorithm used in this class is based on Michael Sweets despeckle     *
 * plugin for The Gimp                                                       *
 * Original filename: despeckle.c                                            *
 * Original copyright message:                                               *
 * Copyright 1997-1998 Michael Sweet (mike@easysw.com)                       *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 *****************************************************************************/

#include "despeckledialog.h"
#include "quiteinsane/qxmlconfig.h"

#include <math.h>

#include <qapplication.h>
#include <qcheckbox.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qvbox.h>

DespeckleDialog::DespeckleDialog(int preview_size,QImage* image,QWidget* parent)
                :ImageFilterDialog(preview_size,image,parent)
{
  initControls();
}
DespeckleDialog::~DespeckleDialog()
{
}
/** No descriptions */
void DespeckleDialog::initControls()
{
  bool checked = xmlConfig->boolValue("FILTER_DESPECKLE_RADIUS",false);
  bool c_up = xmlConfig->boolValue("FILTER_DESPECKLE_CONTINOUS_UPDATE",false);

  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Despeckle"));
  setCaption(tr("Despeckle"));
  //radius
  mpRadiusCheckBox = new QCheckBox(tr("Stronger effect"),vb);

  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);
  connect(mpRadiusCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotRadiusChanged(bool)));
  //load values
  mpRadiusCheckBox->setChecked(checked);
  setContinousUpdate(c_up);
  setFixedSize(minimumSizeHint());
}
/** No descriptions */
void DespeckleDialog::sortValues(int* array,int cnt)
{
  int z;
  int i;
  int flag=0;
  int flag2=0;
  while(flag==0)
  {
    for (z=0;z<cnt;z++)
    {
      if(array[z] > array[z+1])
      {
        i = array[z];
        array[z] = array[z+1];
        array[z+1] = i;
        flag2=1;
      }
    }
    if(flag2==1)
    {
      flag2=0;
    }
    else
    {
      flag=1;
    }
  }
}
/** No descriptions */
bool DespeckleDialog::apply(QImage* image,bool emit_progress)
{
  int x,y;
  int x_start,y_start;
  int x_end,y_end;
  int progress,progresscnt;
  int old_depth = 0;
  int old_p = 0;
  progress = image->width() * image->height();
  progresscnt = 0;
  int radius;
  QImage im = image->copy();
  if(im.depth() < 32)
  {
    old_depth = im.depth();
    im = im.convertDepth(32);
  }
  radius = 1;
  if(mpRadiusCheckBox->isChecked())
    radius = 2;

  for(y=0;y<image->height();y++)
  {
    for(x=0;x<image->width();x++)
    {
      x_start = x - radius;
      y_start = y - radius;
      x_end = x + radius;
      y_end = y + radius;
      if(x_start < 0)
        x_start = 0;
      if(y_start < 0)
        y_start = 0;
      if(x_end >= image->width())
        x_end = image->width() - 1;
      if(y_end >= image->height())
        y_end = image->height() - 1;
      //get pixel values
      int p_cnt = 0;
      int avg_r[26];
      int avg_g[26];
      int avg_b[26];
      QRgb rgb;
      for(int i=y_start;i<y_end;i++)
      {
        for(int j=x_start;j<x_end;j++)
        {
          rgb = image->pixel(j,i);
          avg_r[p_cnt] = qRed(rgb);
          avg_g[p_cnt] = qGreen(rgb);
          avg_b[p_cnt] = qBlue(rgb);
          ++p_cnt;
        }
      }
      sortValues(avg_r,p_cnt);
      sortValues(avg_g,p_cnt);
      sortValues(avg_b,p_cnt);
      im.setPixel(x,y,qRgb(avg_r[p_cnt/2],avg_g[p_cnt/2],avg_b[p_cnt/2]));
      if(emit_progress)
      {
        if(stopped())
          return false;
        ++progresscnt;
        int p = int(100.0*double(progresscnt)/double(progress));
        if((p % 5 == 0) && (p > old_p))
        {
          old_p = p;
          emit signalFilterProgress(p);
          qApp->processEvents();
        }
      }
    }
  }
  if(old_depth > 0)
    im = im.convertDepth(old_depth);
  *image = im;
  return true;
}
/**  */
void DespeckleDialog::slotRadiusChanged(bool)
{
  updatePreview();
}
/** No descriptions */
void DespeckleDialog::saveConfig()
{
  xmlConfig->setBoolValue("FILTER_DESPECKLE_RADIUS",
                         mpRadiusCheckBox->isChecked());
  xmlConfig->setBoolValue("FILTER_DESPECKLE_CONTINOUS_UPDATE",
                          continousUpdate());
}