/***************************************************************************
                          qdevicesettings.cpp  -  description
                             -------------------
    begin                : Mon Mar 05 2001
    copyright            : (C) 2001 by Michael. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#include "qdevicesettings.h"
#include "qscanner.h"
#include "qxmlconfig.h"

#include <qapplication.h>
#include <qdom.h>
#include <qfile.h>
#include <qgroupbox.h>
#include <qhbox.h>
#include <qheader.h>
#include <qinputdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qmessagebox.h>
#include <qnamespace.h>
#include <qpushbutton.h>
#include <qtextstream.h>
#include <qtoolbutton.h>
#include <qvbox.h>
#include <qwhatsthis.h>

//Define the device settings version, which this class writes.
//This version number is not related to QuiteInsanes version.
//The number is siply increased by 1 with every new version.

#ifndef DEV_SETTINGS_VERSION
#define DEV_SETTINGS_VERSION "1"
#endif

QDeviceSettings::QDeviceSettings(QScanner* s,QWidget *parent,const char *name,
                                 bool modal,WFlags f)
                :QDialog(parent,name,modal,f)
{
  setCaption(tr("Device settings"));
  mpScanner = s;
  initWidget();
  createContents();
}

QDeviceSettings::~QDeviceSettings()
{
}
/**  */
void QDeviceSettings::initWidget()
{
  QString qs;
  QGridLayout* mainlayout = new QGridLayout(this,3,5);
  mainlayout->setSpacing( 6 );
  mainlayout->setMargin( 11 );
  mainlayout->setAlignment( Qt::AlignTop );

  QHBox* hbox1 = new QHBox(this);
  hbox1->setSpacing(4);
  qs = tr("Device: ");
  qs += mpScanner->vendor()+" "+mpScanner->model();
  QLabel* label1 = new QLabel(qs,hbox1);
  QToolButton* WhatsThisButton = QWhatsThis::whatsThisButton(hbox1);
  WhatsThisButton->setAutoRaise(FALSE);
  hbox1->setStretchFactor(label1,1);
  mainlayout->addMultiCellWidget(hbox1,0,0,0,4);
  if(!xmlConfig->boolValue("ENABLE_WHATSTHIS_BUTTON",true))
    WhatsThisButton->hide();
//sublayout
  QGroupBox* gb = new QGroupBox(this);
  QGridLayout* sublayout = new QGridLayout(gb,2,3);
  sublayout->setSpacing( 6 );
  sublayout->setMargin( 11 );
//the listview
	mpListView = new QListView(gb);
  mpListView->setMinimumHeight(100);
  mpListView->setSelectionMode(QListView::Single);
  mpListView->addColumn(tr("Available settings"));
  sublayout->addMultiCellWidget(mpListView,0,0,0,2);
//new button
	mpButtonNew = new QPushButton(tr("&New"),gb);
  sublayout->addWidget(mpButtonNew,1,0);
//delete button
	mpButtonDelete = new QPushButton(tr("&Delete"),gb);
  mpButtonDelete->setEnabled(FALSE);
  sublayout->addWidget(mpButtonDelete,1,2);
  sublayout->setColStretch(1,1);
  sublayout->setRowStretch(0,1);
  mainlayout->addMultiCellWidget(gb,1,1,0,4);
//load button
	mpButtonCancel = new QPushButton(tr("&Close"),this);
//load button
	mpButtonLoad = new QPushButton(tr("&Load"),this);
  mpButtonLoad->setDefault(true);
  mpButtonLoad->setEnabled(FALSE);
//close button
	mpButtonSave = new QPushButton(tr("&Save"),this);
  mpButtonSave->setEnabled(FALSE);
///add to sublayout
	mainlayout->addWidget(mpButtonCancel,2,0);
	mainlayout->addWidget(mpButtonSave,2,2);
	mainlayout->addWidget(mpButtonLoad,2,4);
  mainlayout->setColStretch(1,1);
  mainlayout->setColStretch(3,1);

  connect(mpButtonCancel,SIGNAL(clicked()),this,SLOT(reject()));
  connect(mpButtonNew,SIGNAL(clicked()),this,SLOT(slotNew()));	
  connect(mpButtonSave,SIGNAL(clicked()),this,SLOT(slotSave()));
  connect(mpButtonLoad,SIGNAL(clicked()),this,SLOT(slotLoad()));	
  connect(mpButtonDelete,SIGNAL(clicked()),this,SLOT(slotDelete()));
	connect(mpListView,SIGNAL(selectionChanged()),
            this,SLOT(slotSelectionChanged()));
 	connect(mpListView,SIGNAL(doubleClicked(QListViewItem*)),
          this,SLOT(slotDoubleClicked(QListViewItem*)));
  //help
  createWhatsThisHelp();
}
/**  */
void QDeviceSettings::slotClearList()
{
	mpListView->clear();
}
/**  */
void QDeviceSettings::createContents()
{
//try to load the settings file
  QDomDocument doc("QuiteInsane_device_settings");
  QFile f(xmlConfig->absConfDirPath()+"devicesettings.xml");
  if ( !f.open( IO_ReadOnly ) ) return;
  if( !doc.setContent( &f ) )
  {
    f.close();
    return;
  }
  f.close();

//Check, whether it's really a device settings file.
  if(doc.doctype().name() != "QuiteInsane_device_settings") return; //nope
//Ok, now try to find the device settings
  QDomElement root = doc.documentElement();
  QDomNodeList nodes = root.elementsByTagName("sane_device");
  QDomElement ele;

  // iterate over the items
  for (unsigned n=0; n<nodes.count(); ++n)
  {
    if (nodes.item(n).isElement())
    {
      ele = nodes.item(n).toElement();
      //Check whether there are saved settings for the device in use
      if(mpScanner->deviceSettingsName() == ele.attribute("name"))
      {
        //We found one; we create a new listview item and insert it
        if(!ele.attribute("username").isNull())
        {
          //We use tr(), because the previous settings are saved
          //under Last settings and this string has to be translated
          new QListViewItem(mpListView,tr(ele.attribute("username")));
        }
      }
    }
  }
  if(mpListView->childCount() > 0)
    mpListView->setCurrentItem(mpListView->firstChild());
}
/**  */
void QDeviceSettings::slotDelete()
{
  QListViewItem* li;
  li = mpListView->currentItem();
  if(!li) return;
  QString username;
  username = mpListView->currentItem()->text(0);
//try to load the settings file
  QDomDocument doc("QuiteInsane_device_settings");
  QFile f(xmlConfig->absConfDirPath()+"devicesettings.xml" );
  if ( !f.open( IO_ReadOnly ) )
  {
    //strange!
    return;
  }
  if( !doc.setContent( &f ) )
  {
    f.close();//also strange!
    return;
  }
  f.close();
//Check, whether it's really a device settings file.
//This method to find the settings is quite primitive.
//It easily fails, if the file was modified manually.
  QDomElement docElem;
  if(doc.doctype().name() != "QuiteInsane_device_settings") return; //nope
//Ok, now try to find the device settings
  QDomElement root = doc.documentElement();
  QDomNodeList nodes = root.elementsByTagName("sane_device");
  QDomElement ele;
  // iterate over the items
  for (unsigned n=0; n<nodes.count(); ++n)
  {
    if (nodes.item(n).isElement())
    {
      ele = nodes.item(n).toElement();
      //Check whether there are saved settings for the device in use
      if((mpScanner->deviceSettingsName() == ele.attribute("name")) &&
         (username == ele.attribute("username")))
      {
        //We found an already saved setting; we parse the settings to
        //see, whether there are vector files, which we have to delete, too.
        QDomNodeList dl = ele.childNodes();
        QString vals;
        for(unsigned int cnt=0;cnt<dl.count();cnt++)
        {
          QDomElement e2 = dl.item(cnt).toElement();
          if(e2.tagName() == "sane_option")
          {
            //check whether there's a value attribute
            vals = e2.attribute("value");
            if(!vals.isNull())
            { //ok
              if(vals.right(4) == ".vec")
              {
                //seems to be a vector file, delete it
                QFile::remove(vals);
              }
            }
          }
          root.removeChild(ele);
        }
      }
    }
  }
  QFile of(xmlConfig->absConfDirPath()+"devicesettings.xml" );
  if ( !of.open( IO_WriteOnly ) ) return;
  QTextStream ts(&of);
  doc.save(ts, 0);
  of.close();
  slotClearList();
  createContents();
  return;
}
/**  */
void QDeviceSettings::createWhatsThisHelp()
{
  //save
  QWhatsThis::add(mpButtonSave,tr("Click this button to save the "
                     "device settings under the currently "
                     "selected(highlighted) name."));
  //delete
  QWhatsThis::add(mpButtonDelete,tr("Click this button to delete the "
                     "selected(highlighted) device setting."));
  //load
  QWhatsThis::add(mpButtonLoad,tr("Click this button to load the "
                     "selected(highlighted) device setting."));
  //cancel
  QWhatsThis::add(mpButtonCancel,tr("Click this button to close the "
                                  "dialog."));
  //new
  QWhatsThis::add(mpButtonNew,tr("Click this button to create a new device "
                     "setting. You will be prompted for a name. The settings are "
                     "automatically saved."));
  //listview
  QWhatsThis::add(mpListView,tr("This listview shows the available  "
                     "settings. Doubleclick on an item to load the setting. "));
}
/**  */
void QDeviceSettings::slotSelectionChanged()
{
  QListViewItemIterator it(mpListView);
  for ( ; it.current(); ++it )
  {
    if(it.current()->isSelected())
    {
      mpButtonLoad->setEnabled(TRUE);
      if(it.current()->text(0) != tr("Last settings"))
      {
        mpButtonDelete->setEnabled(TRUE);
        mpButtonSave->setEnabled(TRUE);
      }
      else
      {
        mpButtonSave->setEnabled(FALSE);
        mpButtonDelete->setEnabled(FALSE);
      }
      return;
    }
  }
  mpButtonDelete->setEnabled(FALSE);
  mpButtonLoad->setEnabled(FALSE);
  mpButtonSave->setEnabled(FALSE);
}
/**  */
void QDeviceSettings::slotNew()
{
  bool ok = FALSE;
  QString text;
  text = QInputDialog::getText(tr("New entry"),
                               tr("Please enter a name"),
                               QLineEdit::Normal,
                               QString::null, &ok, this );
  if(!ok || text.isEmpty())return;//user entered nothing
  //the user entered a new entry
  //check, whether it has a unique name
  QListViewItemIterator it(mpListView);
  for ( ; it.current(); ++it )
  {
    if(it.current()->text(0) == text)
    {
      //the name already exists
      QMessageBox::warning(this,tr("Warning"),
                           tr("An entry with this name already exists.\n"
                              "Please enter a unique name."),
                           tr("OK"));
      return;
    }
  }
  QListViewItem* li = new QListViewItem(mpListView,text);
  mpListView->setCurrentItem(li);
  //we save the current settings automatically if a new entry has
  //been created
  if(!saveDeviceSettings())
    QMessageBox::warning(this,tr("Warning"),
                         tr("The settings could not be saved."),
                         tr("OK"));

}
/**  */
void QDeviceSettings::slotSave()
{
  if(saveDeviceSettings())
    accept();
  else  ;
  //todo: warning

}
/**  */
void QDeviceSettings::slotLoad()
{
  QString qs;
  mOptionMap.clear();
  QListViewItem* li;
  li = mpListView->currentItem();
  if(!li) return;
//try to load the settings file
  QDomDocument doc("QuiteInsane_device_settings");
  doc.clear();
  QFile f( xmlConfig->absConfDirPath()+"devicesettings.xml" );
  if (f.open( IO_ReadOnly ) )
  {
    doc.setContent( &f );
    f.close();
  }
  else
    return;
  if(!doc.isNull())
  {//it's a setting
    //We search the specific entry in the xml file.
    QDomElement docElem = doc.documentElement();
    if(doc.doctype().name() == "QuiteInsane_device_settings")//Elem.tagName() == "QuiteInsane_device_settings")
    {
      //Ok, now try to find the device settings
      QDomNode n = docElem.firstChild();
      while( !n.isNull() )
      {
        QDomElement e = n.toElement(); // try to convert the node to an element.
        if( !e.isNull() )
        { // the node was really an element.
          if(e.tagName() == "sane_device")
          {
            //Search the device settings.
            qs = e.attribute("username");
            //Only translated the Last settings entry to avoid confusion
            //if a user specified name matches a translated string
            if(qs == "Last settings") qs = tr(qs);
            if((mpScanner->deviceSettingsName() == e.attribute("name"))  &&
               (li->text(0) == qs))
            {
              //We found the entry.
              QDomNodeList dl = n.childNodes();
              for(unsigned int cnt=0;cnt<dl.count();cnt++)
              {
                QDomElement e2 = dl.item(cnt).toElement();
                if(e2.tagName() == "sane_option")
                {
                  mOptionMap.insert(e2.attribute("name"),
                                   e2.attribute("value"));
                }
              }
              mpScanner->setOptionsByName(mOptionMap);
              break;
            }
          }
        }
        n = n.nextSibling();
      }
    }
  }
  accept();
}
/**  */
bool QDeviceSettings::saveDeviceSettings(QString uname)
{
  QString username;
  if(uname.isNull())
  {
    if(!mpListView->currentItem()) return false;
    username = mpListView->currentItem()->text(0);
  }
  else
    username = uname;
//try to load the settings file
  QDomDocument doc("QuiteInsane_device_settings");
//  QDomDocument doc;
  QFile f( xmlConfig->absConfDirPath()+"devicesettings.xml" );
  //if there's no devicesettings file, try to create it
  if(!f.exists())
  {
    if(f.open(IO_WriteOnly))
    {
      QTextStream textstream(&f);
      // create the root element
      QDomElement root = doc.createElement(doc.doctype().name());
      root.setAttribute("version", DEV_SETTINGS_VERSION);
      doc.appendChild(root);
      doc.save(textstream, 0);
      f.close();
      //file successfully created
    }
    else
    {
      //could not create file
      if(uname.isNull())
      {
        QMessageBox::warning(this,tr("Warning"),
                     tr("The device settings could not be saved, "
                        "because the device settings file could "
                        "not be created.\n"
                        "This can mean, that your disk is full, or "
                        "that you don't have write permission."),
                     tr("OK"));
      }
      return false;
    }
  }
  if ( !f.open( IO_ReadOnly ) )
  {
    //add message box !
    return false;
  }
  if( !doc.setContent( &f ) )
  {
    f.close();
    //The file exists, but isn't a valid device settings file.
    //We create a new file.
    if(f.open(IO_WriteOnly))
    {
      QDomDocument doc2("QuiteInsane_device_settings");
      QTextStream textstream(&f);
      // create the root element
      QDomElement root = doc2.createElement(doc2.doctype().name());
      root.setAttribute("version", DEV_SETTINGS_VERSION);
      doc2.appendChild(root);
      doc2.save(textstream, 0);
      f.close();
      //file successfully created
    }
    else
      return false;
  }
  f.close();
//Check, whether it's really a device settings file.
  if(doc.doctype().name() != "QuiteInsane_device_settings")
    return false;
//Ok, now try to find the device settings
  QDomElement root = doc.documentElement();
  QDomNodeList nodes = root.elementsByTagName("sane_device");
  QDomElement ele;

  // iterate over the items
  for (unsigned n=0; n<nodes.count(); ++n)
  {
    if (nodes.item(n).isElement())
    {
      ele = nodes.item(n).toElement();
      //Check whether there are saved settings for the device in use
      if((mpScanner->deviceSettingsName() == ele.attribute("name")) &&
         (username == ele.attribute("username")))
      {
        //We found an already saved setting; we parse the settings to
        //see, whether there are vector files, which we have to delete, too.
        QDomNodeList dl = ele.elementsByTagName("sane_option");
        QString vals;
        for(unsigned int cnt=0;cnt<dl.count();cnt++)
        {
          if(dl.item(cnt).isElement())
          {
            QDomElement e2 = dl.item(cnt).toElement();
            if(e2.tagName() == "sane_option")
            {
              //check whether there's a value attribute
              vals = e2.attribute("value");
              if(!vals.isNull())
              { //ok
                if(vals.right(4) == ".vec")
                {
                  //seems to be a vector file, delete it
                  QFile::remove(vals);
                }
              }
            }
          }
        }
        root.removeChild(ele);
        break;
      }
    }
  }
  QDomElement elem = doc.createElement("sane_device");
  elem.setAttribute("name",mpScanner->deviceSettingsName());
  elem.setAttribute("username",username);
  mpScanner->settingsDomElement(doc,elem);
  root.appendChild(elem);
  QFile of( xmlConfig->absConfDirPath()+"devicesettings.xml" );
  if ( !of.open( IO_WriteOnly ) ) return false;
  QTextStream ts(&of);
  doc.save(ts, 0);
  of.close();
  return true;
}
/**  */
void QDeviceSettings::slotDoubleClicked(QListViewItem*)
{
  slotLoad();
}


