/*
 This Game is distributed under the GNU GENERAL PUBLIC LICENSE 
 version 2. See COPYING for details.                           
                                                               
 copyright (c) 2000 Harry Storbacka                            
                                                               
 map.cpp                                                     
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include <fstream>
#include <cstdio>

#include "tile_enums.h"
#include "debug.h"
#include "map.h"
#include "config.h"
#include "attractor.h"
#include "ok_area.h"
#include "start_pos.h"
#include "graphics.h"
#include "game_config.h"

//         
//  MAP    
//         
tileMap::tileMap()
{
	for( int y=0; y<40; y++ )
	 for( int x=0; x<40; x++ )
	{
		tmp_map[y][x] = '|';
		map[y][x] = 0;
		data_map[y][x] = 0;
		tmp_data_map[y][x] = 0;
	}

	filename = "new_track";
	track_record = 99999;
	track_record_holder = "";
	
	pit = false;
}

 
void tileMap::load_map( CL_String _filename )
{
	filename = DATADIR;
	filename += _filename;
	
	attractors.clear();
	
	for(int y=0;y<(40);y++)
	{
		for(int x=0;x<(40);x++)
  		{
			tmp_map[y][x] = '#';
			map[y][x] = 0;
			data_map[y][x] = 0;
			tmp_data_map[y][x] = 0;
		}
	}


	std::cout << "loading: " << filename.get_string() << std::endl;

	if( _filename != "" )
	{
		CL_String track_filename = _filename;
		track_filename += ".track";

		CL_String drive_filename = _filename;
		drive_filename += ".track.drive";

		CL_String data_filename = _filename;
		data_filename += ".track.data";

		CL_String start_filename = _filename;
		start_filename += ".track.start";

		CL_String number_filename = _filename;
		number_filename += ".extra";

		CL_InputSourceProvider *input = CL_InputSourceProvider::create_file_provider("");
		CL_InputSource *file = input->open_source( track_filename );

		std::cout << "InputSourceProvider..." << std::endl;


		for( int y=0; y < 40; y++ )
		{
			for( int x=0; x < 40; x++ )
			{
				tmp_map[y][x] = file->read_char8();
			}
		}
		delete file;
		delete input;

  		smooth_no_borders();

		std::cout << "load drive new" << std::endl;
		load_drive(drive_filename);

		load_data(data_filename);
		load_start(start_filename);
		load_numbers(number_filename);

		std::cout << "----- map loaded -----" << std::endl;
	}
}


// ------------------------------------------------------------------------

void tileMap::load_drive( CL_String filename )
{
	std::cout << "Loading track " << filename.get_string() << std::endl;
	
	FILE* drivefile = fopen( filename.get_string(), "r" );
	
	if( !drivefile )
	{
		std::cout << "error opening file " << filename.get_string() << std::endl;
		return;
	}
	
	int x, y = 0;
	int attr_x, attr_y = 0;
	
	fscanf( drivefile, "%d\n", &attr_x );
	
	if( attr_x != 9999 ) // 9999: end of file marker.
	{
		fscanf( drivefile, "%d\n", &attr_y );
	}

	while( attr_x != 9999 && feof( drivefile ) == false )
	{
		// cout << "while( attr_x != 9999 )" << endl;
	
		attractors.push_back( Attractor( attr_x, attr_y ) );
		
		while( x != -1 )
		{
			// cout << "while( x != -1 )" << endl;
		  
			fscanf( drivefile, "%d\n", &x );
			
			if( x != -1 )
			{
				fscanf( drivefile, "%d\n", &y );
				attractors.back().ok_area.push_back( new OkArea( x, y ) );
			}
		}
		
		fscanf( drivefile, "%d\n", &attr_x );
		
		if( attr_x != 9999 ) // 9999: end of file marker.
		{
			fscanf( drivefile, "%d\n", &attr_y );
		}
	
		x = y = 0;
	}
	
	std::cout << "Loaded track.drive " << std::endl;
	std::cout << "Number of attractors: " << attractors.size() << std::endl;
	
	fclose( drivefile );
}











void tileMap::smooth_no_borders()
{   
	{for( int y=0; y < 40; y++)
	{
		for( int x=0; x < 40; x++)
		{
			// grass
			if( tmp_map[y][x] == '|') // this is not blitted! 
		  		map[y][x] = 0;
	     
			// road tile 
			if( tmp_map[y][x] == '#' )
		  		map[y][x] = 2;
	     
			// road border top 
			if( tmp_map[y][x] == '#'
			   && tmp_map[y-1][x] != '#'
			   && tmp_map[y-1][x] != 'W')
		  		map[y][x] = 20;
	     
			// road border bottom 
			if( tmp_map[y][x] == '#'  && tmp_map[y+1][x] != '#'
			   && tmp_map[y+1][x] != 'W')
		  		map[y][x] = 21;
	     
			// road border left 
			if( tmp_map[y][x] == '#' && tmp_map[y][x-1] != '#'
			   && tmp_map[y][x-1] != 'W')
		  		map[y][x] = 18;
	     
			// road border right 
			if( tmp_map[y][x] == '#' && tmp_map[y][x+1] != '#'			   
			   && tmp_map[y][x+1] != 'W')
		  		map[y][x] = 19;
	     
	     // ###/   (tile 10) '/'   # = grass
	     // ##/  y,x+1     
	     // #/            
	     // y+1,x        
			if( tmp_map[y][x] == '#'
			   && tmp_map[y-1][x] != '#' && tmp_map[y+1][x] == '#' 
			   && tmp_map[y][x-1] != '#' && tmp_map[y][x+1] == '#'			   
			   && tmp_map[y-1][x] != 'W'
			   && tmp_map[y][x-1] != 'W')
		  		map[y][x] = 10;
	     
	     //        y-1,x
	     //         /#   (tile 11)  
	     // y,x-1  /##     
	     //       /###     

			if( tmp_map[y][x] == '#'
			   && tmp_map[y-1][x] =='#'  && tmp_map[y+1][x] !='#'
			   && tmp_map[y][x-1] =='#'  && tmp_map[y][x+1] != '#'
			   && tmp_map[y+1][x] != 'W'
			   && tmp_map[y][x+1] != 'W')
		  		map[y][x] = 11;
	       
	     //\ x,y-1      
	     //#\       
	     //##\   x+1,y   
	     //###\     
	     
			if( tmp_map[y][x] == '#'
			   && tmp_map[y-1][x] == '#' && tmp_map[y+1][x] != '#' 
			   && tmp_map[y][x-1] != '#' && tmp_map[y][x+1] == '#'
			   && tmp_map[y][x-1] != 'W'
			   && tmp_map[y+1][x] != 'W')
		  		map[y][x] = 12;
	     
	     //       \###
	     //x-1,y   \##
	     //         \#
	     //  x,y+1    

			if( tmp_map[y][x] == '#'
			   && tmp_map[y-1][x] != '#' && tmp_map[y+1][x] == '#' 
			   && tmp_map[y][x-1] == '#' && tmp_map[y][x+1] != '#'		
			   && tmp_map[y][x+1] != 'W'
			   && tmp_map[y-1][x] != 'W')	       
		  		map[y][x] = 13;
			}
		}
	}
}







/*
 * Apparently the following function does the same as load_map():
 * 
 * TODO: remove
 * 
 */


void tileMap::load_track( CL_String _filename )
{
	filename = _filename;

	filename += ".track";

	for(int y=0;y<(40);y++)
	{
		for(int x=0;x<(40);x++)
  		{
			tmp_map[y][x] = '#';
			map[y][x] = 0;
		}
	}

	std::cout << "(re)loading track..." << std::endl;

	if( filename != "" )
	{
		CL_InputSourceProvider *input = CL_InputSourceProvider::create_file_provider("");
		CL_InputSource *file = input->open_source( filename );

	
		for( int y=0; y < 40; y++ )
		{
			for( int x=0; x < 40; x++ )
			{
				tmp_map[y][x] = file->read_char8();
			}
		}
	
		delete file;
		delete input;

		smooth_no_borders();
	}
}



void tileMap::load_start( CL_String filename )
{
	start_positions.clear();

	FILE* startfile = fopen( filename, "r" );

	if (!startfile)
	{
		std::cout << "error opening file: " << filename.get_string() << std::endl;
		return;
	}
	else
  		std::cout << "loading: " << filename.get_string() << std::endl;

	unsigned short sx[2];
	unsigned short sy[2];

	bool a = true;
	while(a)
	{
		fscanf( startfile, "%d\n", &sx[0] );
		fscanf( startfile, "%d\n", &sy[0] );

		if( sx[0] == 99 )
		{
			std::cout << "closing file: " << filename.get_string() << std::endl;
			std::cout << "Number of Start positions: " << start_positions.size() << std::endl;
			a = false;
			break;
		}
		// cout << "adding start position " << sx[0] << "," << sy[0] << endl;

		start_positions.push_back( StartPosition( sx[0],sy[0] ));
	}
	fclose( startfile );
}




void tileMap::load_data( CL_String filename )
{
	FILE* datafile = fopen( filename.get_string(), "r" );

	if (!datafile)
	{
		std::cout << "error opening file " << filename.get_string() << std::endl;
		return;
	}

	int i = 0;

  	{for( int y=0; y < 40; y++)
	{
		for( int x=0; x < 40; x++)
		{
			fscanf( datafile, "%d\n", &i );
			data_map[y][x] = i;
		}
	}}

	fclose( datafile );

	{for( int y=0; y < 40; y++)
	{
		for( int x=0; x < 40; x++)
		{
			if( data_map[y][x] == Items(REFUEL))
		  		pit = true;
		}
	}}
}


void tileMap::load_numbers( CL_String _filename )
{
/*	RaceDebug::print( CL_String("Resources: ") + _filename, 7 );

	path += _filename;

	CL_ResourceManager res( path, false );
	
	track_record = CL_Integer( "track_record", &res ) / (float)100;
	track_record_holder = CL_String( "track_record_holder", &res );
*/
}

void tileMap::save_numbers( CL_String _filename )
{
/*
	std::ofstream fout(filename);

	fout << "track_record = " << (int)(track_record*100) << " (type=integer);" << std::endl;
	fout << "track_record_holder = \"" << track_record_holder.get_string() << "\" (type=string);" << std::endl;

	fout.close();
*/
}

