// 
// $Id$
//
// Implementation of QaPerlLanguage class
//
// Jan Borsodi <jb@ez.no>
// Created on: <05-Sep-2000 18:18:15 amos>
//
// Copyright (C) Jan Borsodi.  All rights reserved.


#include "qaperllanguage.hpp"
#include <qstring.h>

/*! \file qaperllanguage.cpp
  Implementation of QaPerlLanguage class
*/

/*!
  \class QaPerlLanguage qaperllanguage.hpp
  \brief
  \author <a href="mailto:jb@ez.no">Jan Borsodi</a>
  \date Enter current date here

*/

/*!
  Default constructor
*/

QaPerlLanguage::QaPerlLanguage()
    : QaRegExpLanguage()
{
}

/*!
  Destroys the object
*/

QaPerlLanguage::~QaPerlLanguage()
{
}

/*!
  Converts to Perl
*/

QString QaPerlLanguage::fromPlainText( const QString &s, bool code, MatchType type )
{
    QString str;
    unsigned int i = 0;
    bool bracket = false;
    bool negated = false;
//    ( i = s.find( "\\", i ) ) != -1 )
    for ( i = 0; i < s.length(); i++ )
    {
        QChar c2 = s.at( i );
        if ( bracket )
        {
            if ( c2 == ']' )
            {
                bracket = false;
                negated = false;
                str += c2;
            }
            else if ( c2 == '^' )
            {
                negated = true;
                str += c2;
            }
//              else if ( c2 == '"' && code )
//              {
//                  str += "\\";
//                  str += c2;
//              }
            else if ( c2 == '\\' )
            {
                i++;
                if ( i < s.length() )
                {
                    QChar c  = s.at( i );
                    if ( c == "t" )
                        str += "\\t";
                    else if ( c == "n" )
                        str += "\\n";
                    else if ( c == "r" )
                        str += "\\r";
                    else if ( c == "f" )
                        str += "\\f";
                    else if ( c == "d" )
                        str += "\\d";
                    else if ( c == "D" )
                        str += "\\D";
                    else if ( c == "w" )
                        str += "\\w";
                    else if ( c == "W" )
                        str += "\\W";
                    else if ( c == 'c' )
                        str += "\\c";
                    else if ( c == 'C' )
                        str += "\\C";
                    else if ( c == 'i' )
                        str += "\\i";
                    else if ( c == "s" )
                        str += "\\s";
                    else if ( c == "S" )
                        str += "\\S";
                    else if ( c == "]" )
                        str += "\\]";
                    else if ( c == "\\" )
                        str += "\\\\";
                    else
                    {
                        str += c2;
                        str += c;
                    }
                }
                else
                    str += c2;
            }
            else if ( c2 == "/" )
                str += "\\/";
            else
                str += c2;
        }
//\a<(class|public|private|protected|typename|signals|slots)>
        else
        {
            if ( c2 == '[' )
            {
                bracket = true;
                negated = false;
                str += c2;
            }
//              else if ( c2 == '"' && code )
//              {
//                  str += "\\";
//                  str += c2;
//              }
            else if ( c2 == '\\' )
            {
                i++;
                if ( i < s.length() )
                {
                    QChar c  = s.at( i );
                    if ( c == 't' )
                        str += "\\t";
                    else if ( c == 'n' )
                        str += "\\n";
                    else if ( c == 'r' )
                        str += "\\r";
                    else if ( c == 'f' )
                        str += "\\f";
                    else if ( c == 'd' )
                        str += "[0-9]";
                    else if ( c == 'D' )
                        str += "[^0-9]";
                    else if ( c == 'w' )
                        str += "\\w";
                    else if ( c == 'W' )
                        str += "\\W";
                    else if ( c == 'c' )
                        str += "\\c";
                    else if ( c == 'C' )
                        str += "\\C";
                    else if ( c == 'i' )
                        str += "\\i";
                    else if ( c == 'I' )
                        str += "\\I";
                    else if ( c == 's' )
                        str += "\\s";
                    else if ( c == 'S' )
                        str += "\\S";
//                    else if ( c == "]" )
//                        str += "\\]";
                    else if ( c == '\\' )
                        str += "\\\\";
                    else
                    {
                        str += c2;
                        str += c;
                    }
                }
                else
                    str += c2;
            }
            else if ( c2 == "/" )
                str += "\\/";
            else
                str += c2;
        }
    }
    if ( code )
    {
        if ( type == QaRegExpLanguage::Multiple )
        {
            str = QString( "~= /%1/g" ).arg( str );
        }
        else if ( type == QaRegExpLanguage::Split )
        {
            str = QString( "split( /%1/ )" ).arg( str );
        }
        else
        {
            str = QString( "~= /%1/" ).arg( str );
        }
    }
    return str;
}
