/*
 * resmgr tester
 *
 */

#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/un.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include "protocol.h"
#include "resmgrd.h"


static const char *	identify(int fd);
const char *		find(const char *, dev_t, ino_t);

int
main(int argc, char **argv)
{
	struct conn	*conn;
	struct pollfd	p[2];
	int		done;

	p[0].fd = 0;
	fcntl(0, F_SETFL, O_NONBLOCK);

	if (argc > 2) {
		printf("Usage: tester [socketpath]\n");
		return 1;
	}

	conn = rsm_connect(argc == 2? argv[1] : _PATH_RESMGR_SOCKET);
	if (conn == 0) {
		perror("Unable to connect to resource manager");
		return 1;
	}
	p[1].fd = conn->fd;

	done = 0;
	while (!done) {
		char	c;

		p[0].events = POLLIN|POLLHUP;
		p[1].events = POLLIN|POLLHUP;

		poll(p, 2, -1);

		if (p[0].revents & POLLIN) {
			if (read(0, &c, 1) == 1
			 && rsm_send(conn, &c, 1) < 0) {
				perror("rsm_send");
				return 1;
			}
		}
		if (p[0].revents & POLLHUP) {
			done++;
		}
		if (p[1].revents & POLLIN) {
			char	buffer[1024];

			if (rsm_recv(conn, buffer, sizeof(buffer)) < 0) {
				perror("rsm_recv");
				return 1;
			}
			if (conn->passfd >= 0) {
				printf("Received a file descriptor [%u] %s\n",
					conn->passfd, identify(conn->passfd));
				close(conn->passfd);
				conn->passfd = -1;
			}
			write(0, buffer, strlen(buffer));
		}
		if (p[1].revents & POLLHUP) {
			printf("Server closed connection\n");
			done++;
		}
	}

	return 0;
}

const char *
identify(int fd)
{
	static char	string[1024];
	struct stat	stb;
	const char	*result;

	if (fstat(fd, &stb) < 0)
		return strerror(errno);

	result = find("/dev", stb.st_dev, stb.st_ino);
	if (result == NULL)
		result = find(_PATH_PROC_BUS_USB,
				stb.st_dev, stb.st_ino);

	if (result == NULL) {
		snprintf(string, sizeof(string),
			"(unknown device 0x%x/%lu)",
			(unsigned) stb.st_dev, stb.st_ino);
		result = string;
	}
	return result;
}

const char *
find(const char *dirname, dev_t dev, ino_t ino)
{
	static char	result[1024];
	char		namebuf[1024];
	struct stat	stb;
	DIR		*dir;
	struct dirent	*de;

	if (!strcmp(dirname, "/dev/fd"))
		return NULL;

	if ((dir = opendir(dirname)) == NULL) {
		perror(dirname);
		return NULL;
	}

	while ((de = readdir(dir)) != NULL) {
		if (de->d_name[0] == '.')
			continue;
		snprintf(namebuf, sizeof(namebuf), "%s/%s",
				dirname, de->d_name);
		if (stat(namebuf, &stb) < 0)
			continue;
		if (stb.st_dev == dev && stb.st_ino == ino) {
			strcpy(result, namebuf);
			closedir(dir);
			return result;
		}
		if (S_ISDIR(stb.st_mode) && find(namebuf, dev, ino))
			return result;
	}
	closedir(dir);
	return NULL;
}
