/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */


#include "OXProperties.h"
#include "d3des.h"

#include <xclass/OXTextButton.h>
#include <xclass/OXCheckButton.h>
#include <xclass/OXGroupFrame.h>
#include <xclass/OXLabel.h>
#include <xclass/OXTextEntry.h>
#include <xclass/OXSecretTextEntry.h>
#include <xclass/OXSlider.h>
#include <xclass/OXTab.h>
#include <xclass/OXFont.h>
#include <xclass/OIniFile.h>

#include "OXButtonBox.h"


#define CODE_BUTTON_OK                   100
#define CODE_BUTTON_CANCEL               101
#define CODE_BUTTON_APPLY                102

#define CODE_CHECKBUTTON_DISPLAYNUMBER   103


void readProperties( char *filename, Properties &properties )
{
  OIniFile iniFile( filename, INI_READ );
  char section[256];
  char value[1024];
  while ( iniFile.GetNext( section ) ) {
//  [Connection]
    if ( !strcasecmp( section, "Connection" ) ) {
      if ( iniFile.GetItem( "SocketConnections", value ) )
        properties.acceptSocketConnections = atoi( value );
      if ( iniFile.GetItem( "Display", value ) )
        properties.displayNumber = atoi( value );
      if ( iniFile.GetItem( "AutoDisplay", value ) )
        properties.autoDisplayNumber = atoi( value );
      if ( iniFile.GetItem( "Password", value ) )
        decryptPasswordHex( properties.password, value );
      if ( iniFile.GetItem( "DisableRemote", value ) )
        properties.disableRemoteControl = atoi( value );
      if ( iniFile.GetItem( "DisableLocal", value ) )
        properties.disableLocalControl = atoi( value );
    }
//  [Update]
    if ( !strcasecmp( section, "Update" ) ) {
      if ( iniFile.GetItem( "ShowMousePointer", value ) )
        properties.showMousePointer = atoi( value );
      if ( iniFile.GetItem( "ScanOnRequestOnly", value ) )
        properties.scanOnRequestOnly = atoi( value );
      if ( iniFile.GetItem( "ScanDelay", value ) )
        properties.scanDelay = atoi( value );
      if ( iniFile.GetItem( "UseXShm", value ) )
        properties.useXShm = atoi( value );
      if ( iniFile.GetItem( "UseXTest", value ) )
        properties.useXTest = atoi( value );
    }
  }
}


void writeProperties( char *filename, Properties &properties )
{
  OIniFile iniFile( filename, INI_WRITE );
  char tmp[1024];

  iniFile.PutNext( "Connection" );
  iniFile.PutItem( "SocketConnections", (char *) (properties.acceptSocketConnections? "1":"0") );
  snprintf( tmp, 1023, "%i", properties.displayNumber );
  iniFile.PutItem( "Display", tmp );
  iniFile.PutItem( "AutoDisplay", (char *) (properties.autoDisplayNumber? "1":"0") );
  encryptPasswordHex( properties.password, tmp );
  iniFile.PutItem( "Password", tmp );
  iniFile.PutItem( "DisableRemote", (char *) (properties.disableRemoteControl? "1":"0") );
  iniFile.PutItem( "DisableLocal", (char *) (properties.disableLocalControl? "1":"0") );

  iniFile.PutNewLine();
  iniFile.PutNext( "Update" );
  iniFile.PutItem( "ShowMousePointer", (char *) (properties.showMousePointer? "1":"0") );
  iniFile.PutItem( "ScanOnRequestOnly", (char *) (properties.scanOnRequestOnly? "1":"0") );
  snprintf( tmp, 1023, "%i", properties.scanDelay );
  iniFile.PutItem( "ScanDelay", tmp );
  iniFile.PutItem( "UseXShm", (char *) (properties.useXShm? "1":"0") );
  iniFile.PutItem( "UseXTest", (char *) (properties.useXTest? "1":"0") );
}


void OXProperties::ApplySettings()
{
  char suffix[] = "/.x0rfbserver";
  char filename[strlen(getenv("HOME"))+strlen(suffix)+1];
  sprintf( filename, "%s%s", getenv("HOME"), suffix );
  properties->acceptSocketConnections = checkButtonAccept->GetState() == BUTTON_DOWN;
  properties->displayNumber = atoi( entryDisplayNumber->GetString() );
  properties->autoDisplayNumber = checkButtonDisplayNumber->GetState() == BUTTON_DOWN;
  strncpy( properties->password, entryPassword->GetString(), 8 );
  properties->disableRemoteControl = checkButtonDisableRemoteControl->GetState() == BUTTON_DOWN;
  properties->disableLocalControl = checkButtonDisableLocalControl->GetState() == BUTTON_DOWN;

  properties->showMousePointer = checkButtonShowMousePointer->GetState() == BUTTON_DOWN;
  properties->scanOnRequestOnly = checkButtonScanOnRequestOnly->GetState() == BUTTON_DOWN;
  properties->scanDelay = sliderScanDelay->GetPosition();
  properties->useXShm = checkButtonUseXShm->GetState() == BUTTON_DOWN;
  properties->useXTest = checkButtonUseXTest->GetState() == BUTTON_DOWN;
  
  writeProperties( filename, *properties );
}


OXProperties::OXProperties( const OXWindow *_parent, const OXWindow *_main, Properties *_properties )
  : OXTransientFrame( _parent, _main, 300, 280 )
  , properties( _properties )
{
  SetWindowName( "x0rfbserver: Current User Properties" );
  
  OFontPool *fp = new OFontPool( _client );
  OXFont *font = fp->GetFont("-adobe-helvetica-medium-r-normal-*-11-*-*-*-*-*-*-*");

  ChangeOptions((GetOptions() & ~HORIZONTAL_FRAME) | VERTICAL_FRAME);

  OXTab *tab = new OXTab( this, 16, 16 );
  ADD_FRAME( this, tab, ( LHINTS_TOP | LHINTS_EXPAND_X | LHINTS_EXPAND_Y, 4, 4, 4, 4 ) );
  
  OXCompositeFrame *groupConnections
    = tab->AddTab( new OString("Incoming Connections") );
  
  checkButtonAccept
    = new OXCheckButton( groupConnections, new OString("Accept Socket Connections"), -1 );
  ADD_FRAME( groupConnections, checkButtonAccept, ( LHINTS_TOP | LHINTS_LEFT, 12, 0, 8, 0 ) );
  checkButtonAccept->SetFont( font );

  OXCompositeFrame *frameDisplayNumber
    = new OXCompositeFrame( groupConnections, 16, 16, HORIZONTAL_FRAME );
  ADD_FRAME( groupConnections, frameDisplayNumber, ( LHINTS_TOP | LHINTS_EXPAND_X, 32, 0, 8, 0 ) );
  
  OXLabel *labelDisplayNumber = new OXLabel( frameDisplayNumber, new OString("Display Number: "), font );
  ADD_FRAME( frameDisplayNumber, labelDisplayNumber, ( LHINTS_CENTER_Y | LHINTS_LEFT ) );

  entryDisplayNumber = new OXTextEntry( frameDisplayNumber );
  ADD_FRAME( frameDisplayNumber, entryDisplayNumber, ( LHINTS_CENTER_Y | LHINTS_LEFT ) );
  entryDisplayNumber->SetWidth( 52 );

  checkButtonDisplayNumber
    = new OXCheckButton( frameDisplayNumber, new OString("Auto"), CODE_CHECKBUTTON_DISPLAYNUMBER );
  ADD_FRAME( frameDisplayNumber, checkButtonDisplayNumber, ( LHINTS_CENTER_Y | LHINTS_LEFT, 8 ) );
  checkButtonDisplayNumber->SetFont( font );
  checkButtonDisplayNumber->Associate( this );

  OXCompositeFrame *framePassword
    = new OXCompositeFrame( groupConnections, 16, 16, HORIZONTAL_FRAME );
  ADD_FRAME( groupConnections, framePassword, ( LHINTS_TOP | LHINTS_EXPAND_X, 32, -6, 8, 0 ) );
  
  OXLabel *labelPassword = new OXLabel( framePassword, new OString("Password: "), font );
  ADD_FRAME( framePassword, labelPassword, ( LHINTS_CENTER_Y | LHINTS_LEFT ) );

  entryPassword = new OXSecretTextEntry( framePassword );
  ADD_FRAME( framePassword, entryPassword, ( LHINTS_CENTER_Y | LHINTS_LEFT, 26 ) );
  entryPassword->SetWidth( 96 );

  checkButtonDisableRemoteControl
    = new OXCheckButton( groupConnections, new OString("Disable Remote Keyboard & Pointer"), -1 );
  ADD_FRAME( groupConnections, checkButtonDisableRemoteControl, ( LHINTS_TOP | LHINTS_LEFT, 12, 0, 8, 0 ) );
  checkButtonDisableRemoteControl->SetFont( font );

  checkButtonDisableLocalControl
    = new OXCheckButton( groupConnections, new OString("Disable Local Keyboard & Pointer"), -1 );
  ADD_FRAME( groupConnections, checkButtonDisableLocalControl, ( LHINTS_TOP | LHINTS_LEFT, 12, 0, 8, 0 ) );
  checkButtonDisableLocalControl->SetFont( font );
  checkButtonDisableLocalControl->SetTextColor( _client->GetColorByName( "darkred" ) );

  checkButtonDisableLocalControl->Disable();

  OXButtonBox *buttonBox = new OXButtonBox( this, 0 );
  ADD_FRAME( this, buttonBox, ( LHINTS_BOTTOM | LHINTS_EXPAND_X, 1, 1, 4, 1 ) );

  OXTextButton *buttonOK
    = new OXTextButton( buttonBox, new OHotString("&OK"), CODE_BUTTON_OK );
  ADD_FRAME( buttonBox, buttonOK, ( LHINTS_CENTER_Y | LHINTS_EXPAND_X | LHINTS_LEFT, 4, 1, 5, 6 ) );
  buttonOK->Associate( this );

  OXTextButton *buttonCancel
    = new OXTextButton( buttonBox, new OHotString("&Cancel"), CODE_BUTTON_CANCEL );
  ADD_FRAME( buttonBox, buttonCancel, ( LHINTS_CENTER_Y | LHINTS_EXPAND_X | LHINTS_LEFT, 4, 1, 5, 6 ) );
  buttonCancel->Associate( this );

  OXTextButton *buttonApply
    = new OXTextButton( buttonBox, new OHotString("&Apply"), CODE_BUTTON_APPLY );
  ADD_FRAME( buttonBox, buttonApply, ( LHINTS_CENTER_Y | LHINTS_EXPAND_X | LHINTS_LEFT, 4, 1, 5, 6 ) );
  buttonApply->Associate( this );

  buttonOK    ->SetBackgroundColor( _defaultFrameBackground );
  buttonCancel->SetBackgroundColor( _defaultFrameBackground );
  buttonApply ->SetBackgroundColor( _defaultFrameBackground );


  OXCompositeFrame *groupUpdateHandling
    = tab->AddTab( new OString("Update Handling") );
//  groupUpdateHandling->Disable();

  checkButtonShowMousePointer
    = new OXCheckButton( groupUpdateHandling, new OString("Show Dummy Mouse Pointer"), -1 );
  ADD_FRAME( groupUpdateHandling, checkButtonShowMousePointer, ( LHINTS_TOP | LHINTS_LEFT, 12, 0, 8, 0 ) );
  checkButtonShowMousePointer->SetFont( font );

  checkButtonScanOnRequestOnly
    = new OXCheckButton( groupUpdateHandling, new OString("Scan on Update Request only"), -1 );
  ADD_FRAME( groupUpdateHandling, checkButtonScanOnRequestOnly, ( LHINTS_TOP | LHINTS_LEFT, 12, 0, 8, 0 ) );
  checkButtonScanOnRequestOnly->SetFont( font );



  OXCompositeFrame *frameScanDelay
    = new OXCompositeFrame( groupUpdateHandling, 16, 16, HORIZONTAL_FRAME );
  ADD_FRAME( groupUpdateHandling, frameScanDelay, ( LHINTS_TOP | LHINTS_EXPAND_X, 8, 0, 8, 0 ) );

  OXLabel *labelScanDelay1 = new OXLabel( frameScanDelay, new OString("CPU: MAX"), font );
  ADD_FRAME( frameScanDelay, labelScanDelay1, ( LHINTS_CENTER_Y | LHINTS_LEFT ) );

  sliderScanDelay
    = new OXHSlider( frameScanDelay, 100, SLIDER_1 );
  ADD_FRAME( frameScanDelay, sliderScanDelay, ( LHINTS_TOP | LHINTS_LEFT, 0, 0, 0, 0 ) );
  sliderScanDelay->SetRange(0,1000);

  OXLabel *labelScanDelay2 = new OXLabel( frameScanDelay, new OString("MIN (delay 1000ms)"), font );
  ADD_FRAME( frameScanDelay, labelScanDelay2, ( LHINTS_CENTER_Y | LHINTS_LEFT ) )

  checkButtonUseXShm
    = new OXCheckButton( groupUpdateHandling, new OString("Use XShm (if available)"), -1 );
  ADD_FRAME( groupUpdateHandling, checkButtonUseXShm, ( LHINTS_TOP | LHINTS_LEFT, 12, 0, 8, 0 ) );
  checkButtonUseXShm->SetFont( font );

  checkButtonUseXTest
    = new OXCheckButton( groupUpdateHandling, new OString("Use XTest (if available)"), -1 );
  ADD_FRAME( groupUpdateHandling, checkButtonUseXTest, ( LHINTS_TOP | LHINTS_LEFT, 12, 0, 8, 0 ) );
  checkButtonUseXTest->SetFont( font );
  
  SetDefaultAcceptButton( buttonOK );
  SetDefaultCancelButton( buttonCancel );

  SetFocusOwner( tab );

  if ( properties->acceptSocketConnections )
    checkButtonAccept->SetState( BUTTON_DOWN );
  char displayNumber[256];
  sprintf( displayNumber, "%i", properties->displayNumber );
  entryDisplayNumber->AddText( 0, displayNumber );
  if ( properties->autoDisplayNumber ) {
    entryDisplayNumber->Disable();
    checkButtonDisplayNumber->SetState( BUTTON_DOWN );
  }
  entryPassword->AddText( 0, properties->password );
  if ( properties->disableRemoteControl )
    checkButtonDisableRemoteControl->SetState( BUTTON_DOWN );
  if ( properties->disableLocalControl )
    checkButtonDisableLocalControl->SetState( BUTTON_DOWN );

  if ( properties->showMousePointer )
    checkButtonShowMousePointer->SetState( BUTTON_DOWN );
  if ( properties->scanOnRequestOnly )
    checkButtonScanOnRequestOnly->SetState( BUTTON_DOWN );
  sliderScanDelay->SetPosition(properties->scanDelay);
  if ( properties->useXShm )
    checkButtonUseXShm->SetState( BUTTON_DOWN );
  if ( properties->useXTest )
    checkButtonUseXTest->SetState( BUTTON_DOWN );

  Layout();
//  Resize( GetDefaultSize() );

  Move((_client->GetDisplayWidth() - GetWidth()) >> 1,
       (_client->GetDisplayHeight() - GetHeight()) >> 1);

  SetMWMHints(MWM_DECOR_ALL | MWM_DECOR_MAXIMIZE | MWM_DECOR_MENU,
              MWM_FUNC_ALL | MWM_FUNC_MAXIMIZE | MWM_FUNC_RESIZE,
              MWM_INPUT_MODELESS);
  MapSubwindows();
  MapWindow();
  _client->WaitFor( this );
}


OXProperties::~OXProperties()
{
    DELETE_LAYOUT_HINTS;
}


int OXProperties::ProcessMessage( OMessage *msg )
{
  OWidgetMessage *wmsg = (OWidgetMessage *) msg;

  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == CODE_BUTTON_OK))
    {
      ApplySettings();
      delete this;
    }
  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == CODE_BUTTON_CANCEL))
    {
      delete this;
    }
  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == CODE_BUTTON_APPLY))
    {
      ApplySettings();
    }

  if ((msg->type == MSG_CHECKBUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == CODE_CHECKBUTTON_DISPLAYNUMBER))
    {
      if ( checkButtonDisplayNumber->GetState() == BUTTON_DOWN )
        entryDisplayNumber->Disable();
      else
	entryDisplayNumber->Enable();
    }

    return false;
}

