# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Struct", "Object", "class")
aClass.addSubclasses(%w{Struct::Tms})
aClass.addFragment(Paragraph.new("A <code>Struct</code> is a convenient way to bundle a number of attributes together, using accessor methods, without having to write an explicit class.\n"))
aClass.addFragment(Paragraph.new("The <code>Struct</code> class is a generator of specific classes, each one of which is defined to hold a set of variables and their accessors. In these examples, we'll call the generated class ``<i>Customer</i>Class,'' and we'll show an example instance of that class as ``<i>Customer</i>Inst.''\n"))
aClass.addFragment(Paragraph.new("In the descriptions that follow, the parameter <i>aSymbol</i> refers to a symbol, which is either a quoted string or a <code>Symbol</code> (such as <code>:name</code>).\n"))
m0002 = MethodDesc.new("new", "class", "Struct.new( <i>[</i><i>aString</i><i>]</i> <i>[</i>, <i>aSym</i><i>]+></i> ) -> <i>Customer</i>Class")
m0002.addFragment(Paragraph.new("Creates a new class, named by <i>aString</i>, containing accessor methods for the given symbols. If the name <i>aString</i> is omitted, an anonymous structure class will be created. Otherwise, the name of this struct will appear as a constant in class <code>Struct</code>, so it must be unique for all <code>Struct</code>s in the system and should start with a capital letter.\n"))
m0002.addFragment(Paragraph.new("<code>Struct::new</code> returns a new <code>Class</code> object, which can then be used to create specific instances of the new structure. The remaining methods listed below (class and instance) are defined for this generated class. See the description that follows for an example.\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("new", "class", "<i>Customer</i>Class.new( <i>[</i><i>anObject</i><i>]+></i> ) -> <i>Customer</i>Inst")
m0003.addFragment(Paragraph.new("Creates a new instance. The number of actual parameters must be less than or equal to the number of attributes defined for this class; unset parameters default to <code>nil</code>. Passing too many parameters will raise an <code>ArgumentError</code>.\n"))
m0003.addFragment(Verbatim.new("Customer = Struct.new( \"Customer\", :name, :address, :zip )\njoe = Customer.new( \"Joe Smith\", \"123 Maple, Anytown NC\", 12345 )\njoe.name   \#=> \"Joe Smith\"\njoe.zip    \#=> 12345\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("members", "class", "<i>Customer</i>Class.members -> <i>anArray</i>")
m0004.addFragment(Paragraph.new("Returns an array of strings representing the names of the instance variables.\n"))
m0004.addFragment(Verbatim.new("Customer = Struct.new( \"Customer\", :name, :address, :zip )\nCustomer.members   \#=> [\"name\", \"address\", \"zip\"]\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("==", "instance", "<i>Customer</i>Inst == <i>anOtherStruct</i> -> <code>true</code> or <code>false</code>")
m0005.addFragment(Paragraph.new("Equality---Returns <code>true</code> if <i>anOtherStruct</i> is equal to this one: they must be of the same class as generated by <code>Struct::new</code>, and the values of all instance variables must be equal (according to <code>Object\#==</code>).\n"))
m0005.addFragment(Verbatim.new("Customer = Struct.new( \"Customer\", :name, :address, :zip )\njoe   = Customer.new( \"Joe Smith\", \"123 Maple, Anytown NC\", 12345 )\njoejr = Customer.new( \"Joe Smith\", \"123 Maple, Anytown NC\", 12345 )\njane  = Customer.new( \"Jane Doe\", \"456 Elm, Anytown NC\", 12345 )\njoe == joejr   \#=> true\njoe == jane    \#=> false\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("[]", "instance", "<i>Customer</i>Inst[ <i>aSymbol</i> ] -> <i>anObject</i><br></br><i>Customer</i>Inst[ <i>anInteger</i> ] -> <i>anObject</i> <p></p>")
m0006.addFragment(Paragraph.new("Attribute Reference---Returns the value of the instance variable named by <i>aSymbol</i>, or indexed (0..length-1) by <i>anInteger</i>. Will raise <code>NameError</code> if the named variable does not exist, or <code>IndexError</code> if the index is out of range.\n"))
m0006.addFragment(Verbatim.new("Customer = Struct.new( \"Customer\", :name, :address, :zip )\njoe = Customer.new( \"Joe Smith\", \"123 Maple, Anytown NC\", 12345 )\n\njoe[\"name\"]   \#=> \"Joe Smith\"\njoe[:name]    \#=> \"Joe Smith\"\njoe[0]        \#=> \"Joe Smith\"\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("[]=", "instance", "<i>Customer</i>Inst[ <i>aSymbol</i> ] = <i>anObject</i> -> <i>anObject</i><br></br><i>Customer</i>Inst[ <i>anInteger</i> ] = <i>anObject</i> -> <i>anObject</i> <p></p>")
m0007.addFragment(Paragraph.new("Attribute Assignment---Assigns to the instance variable named by <i>aSymbol</i> or <i>anInteger</i> the value <i>anObject</i> and returns it. Will raise a <code>NameError</code> if the named variable does not exist, or an <code>IndexError</code> if the index is out of range.\n"))
m0007.addFragment(Verbatim.new("Customer = Struct.new( \"Customer\", :name, :address, :zip )\njoe = Customer.new( \"Joe Smith\", \"123 Maple, Anytown NC\", 12345 )\n\njoe[\"name\"] = \"Luke\"\njoe[:zip]   = \"90210\"\n\njoe.name   \#=> \"Luke\"\njoe.zip    \#=> \"90210\"\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("each", "instance", "<i>Customer</i>Inst.each {| anObject | block } <p></p> -> <i>Customer</i>Inst")
m0008.addFragment(Paragraph.new("Calls <i>block</i> once for each instance variable, passing the value as a parameter.\n"))
m0008.addFragment(Verbatim.new("Customer = Struct.new( \"Customer\", :name, :address, :zip )\njoe = Customer.new( \"Joe Smith\", \"123 Maple, Anytown NC\", 12345 )\njoe.each {|x| puts(x) }"))
m0008.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0008.addFragment(Verbatim.new("Joe Smith\n123 Maple, Anytown NC\n12345"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("length", "instance", "<i>Customer</i>Inst.length -> <i>anInteger</i>")
m0009.addFragment(Paragraph.new("Returns the number of instance variables.\n"))
m0009.addFragment(Verbatim.new("Customer = Struct.new( \"Customer\", :name, :address, :zip )\njoe = Customer.new( \"Joe Smith\", \"123 Maple, Anytown NC\", 12345 )\njoe.length   \#=> 3\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("members", "instance", "<i>Customer</i>Inst.members -> <i>anArray</i>")
m0010.addFragment(Paragraph.new("Returns an array of strings representing the names of the instance variables.\n"))
m0010.addFragment(Verbatim.new("Customer = Struct.new( \"Customer\", :name, :address, :zip )\njoe = Customer.new( \"Joe Smith\", \"123 Maple, Anytown NC\", 12345 )\njoe.members   \#=> [\"name\", \"address\", \"zip\"]\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("size", "instance", "<i>Customer</i>Inst.size -> <i>anInteger</i>")
m0011.addFragment(Paragraph.new("Synonym for <code>Struct\#length</code>.\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("to_a", "instance", "<i>Customer</i>Inst.to_a -> <i>anArray</i>")
m0012.addFragment(Paragraph.new("Returns the values for this instance as an array.\n"))
m0012.addFragment(Verbatim.new("Customer = Struct.new( \"Customer\", :name, :address, :zip )\njoe = Customer.new( \"Joe Smith\", \"123 Maple, Anytown NC\", 12345 )\njoe.to_a[1]   \#=> \"123 Maple, Anytown NC\"\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("values", "instance", "<i>Customer</i>Inst.values -> <i>anArray</i>")
m0013.addFragment(Paragraph.new("Synonym for <code>to_a</code>.\n"))
aClass.addMethod(m0013)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
