#include "fontentry.h"

static void fontChanged(GnomeFontPicker* widget, gpointer a, FontEntry* data)
{
        data->changed();
}

FontEntry::FontEntry(const string& varName, const Path& mod_, ModifierEntryListener& parent_, bool owner)
        : ModifierEntry(varName, mod_, parent_, owner)
{
        valueWidget = gnome_font_picker_new();
        gtk_signal_connect(GTK_OBJECT(valueWidget), "font-set", GTK_SIGNAL_FUNC(fontChanged), this);
        reload();
        gtk_box_pack_start(GTK_BOX(hbox), valueWidget, false, false, 3);
        gtk_widget_show(valueWidget);;
}

DataSet FontEntry::getValue()
{
        string newValue(gnome_font_picker_get_font_name(GNOME_FONT_PICKER(valueWidget)));
        DataSet tmp;
        tmp.addString(newValue);
        return tmp;
}

void FontEntry::setValue(const DataSet& value)
{
        if (value.count() > 0)
                gnome_font_picker_set_font_name(GNOME_FONT_PICKER(valueWidget), const_cast<gchar*> (value.toString().c_str()));
}
