#include "datasetmap.h"

void DataSetMap::display(ostream& os) const
{
        for (map<string, DataSet>::const_iterator i = storage.begin(); i != storage.end(); i++) {
                os << i->first << " = " << i->second << endl;
        }
}

inline struct tm *DataSetMap::getTime() const
{
	time_t longTime;
	time(&longTime);
	return localtime(&longTime);
}

/* expand out $(key) type statements in value */
void DataSetMap::expand(string& result, const string& value, int c_position) const
{
        result.erase();
        bool dollar = false;
        for (string::const_iterator i = value.begin(); i < value.end(); ++i) {
                if (dollar && (*i) == '(') {
                        string exp;
                        ++i; // skip open bracket
                        for (; i < value.end() && (*i) != ')'; ++i)
                                exp+= (*i);
                        string exp_value;
                        getExpanded(exp_value, exp, c_position + result.length());
                        result+= exp_value;
                        dollar = false;
                } else if ((*i) == '$' && !dollar) {
                        dollar = true;
                } else {
                        dollar = false;
                        result+= (*i);
                }
        }
}

/* expand out $(key) type statements in a key */
void DataSetMap::getExpanded(string& result, const string& key, int cPosition) const
{
        int index = 0;
        string strippedKey(key);
        int beginIndex = key.find_first_of('[');
        if (beginIndex != int(string::npos)) {
                int endIndex = key.find_first_of(']', beginIndex);
                if (beginIndex != int(string::npos)) {
                        string strIndex(key, beginIndex + 1, endIndex - beginIndex - 1);
                        index = atoi(strIndex.c_str());
                        strippedKey = string(key, 0, beginIndex);
                }
        }
        if (!validIndex(strippedKey)) {
        	if (strippedKey == "time") {
		        time_t longTime;
		        time(&longTime);
		        result = string(asctime(localtime(&longTime)));
                        result = string(result, 0, result.length() - 1);
		        return;
	        }
	        if (strippedKey == "year") {
        		struct tm *tstruct = getTime();
		        char *tmp= new char[5];
		        sprintf(tmp, "%04d", tstruct->tm_year + 1900);
                        result = tmp;
                        delete [] tmp;
		        return;
	        }
	        if (strippedKey == "month") {
        		struct tm *tstruct = getTime();
		        char *tmp = (char *) new char[3];
		        sprintf(tmp, "%02d", tstruct->tm_mon + 1);
                        result = tmp;
                        delete [] tmp;
		        return;
	        }
	        if (strippedKey == "day") {
        		struct tm *tstruct = getTime();
		        char *tmp= (char *) new char[3];
		        sprintf(tmp, "%02d", tstruct->tm_mday);
                        result = tmp;
                        delete tmp;
		        return;
	        }
	        if (strippedKey[0] == 'i') {
        		bool allNum = true;
		        for (string::const_iterator i = strippedKey.begin(); i < strippedKey.end(); ++i) {
        			if (!isdigit(*i))
				        allNum = false;
		        }
		        if (allNum) {
        			int indentPos = atoi((char *) &strippedKey.c_str()[1]);
			        int length = indentPos - cPosition;
                                if (length < 0 || length > 1000)
                                        length = 1;
			        char *spaceString = new char[length + 1];
			        for (int i = 0; i < length; i++)
        				spaceString[i] = ' ';
			        spaceString[length] = 0;
                                result = spaceString;
                                delete [] spaceString;
			        return;
		        }
	        }
                result = "";
                return;
        }
        const DataSet& v = storage.find(strippedKey)->second;
        if (v.validIndex(index))
                expand(result, v.getString(index), cPosition);
        else
                result = "";
}

void DataSetMap::integrate(const DataSetMap& other)
{
        for (map<string, DataSet>::const_iterator i = other.begin(); i != other.end(); ++i)
                set(i->first, i->second);
}

void DataSetMap::set(const string& key, const DataSet& value)
{
        // the c_str() is important.  i have no idea why, but if you send it in directly
        // all hell breaks loose with the memory usage -- very strange
        // this took me about half a day to find!!
        storage[key.c_str()] = value;
}
