#include "proxy_module.h"

#include "../../module_registry.h"

ProxyModule::ProxyModule(const string& mtype)
        : modtype(mtype)
{
}

ProxyModule::~ProxyModule()
{
}

const DataSetMap& ProxyModule::get_module_info()
{
        return ModuleRegistry::instance()->module_info(modtype).module_info();
}

Module* ProxyModule::newChild(const string& typeName)
{
        Module* aNewModule = new ProxyModule(typeName);
        aNewModule->setParent(this);
        addChild(aNewModule);
        return aNewModule;
}
