#ifndef PLUGINS_H
#define PLUGINS_H

#include "datasetmap.h"
#include "moduleinfo.h"

#include <string>
#include <vector>
using namespace std;

class DataSetMap;
class Module;

class Plugin
{
public:
        Plugin(const string& n, void *h) : name(n), handle(h) {
        }

        string name;
        void* handle;
};

class Plugins
{
public:
        ~Plugins();

        static Plugins* instance() {
                if (!instance_)
                        instance_ = new Plugins();
                return instance_;
        }
        
        static void destroy_instance() {
                if (instance_)
                        delete instance_;
                instance_ = 0;
        }

        void addPlugin(Plugin* p);
        
        void load(const string& pluginDir);

private:
        Plugins();

private:
        void loadPlugin(const string& fileName);
        vector<Plugin*> loaded;

        static Plugins* instance_;
};

#endif
