<?xml version="1.0" ?>

<!-- 	 
################################################################################ 
################################################################################
##
##	Nome: rub2txt.xsl
##	versione: 0.1 
##	Copyright (C) 2000-2002 Nicola Fragale <nicolafragale@libero.it>
##	
##	Scopo: Questo foglio di stile traduce i file generati da Rubrica 
##        (.rub) in html
##	       This stylesheet translate rubrica's (.rub) file in html
##       
##	This program is free software; you can redistribute it and/or modify
##	it under the terms of the GNU General Public License as published by
## 	the Free Software Foundation; either version 2 of the License, or
##  	(at your option) any later version.
##
## 	This program is distributed in the hope that it will be useful,
##  	but WITHOUT ANY WARRANTY; without even the implied warranty of
##  	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  	GNU General Public License for more details.
##
##  	You should have received a copy of the GNU General Public License
##  	along with this program; if not, write to the Free Software
##  	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##  	
################################################################################
################################################################################
-->
	
	<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">	
	<xsl:output method="text" encoding="ISO-8859-1"/>
	
	<xsl:template match="Rubrica">
		<xsl:apply-templates/>
	</xsl:template>
		
<!--				Card/Scheda
-->
<xsl:template match="Card">
Card: <xsl:value-of select="@name"/>							
<xsl:apply-templates select="Data"/>  
<xsl:apply-templates select="Address"/>  
<xsl:apply-templates select="WebAddresses"/>  
<xsl:apply-templates select="EmailAddresses"/>  
<xsl:apply-templates select="TelephoneNumbers"/> 	
<xsl:apply-templates select="Company"/>  
<xsl:apply-templates select="Work"/>   
<xsl:apply-templates select="Notes"/>  

</xsl:template>
		
		

<!--			Personal infos/Dati Personali
-->
<xsl:template match="Data"> 			
Name:<xsl:if test="NamePrefix!=''">&#160;<xsl:value-of select="NamePrefix"/></xsl:if><xsl:if test="FirstName != ''">&#160;<xsl:value-of select="FirstName"/></xsl:if><xsl:if test="MiddleName!=''">&#160;<xsl:value-of select="MiddleName"/></xsl:if><xsl:if test="LastName != ''">&#160;<xsl:value-of select="LastName"/></xsl:if><xsl:if test="Title!=''">,&#160;<xsl:value-of select="Title"/></xsl:if>

	<xsl:if test="FirstName/@know_birthday='true'">
Birthday: <xsl:value-of select="FirstName/@birthday"/>
	</xsl:if>
			
<xsl:if test="Profession!=''">
Profession: <xsl:value-of select="Profession"/>
</xsl:if>

</xsl:template>		 

		
<!--			Address/Indirizzo
-->
<xsl:template match="Address">
Address: <xsl:if test="Street!=''"><xsl:value-of select="Street"/></xsl:if><xsl:if test="StreetNumber !=''">, <xsl:value-of select="StreetNumber"/>. </xsl:if><xsl:if test="ZipCode!=''"> <xsl:value-of select="ZipCode"/></xsl:if><xsl:if test="City!=''">&#160;<xsl:value-of select="City"/></xsl:if><xsl:if test="Province!=''">&#160;(<xsl:value-of select="Province"/>)<xsl:if test="Country!=''">&#160;<xsl:value-of select="Country"/></xsl:if></xsl:if><xsl:if test="State!=''">&#160;<xsl:value-of select="State"/></xsl:if>
</xsl:template>
	
	
<!-- 			Web 
-->
<xsl:template match="WebAddresses">			

- Web - <xsl:apply-templates select="Web"/>
</xsl:template>		
	
<xsl:template match="Web">
url: <xsl:value-of select="."/></xsl:template>			
	
<!-- 			Email 
-->
<xsl:template match="EmailAddresses">

- Email - <xsl:apply-templates select="Email"/>
</xsl:template>
		
<xsl:template match="Email">
url: <xsl:value-of select="."/></xsl:template>
		

<!-- 			Telephone/Telefono 
-->
<xsl:template match="TelephoneNumbers">
			
- Telephone numbers -<xsl:apply-templates select="Telephone"/>			
</xsl:template>		
		
<xsl:template match="Telephone">
telephone: <xsl:value-of select="."/> (<xsl:value-of select="@type"/>)</xsl:template>
				
				
<!--			Company/Azienda
-->
<xsl:template match="Company">

- Company infos -
<xsl:if test="CompanyName!=''"> <xsl:value-of select="CompanyName"/>  
<xsl:if test="Street!=''">
Address: <xsl:value-of select="Street"/>&#160;<xsl:value-of select="StreetNumber"/> &#160;<xsl:value-of select="ZipCode"/>&#160; <xsl:value-of select="City"/>&#160; <xsl:value-of select="Province"/> &#160;<xsl:value-of select="Country"/> 
</xsl:if>
	
<xsl:if test="Web!='' or Email!=''">

Net:
web page: <xsl:value-of select="Web"/>  
email: <xsl:value-of select="Email"/>
</xsl:if>
			
<xsl:if test="Operator!='' or Fax!='' or Green!='' or CustomerCare!=''">

Telephones:  
Operator: <xsl:value-of select="Operator"/>  
Fax: <xsl:value-of select="Fax"/>  
Green: <xsl:value-of select="Green"/>  
Customer Care: <xsl:value-of select="CustomerCare"/>  
</xsl:if>

<xsl:if test="Notes!=''">

Notes:  
<xsl:value-of select="Notes"/>
</xsl:if>			
</xsl:if>			
</xsl:template>
		

		<!--			Assigment/Impiego
		-->		
<xsl:template match="Work">

- Contact assigment -
<xsl:if test="Assigment!=''">Impiego: <xsl:value-of select="Assigment"/></xsl:if>						

<xsl:if test="Organization!=''">
Organizzazione: <xsl:value-of select="Organization"/></xsl:if>

<xsl:if test="Department!=''">
Dipartimento: <xsl:value-of select="Department"/></xsl:if>

<xsl:if test="SubDepartment!=''">
Sotto Dipartimento: <xsl:value-of select="SubDepartment"/></xsl:if>

<xsl:if test="SecretaryName!=''">
Segretaria: <xsl:value-of select="SecretaryName"/></xsl:if>

<xsl:if test="SecretaryPhone!=''">
Telefono Segretaria: <xsl:value-of select="SecretaryPhone"/></xsl:if>
</xsl:template>		


		<!--			Notes/Note
		-->
<xsl:template match="Notes">			

- Note -
<xsl:if test="@married='true'">E' coniugato  
Nome del Coniuge: <xsl:value-of select="SpouseName"/>  
Data di nascita: <xsl:value-of select="SpouseName/@birthday"/>  
Anniversario: <xsl:value-of select="SpouseName/@anniversary"/>  
</xsl:if>

<xsl:if test="@married='false'">Non &#xe8; coniugato</xsl:if>			

<xsl:if test="@children='true'">
Ha figli  
Figli: <xsl:value-of select="Child"/></xsl:if>

<xsl:if test="@children='false'">
Non ha figli </xsl:if>
			
<xsl:if test="Hobbies!=''">
Passatempi: <xsl:value-of select="Hobbies"/></xsl:if>
			
<xsl:if test="OtherNotes!=''">
Note: <xsl:value-of select="OtherNotes"/></xsl:if>
			
<xsl:if test="PublicKey!=''">
Chiave Pubblica: <xsl:value-of select="PublicKey"/></xsl:if>

</xsl:template>		

	</xsl:stylesheet>

		<!-- 	end of file
		-->