/*
*  program name: Rubrica <http://digilander.iol.it/nfragale/download.html>
*  file: account.h
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_ACCOUNT_H
#define _RUBRICA_ACCOUNT_H

#include <gtk/gtk.h>
#include "rubrica_type.h"

enum 
  {
    EDITABLE_COLUMN,
    ACCOUNT_COLUMN,
    WEB_COLUMN,
    EMAIL_COLUMN,
    LOGIN_COLUMN,
    PASSWORD_COLUMN,
    DESCRIPTION_COLUMN,
    N_COLUMNS
  };


typedef struct _RubricaAccount
{
  gboolean editable;

  gchar *name;
  gchar *web;
  gchar *email;
  gchar *login;
  gchar *password;
  gchar *description;
} RubricaAccount;

GtkWidget *rubrica_account_interface_creation(GtkTreeModel *model, 
					      RubricaInfoChild *info);

GtkTreeModel *rubrica_account_create_model(void);
void rubrica_account_add_columns(GtkTreeView *view);
void rubrica_account_add_item(GtkWidget *button, gpointer data);
void rubrica_account_delete_item(GtkWidget *button, gpointer data);
void rubrica_account_cell_toggled(GtkCellRendererToggle *cell, 
				  const gchar *path,
				  gpointer data);
void rubrica_account_cell_edited(GtkCellRendererText *cell, const gchar *path,
				 const gchar *new_text, gpointer data);

GtkWidget *rubrica_account_get_tree(void);

#endif
