/*
*  Rubrica
*  file: modulo.h
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef __RUBRICA_CARD_FORM_H
#define __RUBRICA_CARD_FORM_H

#include <gtk/gtk.h>

#include "rubrica.h"
#include "rubrica_type.h"


#define RUBRICA_CARD_TYPE          (rubrica_form_card_get_type())
#define RUBRICA_CARD(obj)          (GTK_CHECK_CAST((obj), RUBRICA_CARD_TYPE, RubricaCardForm))
#define RUBRICA_CARD_CLASS(klass)  (GTK_CHECK_CLASS_CAST((klass), RUBRICA_CARD_TYPE, RubricaCardFormClass))
#define RUBRICA_IS_CARD(obj)       (GTK_CHECK_TYPE((obj), RUBRICA_CARD_TYPE))
#define RUBRICA_IS_CARD_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), RUBRICA_CARD_TYPE))


typedef struct _RubricaCardForm         RubricaCardForm;
typedef struct _RubricaCardFormClass    RubricaCardFormClass;

typedef struct _RubricaPersonalForm     RubricaPersonalForm;
typedef struct _RubricaAddressForm      RubricaAddressForm;
typedef struct _RubricaNetForm          RubricaNetForm;
typedef struct _RubricaTelephoneForm    RubricaTelephoneForm;
typedef struct _RubricaCompanyForm      RubricaCompanyForm;
typedef struct _RubricaWorkForm         RubricaWorkForm;
typedef struct _RubricaNotesForm        RubricaNotesForm;


struct _RubricaPersonalForm 
{
  GtkWidget *first;         /* first name  */
  GtkWidget *middle;        /* middle name */
  GtkWidget *last;          /* last name   */ 
  GtkWidget *profession;    /* profession  */
  GtkWidget *prefix;        /* name prefix */
  GtkWidget *title;         /* title       */
  GtkWidget *birthknow;     /* know birthday ? */
  GtkWidget *date;          /* bithday */
};

struct _RubricaAddressForm
{
  GtkWidget *street;
  GtkWidget *number;
  GtkWidget *zip;
  GtkWidget *city;
  GtkWidget *province;
  GtkWidget *state;
  GtkWidget *country;
};

struct _RubricaNetForm 
{
  GtkWidget *web;
  GtkWidget *web_tree;
  GtkWidget *web_add;
  GtkWidget *web_mod;
  GtkWidget *web_del;

  GtkWidget *email;
  GtkWidget *email_tree;
  GtkWidget *email_add;
  GtkWidget *email_mod;
  GtkWidget *email_del;
};


struct _RubricaTelephoneForm
{
  GtkWidget *number;
  GtkWidget *tree;

  GSList *group;
  GtkWidget *radiohome;
  GtkWidget *radiowork;
  GtkWidget *radiofax;
  GtkWidget *radiocell;
  GtkWidget *radioother;    

  GtkWidget *tel_add;  
  GtkWidget *tel_mod;
  GtkWidget *tel_del;
};

struct _RubricaCompanyForm
{
  GtkWidget *name;
  GtkWidget *street;
  GtkWidget *number;
  GtkWidget *zip;
  GtkWidget *city;    
  GtkWidget *province;
  GtkWidget *country;
  GtkWidget *web;
  GtkWidget *email;
  GtkWidget *operator;
  GtkWidget *fax;
  GtkWidget *green;
  GtkWidget *customer_care;
  GtkWidget *notes;
};

struct _RubricaWorkForm
{
  GtkWidget *role;
  GtkWidget *dep;
  GtkWidget *sub;
  GtkWidget *org;
  GtkWidget *secretary;  
  GtkWidget *phone;
};

struct _RubricaNotesForm
{
  GtkWidget *is_married;      /* check button - he/she is marries?        */
  GtkWidget *has_children;    /* check button - he/she has got children?  */

  GtkWidget *birthknow;       /* check button - his/her birthday is known */
  GtkWidget *birthdate;       /* his/her birthday */

  GtkWidget *anniverknow;     /* check but. -  know anniversary date? */
  GtkWidget *anniverdate;     /* anniversary date */
   
  GtkWidget *spouse;          /* contact spouse's name (given name) */

  GtkWidget *children;        /* text - children notes     */
  GtkWidget *hobbies;         /* text - his/her hobbies    */
  GtkWidget *notes;           /* text - other notes        */
  GtkWidget *pubkey;          /* text - his/her public key */
};


struct _RubricaCardForm {
  GtkDialog dialog;

  RubricaCardType type;

  /* il notebook */
  GtkWidget *notebook;  

  GtkWidget *card;
  GtkWidget *delete;
//  GtkWidget *edit;
  GtkWidget *option;

  RubricaPersonalForm personal;
  RubricaAddressForm address;
  RubricaNetForm net;
  RubricaTelephoneForm tel;
  RubricaCompanyForm company;
  RubricaWorkForm work;
  RubricaNotesForm notes;
  
  gchar *current_telephone;
  gboolean modificato;
};


struct _RubricaCardFormClass {
  GtkDialogClass parent_class;
};


GtkType          rubrica_form_card_get_type (void);
GtkWidget*       rubrica_form_card_new      (void);  

GtkWidget*       rubrica_form_card_get_form (void);
void             rubrica_form_card_set_form (GtkWidget *wid);

gchar*           rubrica_form_card_get_entry_data (GtkWidget *entrywidget);
gchar*           rubrica_form_card_get_text_data  (GtkWidget *textwidget);

void             rubrica_form_card_write_string   (GtkWidget* entry, 
						   gchar* str);
RubricaItem*     rubrica_form_card_get_item       (RubricaCardForm *form);
RubricaErrorType rubrica_form_card_insert_item    (RubricaCardForm *form, 
						   RubricaItem *item);
void             rubrica_form_card_clean_form     (RubricaCardForm *form);

/*   funzioni per manipolare contenuto del widget
*/
void             rubrica_form_card_extract_insert_close(RubricaCardForm *form);
void             rubrica_form_card_extract_change_close(RubricaCardForm *form,
							gint index);
RubricaErrorType rubrica_form_card_modify_item         (RubricaCardForm *form,
							RubricaItem *item);

void             rubrica_form_card_set_changed         (RubricaCardForm *form,
							gboolean bool);
gboolean         rubrica_form_card_changed             (RubricaCardForm *form);

gchar*           rubrica_form_card_get_telefono_attivo (RubricaCardForm *form);
void             rubrica_form_card_set_telefono_attivo (RubricaCardForm *form,
							gchar *str);

void             rubrica_form_card_set_form_type       (GtkWidget *form, 
							RubricaCardType type);
RubricaCardType  rubrica_form_card_get_form_type       (GtkWidget *form);

void             rubrica_form_card_clicked_ok          (RubricaCardForm *form);
void             rubrica_form_card_close               (RubricaCardForm *form);

#endif
