/* This file was generated by SableCC (http://www.sablecc.org/). */

package org.sablecc.sablecc.parser;

import org.sablecc.sablecc.lexer.*;
import org.sablecc.sablecc.node.*;
import org.sablecc.sablecc.analysis.*;
import java.util.*;

import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

public class Parser
{
  public final Analysis ignoredTokens = new AnalysisAdapter();

  protected Node node;

  private final Lexer lexer;
  private final ListIterator stack = new LinkedList().listIterator();
  private int last_shift;
  private int last_pos;
  private int last_line;
  private Token last_token;
  private final TokenIndex converter = new TokenIndex();
  private final int[] action = new int[2];

  private final static int SHIFT = 0;
  private final static int REDUCE = 1;
  private final static int ACCEPT = 2;
  private final static int ERROR = 3;

  protected void filter() throws ParserException, LexerException, IOException
    {}

  public Parser(Lexer lexer)
  {
    this.lexer = lexer;

    if(actionTable == null)
    {
      try
      {
        DataInputStream s = new DataInputStream(
                              new BufferedInputStream(
                                Parser.class.getResourceAsStream("parser.dat")));

        // read actionTable
        int length = s.readInt();
        actionTable = new int[length][][];
        for(int i = 0; i < actionTable.length; i++)
        {
          length = s.readInt();
          actionTable[i] = new int[length][3];
          for(int j = 0; j < actionTable[i].length; j++)
          {
            for(int k = 0; k < 3; k++)
            {
              actionTable[i][j][k] = s.readInt();
            }
          }
        }

        // read gotoTable
        length = s.readInt();
        gotoTable = new int[length][][];
        for(int i = 0; i < gotoTable.length; i++)
        {
          length = s.readInt();
          gotoTable[i] = new int[length][2];
          for(int j = 0; j < gotoTable[i].length; j++)
          {
            for(int k = 0; k < 2; k++)
            {
              gotoTable[i][j][k] = s.readInt();
            }
          }
        }

        // read errorMessages
        length = s.readInt();
        errorMessages = new String[length];
        for(int i = 0; i < errorMessages.length; i++)
        {
          length = s.readInt();
          StringBuffer buffer = new StringBuffer();

          for(int j = 0; j < length; j++)
          {
            buffer.append(s.readChar());
          }
          errorMessages[i] = buffer.toString();
        }

        // read errors
        length = s.readInt();
        errors = new int[length];
        for(int i = 0; i < errors.length; i++)
        {
          errors[i] = s.readInt();
        }

        s.close();
      }
      catch(Exception e)
      {
        throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
      }
    }
  }

  private int goTo(int index)
  {
    int state = state();
    int low = 1;
    int high = gotoTable[index].length - 1;
    int value = gotoTable[index][0][1];

    while(low <= high)
    {
      int middle = (low + high) / 2;

      if(state < gotoTable[index][middle][0])
      {
        high = middle - 1;
      }
      else if(state > gotoTable[index][middle][0])
      {
        low = middle + 1;
      }
      else
      {
        value = gotoTable[index][middle][1];
        break;
      }
    }

    return value;
  }

  private void push(int state, Node node, boolean filter) throws ParserException, LexerException, IOException
  {
    this.node = node;

    if(filter)
    {
      filter();
    }

    if(!stack.hasNext())
    {
      stack.add(new State(state, this.node));
      return;
    }

    State s = (State) stack.next();
    s.state = state;
    s.node = this.node;
  }

  private int state()
  {
    State s = (State) stack.previous();
    stack.next();
    return s.state;
  }

  private Node pop()
  {
    return (Node) ((State) stack.previous()).node;
  }

  private int index(Switchable token)
  {
    converter.index = -1;
    token.apply(converter);
    return converter.index;
  }

  public Start parse() throws ParserException, LexerException, IOException
  {
    push(0, null, false);

    List ign = null;
    while(true)
    {
      while(index(lexer.peek()) == -1)
      {
        if(ign == null)
        {
          ign = new TypedLinkedList(NodeCast.instance);
        }

        ign.add(lexer.next());
      }

      if(ign != null)
      {
        ignoredTokens.setIn(lexer.peek(), ign);
        ign = null;
      }

      last_pos = lexer.peek().getPos();
      last_line = lexer.peek().getLine();
      last_token = lexer.peek();

      int index = index(lexer.peek());
      action[0] = actionTable[state()][0][1];
      action[1] = actionTable[state()][0][2];

      int low = 1;
      int high = actionTable[state()].length - 1;

      while(low <= high)
      {
        int middle = (low + high) / 2;

        if(index < actionTable[state()][middle][0])
        {
          high = middle - 1;
        }
        else if(index > actionTable[state()][middle][0])
        {
          low = middle + 1;
        }
        else
        {
          action[0] = actionTable[state()][middle][1];
          action[1] = actionTable[state()][middle][2];
          break;
        }
      }

      switch(action[0])
      {
      case SHIFT:
        push(action[1], lexer.next(), true);
        last_shift = action[1];
        break;
      case REDUCE:
        switch(action[1])
        {
        case 0:
          {
            Node node = new0();
            push(goTo(0), node, true);
          }
          break;
        case 1:
          {
            Node node = new1();
            push(goTo(0), node, true);
          }
          break;
        case 2:
          {
            Node node = new2();
            push(goTo(0), node, true);
          }
          break;
        case 3:
          {
            Node node = new3();
            push(goTo(0), node, true);
          }
          break;
        case 4:
          {
            Node node = new4();
            push(goTo(0), node, true);
          }
          break;
        case 5:
          {
            Node node = new5();
            push(goTo(0), node, true);
          }
          break;
        case 6:
          {
            Node node = new6();
            push(goTo(0), node, true);
          }
          break;
        case 7:
          {
            Node node = new7();
            push(goTo(0), node, true);
          }
          break;
        case 8:
          {
            Node node = new8();
            push(goTo(0), node, true);
          }
          break;
        case 9:
          {
            Node node = new9();
            push(goTo(0), node, true);
          }
          break;
        case 10:
          {
            Node node = new10();
            push(goTo(0), node, true);
          }
          break;
        case 11:
          {
            Node node = new11();
            push(goTo(0), node, true);
          }
          break;
        case 12:
          {
            Node node = new12();
            push(goTo(0), node, true);
          }
          break;
        case 13:
          {
            Node node = new13();
            push(goTo(0), node, true);
          }
          break;
        case 14:
          {
            Node node = new14();
            push(goTo(0), node, true);
          }
          break;
        case 15:
          {
            Node node = new15();
            push(goTo(0), node, true);
          }
          break;
        case 16:
          {
            Node node = new16();
            push(goTo(0), node, true);
          }
          break;
        case 17:
          {
            Node node = new17();
            push(goTo(0), node, true);
          }
          break;
        case 18:
          {
            Node node = new18();
            push(goTo(0), node, true);
          }
          break;
        case 19:
          {
            Node node = new19();
            push(goTo(0), node, true);
          }
          break;
        case 20:
          {
            Node node = new20();
            push(goTo(0), node, true);
          }
          break;
        case 21:
          {
            Node node = new21();
            push(goTo(0), node, true);
          }
          break;
        case 22:
          {
            Node node = new22();
            push(goTo(0), node, true);
          }
          break;
        case 23:
          {
            Node node = new23();
            push(goTo(0), node, true);
          }
          break;
        case 24:
          {
            Node node = new24();
            push(goTo(0), node, true);
          }
          break;
        case 25:
          {
            Node node = new25();
            push(goTo(0), node, true);
          }
          break;
        case 26:
          {
            Node node = new26();
            push(goTo(0), node, true);
          }
          break;
        case 27:
          {
            Node node = new27();
            push(goTo(0), node, true);
          }
          break;
        case 28:
          {
            Node node = new28();
            push(goTo(0), node, true);
          }
          break;
        case 29:
          {
            Node node = new29();
            push(goTo(0), node, true);
          }
          break;
        case 30:
          {
            Node node = new30();
            push(goTo(0), node, true);
          }
          break;
        case 31:
          {
            Node node = new31();
            push(goTo(0), node, true);
          }
          break;
        case 32:
          {
            Node node = new32();
            push(goTo(0), node, true);
          }
          break;
        case 33:
          {
            Node node = new33();
            push(goTo(0), node, true);
          }
          break;
        case 34:
          {
            Node node = new34();
            push(goTo(0), node, true);
          }
          break;
        case 35:
          {
            Node node = new35();
            push(goTo(0), node, true);
          }
          break;
        case 36:
          {
            Node node = new36();
            push(goTo(0), node, true);
          }
          break;
        case 37:
          {
            Node node = new37();
            push(goTo(0), node, true);
          }
          break;
        case 38:
          {
            Node node = new38();
            push(goTo(0), node, true);
          }
          break;
        case 39:
          {
            Node node = new39();
            push(goTo(0), node, true);
          }
          break;
        case 40:
          {
            Node node = new40();
            push(goTo(0), node, true);
          }
          break;
        case 41:
          {
            Node node = new41();
            push(goTo(0), node, true);
          }
          break;
        case 42:
          {
            Node node = new42();
            push(goTo(0), node, true);
          }
          break;
        case 43:
          {
            Node node = new43();
            push(goTo(0), node, true);
          }
          break;
        case 44:
          {
            Node node = new44();
            push(goTo(0), node, true);
          }
          break;
        case 45:
          {
            Node node = new45();
            push(goTo(0), node, true);
          }
          break;
        case 46:
          {
            Node node = new46();
            push(goTo(0), node, true);
          }
          break;
        case 47:
          {
            Node node = new47();
            push(goTo(0), node, true);
          }
          break;
        case 48:
          {
            Node node = new48();
            push(goTo(0), node, true);
          }
          break;
        case 49:
          {
            Node node = new49();
            push(goTo(0), node, true);
          }
          break;
        case 50:
          {
            Node node = new50();
            push(goTo(0), node, true);
          }
          break;
        case 51:
          {
            Node node = new51();
            push(goTo(0), node, true);
          }
          break;
        case 52:
          {
            Node node = new52();
            push(goTo(0), node, true);
          }
          break;
        case 53:
          {
            Node node = new53();
            push(goTo(0), node, true);
          }
          break;
        case 54:
          {
            Node node = new54();
            push(goTo(0), node, true);
          }
          break;
        case 55:
          {
            Node node = new55();
            push(goTo(0), node, true);
          }
          break;
        case 56:
          {
            Node node = new56();
            push(goTo(0), node, true);
          }
          break;
        case 57:
          {
            Node node = new57();
            push(goTo(0), node, true);
          }
          break;
        case 58:
          {
            Node node = new58();
            push(goTo(0), node, true);
          }
          break;
        case 59:
          {
            Node node = new59();
            push(goTo(0), node, true);
          }
          break;
        case 60:
          {
            Node node = new60();
            push(goTo(0), node, true);
          }
          break;
        case 61:
          {
            Node node = new61();
            push(goTo(0), node, true);
          }
          break;
        case 62:
          {
            Node node = new62();
            push(goTo(0), node, true);
          }
          break;
        case 63:
          {
            Node node = new63();
            push(goTo(0), node, true);
          }
          break;
        case 64:
          {
            Node node = new64();
            push(goTo(1), node, true);
          }
          break;
        case 65:
          {
            Node node = new65();
            push(goTo(2), node, true);
          }
          break;
        case 66:
          {
            Node node = new66();
            push(goTo(2), node, true);
          }
          break;
        case 67:
          {
            Node node = new67();
            push(goTo(34), node, false);
          }
          break;
        case 68:
          {
            Node node = new68();
            push(goTo(34), node, false);
          }
          break;
        case 69:
          {
            Node node = new69();
            push(goTo(3), node, true);
          }
          break;
        case 70:
          {
            Node node = new70();
            push(goTo(4), node, true);
          }
          break;
        case 71:
          {
            Node node = new71();
            push(goTo(35), node, false);
          }
          break;
        case 72:
          {
            Node node = new72();
            push(goTo(35), node, false);
          }
          break;
        case 73:
          {
            Node node = new73();
            push(goTo(5), node, true);
          }
          break;
        case 74:
          {
            Node node = new74();
            push(goTo(6), node, true);
          }
          break;
        case 75:
          {
            Node node = new75();
            push(goTo(7), node, true);
          }
          break;
        case 76:
          {
            Node node = new76();
            push(goTo(7), node, true);
          }
          break;
        case 77:
          {
            Node node = new77();
            push(goTo(36), node, false);
          }
          break;
        case 78:
          {
            Node node = new78();
            push(goTo(36), node, false);
          }
          break;
        case 79:
          {
            Node node = new79();
            push(goTo(8), node, true);
          }
          break;
        case 80:
          {
            Node node = new80();
            push(goTo(9), node, true);
          }
          break;
        case 81:
          {
            Node node = new81();
            push(goTo(37), node, false);
          }
          break;
        case 82:
          {
            Node node = new82();
            push(goTo(37), node, false);
          }
          break;
        case 83:
          {
            Node node = new83();
            push(goTo(10), node, true);
          }
          break;
        case 84:
          {
            Node node = new84();
            push(goTo(10), node, true);
          }
          break;
        case 85:
          {
            Node node = new85();
            push(goTo(10), node, true);
          }
          break;
        case 86:
          {
            Node node = new86();
            push(goTo(10), node, true);
          }
          break;
        case 87:
          {
            Node node = new87();
            push(goTo(11), node, true);
          }
          break;
        case 88:
          {
            Node node = new88();
            push(goTo(11), node, true);
          }
          break;
        case 89:
          {
            Node node = new89();
            push(goTo(11), node, true);
          }
          break;
        case 90:
          {
            Node node = new90();
            push(goTo(38), node, false);
          }
          break;
        case 91:
          {
            Node node = new91();
            push(goTo(38), node, false);
          }
          break;
        case 92:
          {
            Node node = new92();
            push(goTo(11), node, true);
          }
          break;
        case 93:
          {
            Node node = new93();
            push(goTo(12), node, true);
          }
          break;
        case 94:
          {
            Node node = new94();
            push(goTo(12), node, true);
          }
          break;
        case 95:
          {
            Node node = new95();
            push(goTo(13), node, true);
          }
          break;
        case 96:
          {
            Node node = new96();
            push(goTo(14), node, true);
          }
          break;
        case 97:
          {
            Node node = new97();
            push(goTo(14), node, true);
          }
          break;
        case 98:
          {
            Node node = new98();
            push(goTo(15), node, true);
          }
          break;
        case 99:
          {
            Node node = new99();
            push(goTo(16), node, true);
          }
          break;
        case 100:
          {
            Node node = new100();
            push(goTo(16), node, true);
          }
          break;
        case 101:
          {
            Node node = new101();
            push(goTo(39), node, false);
          }
          break;
        case 102:
          {
            Node node = new102();
            push(goTo(39), node, false);
          }
          break;
        case 103:
          {
            Node node = new103();
            push(goTo(17), node, true);
          }
          break;
        case 104:
          {
            Node node = new104();
            push(goTo(18), node, true);
          }
          break;
        case 105:
          {
            Node node = new105();
            push(goTo(18), node, true);
          }
          break;
        case 106:
          {
            Node node = new106();
            push(goTo(40), node, false);
          }
          break;
        case 107:
          {
            Node node = new107();
            push(goTo(40), node, false);
          }
          break;
        case 108:
          {
            Node node = new108();
            push(goTo(19), node, true);
          }
          break;
        case 109:
          {
            Node node = new109();
            push(goTo(19), node, true);
          }
          break;
        case 110:
          {
            Node node = new110();
            push(goTo(20), node, true);
          }
          break;
        case 111:
          {
            Node node = new111();
            push(goTo(20), node, true);
          }
          break;
        case 112:
          {
            Node node = new112();
            push(goTo(20), node, true);
          }
          break;
        case 113:
          {
            Node node = new113();
            push(goTo(20), node, true);
          }
          break;
        case 114:
          {
            Node node = new114();
            push(goTo(20), node, true);
          }
          break;
        case 115:
          {
            Node node = new115();
            push(goTo(21), node, true);
          }
          break;
        case 116:
          {
            Node node = new116();
            push(goTo(21), node, true);
          }
          break;
        case 117:
          {
            Node node = new117();
            push(goTo(21), node, true);
          }
          break;
        case 118:
          {
            Node node = new118();
            push(goTo(22), node, true);
          }
          break;
        case 119:
          {
            Node node = new119();
            push(goTo(22), node, true);
          }
          break;
        case 120:
          {
            Node node = new120();
            push(goTo(23), node, true);
          }
          break;
        case 121:
          {
            Node node = new121();
            push(goTo(23), node, true);
          }
          break;
        case 122:
          {
            Node node = new122();
            push(goTo(23), node, true);
          }
          break;
        case 123:
          {
            Node node = new123();
            push(goTo(24), node, true);
          }
          break;
        case 124:
          {
            Node node = new124();
            push(goTo(24), node, true);
          }
          break;
        case 125:
          {
            Node node = new125();
            push(goTo(25), node, true);
          }
          break;
        case 126:
          {
            Node node = new126();
            push(goTo(41), node, false);
          }
          break;
        case 127:
          {
            Node node = new127();
            push(goTo(41), node, false);
          }
          break;
        case 128:
          {
            Node node = new128();
            push(goTo(26), node, true);
          }
          break;
        case 129:
          {
            Node node = new129();
            push(goTo(27), node, true);
          }
          break;
        case 130:
          {
            Node node = new130();
            push(goTo(27), node, true);
          }
          break;
        case 131:
          {
            Node node = new131();
            push(goTo(42), node, false);
          }
          break;
        case 132:
          {
            Node node = new132();
            push(goTo(42), node, false);
          }
          break;
        case 133:
          {
            Node node = new133();
            push(goTo(28), node, true);
          }
          break;
        case 134:
          {
            Node node = new134();
            push(goTo(29), node, true);
          }
          break;
        case 135:
          {
            Node node = new135();
            push(goTo(29), node, true);
          }
          break;
        case 136:
          {
            Node node = new136();
            push(goTo(29), node, true);
          }
          break;
        case 137:
          {
            Node node = new137();
            push(goTo(43), node, false);
          }
          break;
        case 138:
          {
            Node node = new138();
            push(goTo(43), node, false);
          }
          break;
        case 139:
          {
            Node node = new139();
            push(goTo(29), node, true);
          }
          break;
        case 140:
          {
            Node node = new140();
            push(goTo(29), node, true);
          }
          break;
        case 141:
          {
            Node node = new141();
            push(goTo(29), node, true);
          }
          break;
        case 142:
          {
            Node node = new142();
            push(goTo(29), node, true);
          }
          break;
        case 143:
          {
            Node node = new143();
            push(goTo(29), node, true);
          }
          break;
        case 144:
          {
            Node node = new144();
            push(goTo(30), node, true);
          }
          break;
        case 145:
          {
            Node node = new145();
            push(goTo(31), node, true);
          }
          break;
        case 146:
          {
            Node node = new146();
            push(goTo(31), node, true);
          }
          break;
        case 147:
          {
            Node node = new147();
            push(goTo(31), node, true);
          }
          break;
        case 148:
          {
            Node node = new148();
            push(goTo(31), node, true);
          }
          break;
        case 149:
          {
            Node node = new149();
            push(goTo(31), node, true);
          }
          break;
        case 150:
          {
            Node node = new150();
            push(goTo(31), node, true);
          }
          break;
        case 151:
          {
            Node node = new151();
            push(goTo(31), node, true);
          }
          break;
        case 152:
          {
            Node node = new152();
            push(goTo(31), node, true);
          }
          break;
        case 153:
          {
            Node node = new153();
            push(goTo(32), node, true);
          }
          break;
        case 154:
          {
            Node node = new154();
            push(goTo(33), node, true);
          }
          break;
        case 155:
          {
            Node node = new155();
            push(goTo(33), node, true);
          }
          break;
        }
        break;
      case ACCEPT:
        {
          EOF node2 = (EOF) lexer.next();
          PGrammar node1 = (PGrammar) pop();
          Start node = new Start(node1, node2);
          return node;
        }
      case ERROR:
        throw new ParserException(last_token,
                                  "[" + last_line + "," + last_pos + "] " +
                                  errorMessages[errors[action[1]]]);
      }
    }
  }

  Node new0()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new1()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new2()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new3()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new4()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new5()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new6()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new7()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new8()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new9()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new10()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new11()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new12()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new13()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new14()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new15()
  {
    PProductions node6 = null;
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new16()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new17()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new18()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new19()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new20()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new21()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new22()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new23()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new24()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new25()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new26()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new27()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new28()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new29()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new30()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new31()
  {
    PProductions node6 = null;
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new32()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new33()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new34()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new35()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new36()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new37()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new38()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new39()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new40()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new41()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new42()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new43()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new44()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new45()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new46()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new47()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = null;
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new48()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new49()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new50()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new51()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new52()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new53()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new54()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new55()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = null;
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new56()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new57()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new58()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new59()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = null;
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new60()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new61()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = null;
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new62()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = null;
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new63()
  {
    PProductions node6 = (PProductions) pop();
    PIgnTokens node5 = (PIgnTokens) pop();
    PTokens node4 = (PTokens) pop();
    PStates node3 = (PStates) pop();
    PHelpers node2 = (PHelpers) pop();
    PPackage node1 = (PPackage) pop();
    AGrammar node = new AGrammar(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new64()
  {
    PPkgName node2 = (PPkgName) pop();
    TPackage node1 = (TPackage) pop();
    APackage node = new APackage(node1, node2);
    return node;
  }

  Node new65()
  {
    TSemicolon node3 = (TSemicolon) pop();
    XPPkgNameTail node2 = null;
    TPkgId node1 = (TPkgId) pop();
    APkgName node = new APkgName(node1, node2, node3);
    return node;
  }

  Node new66()
  {
    TSemicolon node3 = (TSemicolon) pop();
    XPPkgNameTail node2 = (XPPkgNameTail) pop();
    TPkgId node1 = (TPkgId) pop();
    APkgName node = new APkgName(node1, node2, node3);
    return node;
  }

  Node new67()
  {
    PPkgNameTail node2 = (PPkgNameTail) pop();
    XPPkgNameTail node1 = (XPPkgNameTail) pop();
    X1PPkgNameTail node = new X1PPkgNameTail(node1, node2);
    return node;
  }

  Node new68()
  {
    PPkgNameTail node1 = (PPkgNameTail) pop();
    X2PPkgNameTail node = new X2PPkgNameTail(node1);
    return node;
  }

  Node new69()
  {
    TPkgId node2 = (TPkgId) pop();
    TDot node1 = (TDot) pop();
    APkgNameTail node = new APkgNameTail(node1, node2);
    return node;
  }

  Node new70()
  {
    XPHelperDef node2 = (XPHelperDef) pop();
    THelpers node1 = (THelpers) pop();
    AHelpers node = new AHelpers(node1, node2);
    return node;
  }

  Node new71()
  {
    PHelperDef node2 = (PHelperDef) pop();
    XPHelperDef node1 = (XPHelperDef) pop();
    X1PHelperDef node = new X1PHelperDef(node1, node2);
    return node;
  }

  Node new72()
  {
    PHelperDef node1 = (PHelperDef) pop();
    X2PHelperDef node = new X2PHelperDef(node1);
    return node;
  }

  Node new73()
  {
    TSemicolon node4 = (TSemicolon) pop();
    PRegExp node3 = (PRegExp) pop();
    TEqual node2 = (TEqual) pop();
    TId node1 = (TId) pop();
    AHelperDef node = new AHelperDef(node1, node2, node3, node4);
    return node;
  }

  Node new74()
  {
    TSemicolon node3 = (TSemicolon) pop();
    PIdList node2 = (PIdList) pop();
    TStates node1 = (TStates) pop();
    AStates node = new AStates(node1, node2, node3);
    return node;
  }

  Node new75()
  {
    XPIdListTail node2 = null;
    TId node1 = (TId) pop();
    AIdList node = new AIdList(node1, node2);
    return node;
  }

  Node new76()
  {
    XPIdListTail node2 = (XPIdListTail) pop();
    TId node1 = (TId) pop();
    AIdList node = new AIdList(node1, node2);
    return node;
  }

  Node new77()
  {
    PIdListTail node2 = (PIdListTail) pop();
    XPIdListTail node1 = (XPIdListTail) pop();
    X1PIdListTail node = new X1PIdListTail(node1, node2);
    return node;
  }

  Node new78()
  {
    PIdListTail node1 = (PIdListTail) pop();
    X2PIdListTail node = new X2PIdListTail(node1);
    return node;
  }

  Node new79()
  {
    TId node2 = (TId) pop();
    TComma node1 = (TComma) pop();
    AIdListTail node = new AIdListTail(node1, node2);
    return node;
  }

  Node new80()
  {
    XPTokenDef node2 = (XPTokenDef) pop();
    TTokens node1 = (TTokens) pop();
    ATokens node = new ATokens(node1, node2);
    return node;
  }

  Node new81()
  {
    PTokenDef node2 = (PTokenDef) pop();
    XPTokenDef node1 = (XPTokenDef) pop();
    X1PTokenDef node = new X1PTokenDef(node1, node2);
    return node;
  }

  Node new82()
  {
    PTokenDef node1 = (PTokenDef) pop();
    X2PTokenDef node = new X2PTokenDef(node1);
    return node;
  }

  Node new83()
  {
    TSemicolon node6 = (TSemicolon) pop();
    PLookAhead node5 = null;
    PRegExp node4 = (PRegExp) pop();
    TEqual node3 = (TEqual) pop();
    TId node2 = (TId) pop();
    PStateList node1 = null;
    ATokenDef node = new ATokenDef(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new84()
  {
    TSemicolon node6 = (TSemicolon) pop();
    PLookAhead node5 = null;
    PRegExp node4 = (PRegExp) pop();
    TEqual node3 = (TEqual) pop();
    TId node2 = (TId) pop();
    PStateList node1 = (PStateList) pop();
    ATokenDef node = new ATokenDef(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new85()
  {
    TSemicolon node6 = (TSemicolon) pop();
    PLookAhead node5 = (PLookAhead) pop();
    PRegExp node4 = (PRegExp) pop();
    TEqual node3 = (TEqual) pop();
    TId node2 = (TId) pop();
    PStateList node1 = null;
    ATokenDef node = new ATokenDef(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new86()
  {
    TSemicolon node6 = (TSemicolon) pop();
    PLookAhead node5 = (PLookAhead) pop();
    PRegExp node4 = (PRegExp) pop();
    TEqual node3 = (TEqual) pop();
    TId node2 = (TId) pop();
    PStateList node1 = (PStateList) pop();
    ATokenDef node = new ATokenDef(node1, node2, node3, node4, node5, node6);
    return node;
  }

  Node new87()
  {
    TRBrace node5 = (TRBrace) pop();
    XPStateListTail node4 = null;
    PTransition node3 = null;
    TId node2 = (TId) pop();
    TLBrace node1 = (TLBrace) pop();
    AStateList node = new AStateList(node1, node2, node3, node4, node5);
    return node;
  }

  Node new88()
  {
    TRBrace node5 = (TRBrace) pop();
    XPStateListTail node4 = null;
    PTransition node3 = (PTransition) pop();
    TId node2 = (TId) pop();
    TLBrace node1 = (TLBrace) pop();
    AStateList node = new AStateList(node1, node2, node3, node4, node5);
    return node;
  }

  Node new89()
  {
    TRBrace node5 = (TRBrace) pop();
    XPStateListTail node4 = (XPStateListTail) pop();
    PTransition node3 = null;
    TId node2 = (TId) pop();
    TLBrace node1 = (TLBrace) pop();
    AStateList node = new AStateList(node1, node2, node3, node4, node5);
    return node;
  }

  Node new90()
  {
    PStateListTail node2 = (PStateListTail) pop();
    XPStateListTail node1 = (XPStateListTail) pop();
    X1PStateListTail node = new X1PStateListTail(node1, node2);
    return node;
  }

  Node new91()
  {
    PStateListTail node1 = (PStateListTail) pop();
    X2PStateListTail node = new X2PStateListTail(node1);
    return node;
  }

  Node new92()
  {
    TRBrace node5 = (TRBrace) pop();
    XPStateListTail node4 = (XPStateListTail) pop();
    PTransition node3 = (PTransition) pop();
    TId node2 = (TId) pop();
    TLBrace node1 = (TLBrace) pop();
    AStateList node = new AStateList(node1, node2, node3, node4, node5);
    return node;
  }

  Node new93()
  {
    PTransition node3 = null;
    TId node2 = (TId) pop();
    TComma node1 = (TComma) pop();
    AStateListTail node = new AStateListTail(node1, node2, node3);
    return node;
  }

  Node new94()
  {
    PTransition node3 = (PTransition) pop();
    TId node2 = (TId) pop();
    TComma node1 = (TComma) pop();
    AStateListTail node = new AStateListTail(node1, node2, node3);
    return node;
  }

  Node new95()
  {
    TId node2 = (TId) pop();
    TArrow node1 = (TArrow) pop();
    ATransition node = new ATransition(node1, node2);
    return node;
  }

  Node new96()
  {
    TSemicolon node4 = (TSemicolon) pop();
    PIdList node3 = null;
    TTokens node2 = (TTokens) pop();
    TIgnored node1 = (TIgnored) pop();
    AIgnTokens node = new AIgnTokens(node1, node2, node3, node4);
    return node;
  }

  Node new97()
  {
    TSemicolon node4 = (TSemicolon) pop();
    PIdList node3 = (PIdList) pop();
    TTokens node2 = (TTokens) pop();
    TIgnored node1 = (TIgnored) pop();
    AIgnTokens node = new AIgnTokens(node1, node2, node3, node4);
    return node;
  }

  Node new98()
  {
    PRegExp node2 = (PRegExp) pop();
    TSlash node1 = (TSlash) pop();
    ALookAhead node = new ALookAhead(node1, node2);
    return node;
  }

  Node new99()
  {
    XPRegExpTail node2 = null;
    PConcat node1 = (PConcat) pop();
    ARegExp node = new ARegExp(node1, node2);
    return node;
  }

  Node new100()
  {
    XPRegExpTail node2 = (XPRegExpTail) pop();
    PConcat node1 = (PConcat) pop();
    ARegExp node = new ARegExp(node1, node2);
    return node;
  }

  Node new101()
  {
    PRegExpTail node2 = (PRegExpTail) pop();
    XPRegExpTail node1 = (XPRegExpTail) pop();
    X1PRegExpTail node = new X1PRegExpTail(node1, node2);
    return node;
  }

  Node new102()
  {
    PRegExpTail node1 = (PRegExpTail) pop();
    X2PRegExpTail node = new X2PRegExpTail(node1);
    return node;
  }

  Node new103()
  {
    PConcat node2 = (PConcat) pop();
    TBar node1 = (TBar) pop();
    ARegExpTail node = new ARegExpTail(node1, node2);
    return node;
  }

  Node new104()
  {
    XPUnExp node1 = null;
    AConcat node = new AConcat(node1);
    return node;
  }

  Node new105()
  {
    XPUnExp node1 = (XPUnExp) pop();
    AConcat node = new AConcat(node1);
    return node;
  }

  Node new106()
  {
    PUnExp node2 = (PUnExp) pop();
    XPUnExp node1 = (XPUnExp) pop();
    X1PUnExp node = new X1PUnExp(node1, node2);
    return node;
  }

  Node new107()
  {
    PUnExp node1 = (PUnExp) pop();
    X2PUnExp node = new X2PUnExp(node1);
    return node;
  }

  Node new108()
  {
    PUnOp node2 = null;
    PBasic node1 = (PBasic) pop();
    AUnExp node = new AUnExp(node1, node2);
    return node;
  }

  Node new109()
  {
    PUnOp node2 = (PUnOp) pop();
    PBasic node1 = (PBasic) pop();
    AUnExp node = new AUnExp(node1, node2);
    return node;
  }

  Node new110()
  {
    PChar node1 = (PChar) pop();
    ACharBasic node = new ACharBasic(node1);
    return node;
  }

  Node new111()
  {
    PSet node1 = (PSet) pop();
    ASetBasic node = new ASetBasic(node1);
    return node;
  }

  Node new112()
  {
    TString node1 = (TString) pop();
    AStringBasic node = new AStringBasic(node1);
    return node;
  }

  Node new113()
  {
    TId node1 = (TId) pop();
    AIdBasic node = new AIdBasic(node1);
    return node;
  }

  Node new114()
  {
    TRPar node3 = (TRPar) pop();
    PRegExp node2 = (PRegExp) pop();
    TLPar node1 = (TLPar) pop();
    ARegExpBasic node = new ARegExpBasic(node1, node2, node3);
    return node;
  }

  Node new115()
  {
    TChar node1 = (TChar) pop();
    ACharChar node = new ACharChar(node1);
    return node;
  }

  Node new116()
  {
    TDecChar node1 = (TDecChar) pop();
    ADecChar node = new ADecChar(node1);
    return node;
  }

  Node new117()
  {
    THexChar node1 = (THexChar) pop();
    AHexChar node = new AHexChar(node1);
    return node;
  }

  Node new118()
  {
    TRBkt node5 = (TRBkt) pop();
    PBasic node4 = (PBasic) pop();
    PBinOp node3 = (PBinOp) pop();
    PBasic node2 = (PBasic) pop();
    TLBkt node1 = (TLBkt) pop();
    AOperationSet node = new AOperationSet(node1, node2, node3, node4, node5);
    return node;
  }

  Node new119()
  {
    TRBkt node5 = (TRBkt) pop();
    PChar node4 = (PChar) pop();
    TDDot node3 = (TDDot) pop();
    PChar node2 = (PChar) pop();
    TLBkt node1 = (TLBkt) pop();
    AIntervalSet node = new AIntervalSet(node1, node2, node3, node4, node5);
    return node;
  }

  Node new120()
  {
    TStar node1 = (TStar) pop();
    AStarUnOp node = new AStarUnOp(node1);
    return node;
  }

  Node new121()
  {
    TQMark node1 = (TQMark) pop();
    AQMarkUnOp node = new AQMarkUnOp(node1);
    return node;
  }

  Node new122()
  {
    TPlus node1 = (TPlus) pop();
    APlusUnOp node = new APlusUnOp(node1);
    return node;
  }

  Node new123()
  {
    TPlus node1 = (TPlus) pop();
    APlusBinOp node = new APlusBinOp(node1);
    return node;
  }

  Node new124()
  {
    TMinus node1 = (TMinus) pop();
    AMinusBinOp node = new AMinusBinOp(node1);
    return node;
  }

  Node new125()
  {
    XPProd node2 = (XPProd) pop();
    TProductions node1 = (TProductions) pop();
    AProductions node = new AProductions(node1, node2);
    return node;
  }

  Node new126()
  {
    PProd node2 = (PProd) pop();
    XPProd node1 = (XPProd) pop();
    X1PProd node = new X1PProd(node1, node2);
    return node;
  }

  Node new127()
  {
    PProd node1 = (PProd) pop();
    X2PProd node = new X2PProd(node1);
    return node;
  }

  Node new128()
  {
    TSemicolon node4 = (TSemicolon) pop();
    PAlts node3 = (PAlts) pop();
    TEqual node2 = (TEqual) pop();
    TId node1 = (TId) pop();
    AProd node = new AProd(node1, node2, node3, node4);
    return node;
  }

  Node new129()
  {
    XPAltsTail node2 = null;
    PAlt node1 = (PAlt) pop();
    AAlts node = new AAlts(node1, node2);
    return node;
  }

  Node new130()
  {
    XPAltsTail node2 = (XPAltsTail) pop();
    PAlt node1 = (PAlt) pop();
    AAlts node = new AAlts(node1, node2);
    return node;
  }

  Node new131()
  {
    PAltsTail node2 = (PAltsTail) pop();
    XPAltsTail node1 = (XPAltsTail) pop();
    X1PAltsTail node = new X1PAltsTail(node1, node2);
    return node;
  }

  Node new132()
  {
    PAltsTail node1 = (PAltsTail) pop();
    X2PAltsTail node = new X2PAltsTail(node1);
    return node;
  }

  Node new133()
  {
    PAlt node2 = (PAlt) pop();
    TBar node1 = (TBar) pop();
    AAltsTail node = new AAltsTail(node1, node2);
    return node;
  }

  Node new134()
  {
    XPElem node2 = null;
    PAltName node1 = null;
    AParsedAlt node = new AParsedAlt(node1, node2);
    return node;
  }

  Node new135()
  {
    XPElem node2 = null;
    PAltName node1 = (PAltName) pop();
    AParsedAlt node = new AParsedAlt(node1, node2);
    return node;
  }

  Node new136()
  {
    XPElem node2 = (XPElem) pop();
    PAltName node1 = null;
    AParsedAlt node = new AParsedAlt(node1, node2);
    return node;
  }

  Node new137()
  {
    PElem node2 = (PElem) pop();
    XPElem node1 = (XPElem) pop();
    X1PElem node = new X1PElem(node1, node2);
    return node;
  }

  Node new138()
  {
    PElem node1 = (PElem) pop();
    X2PElem node = new X2PElem(node1);
    return node;
  }

  Node new139()
  {
    XPElem node2 = (XPElem) pop();
    PAltName node1 = (PAltName) pop();
    AParsedAlt node = new AParsedAlt(node1, node2);
    return node;
  }

  Node new140()
  {
    TRPar node4 = (TRPar) pop();
    XPElem node3 = null;
    PAltName node2 = null;
    TLPar node1 = (TLPar) pop();
    AIgnoredAlt node = new AIgnoredAlt(node1, node2, node3, node4);
    return node;
  }

  Node new141()
  {
    TRPar node4 = (TRPar) pop();
    XPElem node3 = null;
    PAltName node2 = (PAltName) pop();
    TLPar node1 = (TLPar) pop();
    AIgnoredAlt node = new AIgnoredAlt(node1, node2, node3, node4);
    return node;
  }

  Node new142()
  {
    TRPar node4 = (TRPar) pop();
    XPElem node3 = (XPElem) pop();
    PAltName node2 = null;
    TLPar node1 = (TLPar) pop();
    AIgnoredAlt node = new AIgnoredAlt(node1, node2, node3, node4);
    return node;
  }

  Node new143()
  {
    TRPar node4 = (TRPar) pop();
    XPElem node3 = (XPElem) pop();
    PAltName node2 = (PAltName) pop();
    TLPar node1 = (TLPar) pop();
    AIgnoredAlt node = new AIgnoredAlt(node1, node2, node3, node4);
    return node;
  }

  Node new144()
  {
    TRBrace node3 = (TRBrace) pop();
    TId node2 = (TId) pop();
    TLBrace node1 = (TLBrace) pop();
    AAltName node = new AAltName(node1, node2, node3);
    return node;
  }

  Node new145()
  {
    PUnOp node4 = null;
    TId node3 = (TId) pop();
    PSpecifier node2 = null;
    PElemName node1 = null;
    AElem node = new AElem(node1, node2, node3, node4);
    return node;
  }

  Node new146()
  {
    PUnOp node4 = null;
    TId node3 = (TId) pop();
    PSpecifier node2 = null;
    PElemName node1 = (PElemName) pop();
    AElem node = new AElem(node1, node2, node3, node4);
    return node;
  }

  Node new147()
  {
    PUnOp node4 = null;
    TId node3 = (TId) pop();
    PSpecifier node2 = (PSpecifier) pop();
    PElemName node1 = null;
    AElem node = new AElem(node1, node2, node3, node4);
    return node;
  }

  Node new148()
  {
    PUnOp node4 = null;
    TId node3 = (TId) pop();
    PSpecifier node2 = (PSpecifier) pop();
    PElemName node1 = (PElemName) pop();
    AElem node = new AElem(node1, node2, node3, node4);
    return node;
  }

  Node new149()
  {
    PUnOp node4 = (PUnOp) pop();
    TId node3 = (TId) pop();
    PSpecifier node2 = null;
    PElemName node1 = null;
    AElem node = new AElem(node1, node2, node3, node4);
    return node;
  }

  Node new150()
  {
    PUnOp node4 = (PUnOp) pop();
    TId node3 = (TId) pop();
    PSpecifier node2 = null;
    PElemName node1 = (PElemName) pop();
    AElem node = new AElem(node1, node2, node3, node4);
    return node;
  }

  Node new151()
  {
    PUnOp node4 = (PUnOp) pop();
    TId node3 = (TId) pop();
    PSpecifier node2 = (PSpecifier) pop();
    PElemName node1 = null;
    AElem node = new AElem(node1, node2, node3, node4);
    return node;
  }

  Node new152()
  {
    PUnOp node4 = (PUnOp) pop();
    TId node3 = (TId) pop();
    PSpecifier node2 = (PSpecifier) pop();
    PElemName node1 = (PElemName) pop();
    AElem node = new AElem(node1, node2, node3, node4);
    return node;
  }

  Node new153()
  {
    TColon node4 = (TColon) pop();
    TRBkt node3 = (TRBkt) pop();
    TId node2 = (TId) pop();
    TLBkt node1 = (TLBkt) pop();
    AElemName node = new AElemName(node1, node2, node3, node4);
    return node;
  }

  Node new154()
  {
    TDot node2 = (TDot) pop();
    TTokenSpecifier node1 = (TTokenSpecifier) pop();
    ATokenSpecifier node = new ATokenSpecifier(node1, node2);
    return node;
  }

  Node new155()
  {
    TDot node2 = (TDot) pop();
    TProductionSpecifier node1 = (TProductionSpecifier) pop();
    AProductionSpecifier node = new AProductionSpecifier(node1, node2);
    return node;
  }

  private static int[][][] actionTable;
  /*      {
  			{{-1, REDUCE, 0}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, ERROR, 1}, {0, SHIFT, 14}, },
  			{{-1, ERROR, 2}, {28, SHIFT, 16}, },
  			{{-1, ERROR, 3}, {28, SHIFT, 18}, },
  			{{-1, ERROR, 4}, {17, SHIFT, 21}, {28, SHIFT, 22}, },
  			{{-1, ERROR, 5}, {4, SHIFT, 26}, },
  			{{-1, ERROR, 6}, {28, SHIFT, 27}, },
  			{{-1, ERROR, 7}, {33, ACCEPT, -1}, },
  			{{-1, REDUCE, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 2}, {2, SHIFT, 2}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 4}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 8}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 16}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 32}, },
  			{{-1, ERROR, 14}, {9, SHIFT, 45}, {11, SHIFT, 46}, },
  			{{-1, REDUCE, 64}, },
  			{{-1, REDUCE, 75}, {24, SHIFT, 49}, },
  			{{-1, ERROR, 17}, {11, SHIFT, 52}, },
  			{{-1, ERROR, 18}, {12, SHIFT, 53}, },
  			{{-1, REDUCE, 72}, },
  			{{-1, REDUCE, 70}, {28, SHIFT, 18}, },
  			{{-1, ERROR, 21}, {28, SHIFT, 55}, },
  			{{-1, ERROR, 22}, {12, SHIFT, 56}, },
  			{{-1, REDUCE, 82}, },
  			{{-1, ERROR, 24}, {28, SHIFT, 57}, },
  			{{-1, REDUCE, 80}, {17, SHIFT, 21}, {28, SHIFT, 22}, },
  			{{-1, ERROR, 26}, {11, SHIFT, 59}, {28, SHIFT, 16}, },
  			{{-1, ERROR, 27}, {12, SHIFT, 61}, },
  			{{-1, REDUCE, 127}, },
  			{{-1, REDUCE, 125}, {28, SHIFT, 27}, },
  			{{-1, REDUCE, 3}, {2, SHIFT, 2}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 5}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 9}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 17}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 33}, },
  			{{-1, REDUCE, 6}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 10}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 18}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 34}, },
  			{{-1, REDUCE, 12}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 20}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 36}, },
  			{{-1, REDUCE, 24}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 40}, },
  			{{-1, REDUCE, 48}, },
  			{{-1, ERROR, 45}, {0, SHIFT, 83}, },
  			{{-1, REDUCE, 65}, },
  			{{-1, REDUCE, 68}, },
  			{{-1, ERROR, 48}, {9, SHIFT, 45}, {11, SHIFT, 84}, },
  			{{-1, ERROR, 49}, {28, SHIFT, 86}, },
  			{{-1, REDUCE, 78}, },
  			{{-1, REDUCE, 76}, {24, SHIFT, 49}, },
  			{{-1, REDUCE, 74}, },
  			{{-1, REDUCE, 104}, {13, SHIFT, 88}, {15, SHIFT, 89}, {28, SHIFT, 90}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, {32, SHIFT, 94}, },
  			{{-1, REDUCE, 71}, },
  			{{-1, ERROR, 55}, {18, SHIFT, 102}, {24, SHIFT, 103}, {26, SHIFT, 104}, },
  			{{-1, REDUCE, 104}, {13, SHIFT, 88}, {15, SHIFT, 89}, {28, SHIFT, 90}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, {32, SHIFT, 94}, },
  			{{-1, ERROR, 57}, {12, SHIFT, 109}, },
  			{{-1, REDUCE, 81}, },
  			{{-1, REDUCE, 96}, },
  			{{-1, ERROR, 60}, {11, SHIFT, 110}, },
  			{{-1, REDUCE, 134}, {7, SHIFT, 111}, {8, SHIFT, 112}, {13, SHIFT, 113}, {15, SHIFT, 114}, {17, SHIFT, 115}, {28, SHIFT, 116}, },
  			{{-1, REDUCE, 126}, },
  			{{-1, REDUCE, 7}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 11}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 19}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 35}, },
  			{{-1, REDUCE, 13}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 21}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 37}, },
  			{{-1, REDUCE, 25}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 41}, },
  			{{-1, REDUCE, 49}, },
  			{{-1, REDUCE, 14}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 22}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 38}, },
  			{{-1, REDUCE, 26}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 42}, },
  			{{-1, REDUCE, 50}, },
  			{{-1, REDUCE, 28}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 44}, },
  			{{-1, REDUCE, 52}, },
  			{{-1, REDUCE, 56}, },
  			{{-1, REDUCE, 69}, },
  			{{-1, REDUCE, 66}, },
  			{{-1, REDUCE, 67}, },
  			{{-1, REDUCE, 79}, },
  			{{-1, REDUCE, 77}, },
  			{{-1, ERROR, 88}, {13, SHIFT, 88}, {15, SHIFT, 89}, {28, SHIFT, 90}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, {32, SHIFT, 94}, },
  			{{-1, REDUCE, 104}, {13, SHIFT, 88}, {15, SHIFT, 89}, {28, SHIFT, 90}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, {32, SHIFT, 94}, },
  			{{-1, REDUCE, 113}, },
  			{{-1, REDUCE, 115}, },
  			{{-1, REDUCE, 116}, },
  			{{-1, REDUCE, 117}, },
  			{{-1, REDUCE, 112}, },
  			{{-1, ERROR, 95}, {11, SHIFT, 142}, },
  			{{-1, REDUCE, 99}, {23, SHIFT, 143}, },
  			{{-1, REDUCE, 107}, },
  			{{-1, REDUCE, 108}, {19, SHIFT, 146}, {21, SHIFT, 147}, {22, SHIFT, 148}, },
  			{{-1, REDUCE, 110}, },
  			{{-1, REDUCE, 111}, },
  			{{-1, REDUCE, 105}, {13, SHIFT, 88}, {15, SHIFT, 89}, {28, SHIFT, 90}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, {32, SHIFT, 94}, },
  			{{-1, REDUCE, 87}, },
  			{{-1, ERROR, 103}, {28, SHIFT, 151}, },
  			{{-1, ERROR, 104}, {28, SHIFT, 152}, },
  			{{-1, REDUCE, 91}, },
  			{{-1, ERROR, 106}, {18, SHIFT, 153}, {24, SHIFT, 103}, },
  			{{-1, ERROR, 107}, {18, SHIFT, 155}, {24, SHIFT, 103}, },
  			{{-1, ERROR, 108}, {11, SHIFT, 157}, {25, SHIFT, 158}, },
  			{{-1, REDUCE, 104}, {13, SHIFT, 88}, {15, SHIFT, 89}, {28, SHIFT, 90}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, {32, SHIFT, 94}, },
  			{{-1, REDUCE, 97}, },
  			{{-1, ERROR, 111}, {9, SHIFT, 161}, },
  			{{-1, ERROR, 112}, {9, SHIFT, 162}, },
  			{{-1, ERROR, 113}, {28, SHIFT, 163}, },
  			{{-1, ERROR, 114}, {7, SHIFT, 111}, {8, SHIFT, 112}, {13, SHIFT, 113}, {16, SHIFT, 164}, {17, SHIFT, 115}, {28, SHIFT, 116}, },
  			{{-1, ERROR, 115}, {28, SHIFT, 167}, },
  			{{-1, REDUCE, 145}, {19, SHIFT, 146}, {21, SHIFT, 147}, {22, SHIFT, 148}, },
  			{{-1, ERROR, 117}, {11, SHIFT, 169}, },
  			{{-1, REDUCE, 129}, {23, SHIFT, 170}, },
  			{{-1, REDUCE, 135}, {7, SHIFT, 111}, {8, SHIFT, 112}, {13, SHIFT, 113}, {28, SHIFT, 116}, },
  			{{-1, REDUCE, 138}, },
  			{{-1, ERROR, 121}, {7, SHIFT, 111}, {8, SHIFT, 112}, {28, SHIFT, 174}, },
  			{{-1, ERROR, 122}, {28, SHIFT, 176}, },
  			{{-1, REDUCE, 136}, {7, SHIFT, 111}, {8, SHIFT, 112}, {13, SHIFT, 113}, {28, SHIFT, 116}, },
  			{{-1, REDUCE, 15}, {5, SHIFT, 5}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 23}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 39}, },
  			{{-1, REDUCE, 27}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 43}, },
  			{{-1, REDUCE, 51}, },
  			{{-1, REDUCE, 29}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 45}, },
  			{{-1, REDUCE, 53}, },
  			{{-1, REDUCE, 57}, },
  			{{-1, REDUCE, 30}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 46}, },
  			{{-1, REDUCE, 54}, },
  			{{-1, REDUCE, 58}, },
  			{{-1, REDUCE, 60}, },
  			{{-1, ERROR, 139}, {19, SHIFT, 184}, {20, SHIFT, 185}, },
  			{{-1, REDUCE, 110}, {10, SHIFT, 187}, },
  			{{-1, ERROR, 141}, {16, SHIFT, 188}, },
  			{{-1, REDUCE, 73}, },
  			{{-1, REDUCE, 104}, {13, SHIFT, 88}, {15, SHIFT, 89}, {28, SHIFT, 90}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, {32, SHIFT, 94}, },
  			{{-1, REDUCE, 102}, },
  			{{-1, REDUCE, 100}, {23, SHIFT, 143}, },
  			{{-1, REDUCE, 122}, },
  			{{-1, REDUCE, 121}, },
  			{{-1, REDUCE, 120}, },
  			{{-1, REDUCE, 109}, },
  			{{-1, REDUCE, 106}, },
  			{{-1, REDUCE, 93}, {26, SHIFT, 104}, },
  			{{-1, REDUCE, 95}, },
  			{{-1, REDUCE, 88}, },
  			{{-1, ERROR, 154}, {18, SHIFT, 192}, {24, SHIFT, 103}, },
  			{{-1, REDUCE, 89}, },
  			{{-1, REDUCE, 90}, },
  			{{-1, REDUCE, 83}, },
  			{{-1, REDUCE, 104}, {13, SHIFT, 88}, {15, SHIFT, 89}, {28, SHIFT, 90}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, {32, SHIFT, 94}, },
  			{{-1, ERROR, 159}, {11, SHIFT, 194}, },
  			{{-1, ERROR, 160}, {11, SHIFT, 195}, {25, SHIFT, 158}, },
  			{{-1, REDUCE, 154}, },
  			{{-1, REDUCE, 155}, },
  			{{-1, ERROR, 163}, {14, SHIFT, 197}, },
  			{{-1, REDUCE, 140}, },
  			{{-1, ERROR, 165}, {7, SHIFT, 111}, {8, SHIFT, 112}, {13, SHIFT, 113}, {16, SHIFT, 198}, {28, SHIFT, 116}, },
  			{{-1, ERROR, 166}, {7, SHIFT, 111}, {8, SHIFT, 112}, {13, SHIFT, 113}, {16, SHIFT, 200}, {28, SHIFT, 116}, },
  			{{-1, ERROR, 167}, {18, SHIFT, 201}, },
  			{{-1, REDUCE, 149}, },
  			{{-1, REDUCE, 128}, },
  			{{-1, REDUCE, 134}, {7, SHIFT, 111}, {8, SHIFT, 112}, {13, SHIFT, 113}, {15, SHIFT, 114}, {17, SHIFT, 115}, {28, SHIFT, 116}, },
  			{{-1, REDUCE, 132}, },
  			{{-1, REDUCE, 130}, {23, SHIFT, 170}, },
  			{{-1, REDUCE, 139}, {7, SHIFT, 111}, {8, SHIFT, 112}, {13, SHIFT, 113}, {28, SHIFT, 116}, },
  			{{-1, REDUCE, 146}, {19, SHIFT, 146}, {21, SHIFT, 147}, {22, SHIFT, 148}, },
  			{{-1, ERROR, 175}, {28, SHIFT, 205}, },
  			{{-1, REDUCE, 147}, {19, SHIFT, 146}, {21, SHIFT, 147}, {22, SHIFT, 148}, },
  			{{-1, REDUCE, 137}, },
  			{{-1, REDUCE, 31}, {6, SHIFT, 6}, },
  			{{-1, REDUCE, 47}, },
  			{{-1, REDUCE, 55}, },
  			{{-1, REDUCE, 59}, },
  			{{-1, REDUCE, 61}, },
  			{{-1, REDUCE, 62}, },
  			{{-1, REDUCE, 123}, },
  			{{-1, REDUCE, 124}, },
  			{{-1, ERROR, 186}, {13, SHIFT, 88}, {15, SHIFT, 89}, {28, SHIFT, 90}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, {32, SHIFT, 94}, },
  			{{-1, ERROR, 187}, {29, SHIFT, 91}, {30, SHIFT, 92}, {31, SHIFT, 93}, },
  			{{-1, REDUCE, 114}, },
  			{{-1, REDUCE, 103}, },
  			{{-1, REDUCE, 101}, },
  			{{-1, REDUCE, 94}, },
  			{{-1, REDUCE, 92}, },
  			{{-1, REDUCE, 98}, },
  			{{-1, REDUCE, 85}, },
  			{{-1, REDUCE, 84}, },
  			{{-1, ERROR, 196}, {11, SHIFT, 210}, },
  			{{-1, ERROR, 197}, {27, SHIFT, 211}, },
  			{{-1, REDUCE, 141}, },
  			{{-1, ERROR, 199}, {7, SHIFT, 111}, {8, SHIFT, 112}, {13, SHIFT, 113}, {16, SHIFT, 212}, {28, SHIFT, 116}, },
  			{{-1, REDUCE, 142}, },
  			{{-1, REDUCE, 144}, },
  			{{-1, REDUCE, 133}, },
  			{{-1, REDUCE, 131}, },
  			{{-1, REDUCE, 150}, },
  			{{-1, REDUCE, 148}, {19, SHIFT, 146}, {21, SHIFT, 147}, {22, SHIFT, 148}, },
  			{{-1, REDUCE, 151}, },
  			{{-1, REDUCE, 63}, },
  			{{-1, ERROR, 208}, {14, SHIFT, 214}, },
  			{{-1, ERROR, 209}, {14, SHIFT, 215}, },
  			{{-1, REDUCE, 86}, },
  			{{-1, REDUCE, 153}, },
  			{{-1, REDUCE, 143}, },
  			{{-1, REDUCE, 152}, },
  			{{-1, REDUCE, 118}, },
  			{{-1, REDUCE, 119}, },
          };*/
  private static int[][][] gotoTable;
  /*      {
  			{{-1, 7}, },
  			{{-1, 8}, },
  			{{-1, 15}, },
  			{{-1, 47}, {48, 85}, },
  			{{-1, 9}, {8, 30}, },
  			{{-1, 19}, {20, 54}, },
  			{{-1, 10}, {8, 31}, {9, 35}, {30, 63}, },
  			{{-1, 17}, {26, 60}, },
  			{{-1, 50}, {51, 87}, },
  			{{-1, 11}, {8, 32}, {9, 36}, {10, 39}, {30, 64}, {31, 67}, {35, 73}, {63, 124}, },
  			{{-1, 23}, {25, 58}, },
  			{{-1, 24}, },
  			{{-1, 105}, {107, 156}, {154, 156}, },
  			{{-1, 106}, {151, 191}, },
  			{{-1, 12}, {8, 33}, {9, 37}, {10, 40}, {11, 42}, {30, 65}, {31, 68}, {32, 70}, {35, 74}, {36, 76}, {39, 79}, {63, 125}, {64, 127}, {67, 130}, {73, 134}, {124, 178}, },
  			{{-1, 159}, {160, 196}, },
  			{{-1, 95}, {56, 108}, {89, 141}, {109, 160}, {158, 193}, },
  			{{-1, 144}, {145, 190}, },
  			{{-1, 96}, {143, 189}, },
  			{{-1, 97}, {101, 150}, },
  			{{-1, 98}, {88, 139}, {186, 208}, },
  			{{-1, 99}, {88, 140}, {187, 209}, },
  			{{-1, 100}, },
  			{{-1, 149}, {116, 168}, {174, 204}, {176, 206}, {205, 213}, },
  			{{-1, 186}, },
  			{{-1, 13}, {8, 34}, {9, 38}, {10, 41}, {11, 43}, {12, 44}, {30, 66}, {31, 69}, {32, 71}, {33, 72}, {35, 75}, {36, 77}, {37, 78}, {39, 80}, {40, 81}, {42, 82}, {63, 126}, {64, 128}, {65, 129}, {67, 131}, {68, 132}, {70, 133}, {73, 135}, {74, 136}, {76, 137}, {79, 138}, {124, 179}, {125, 180}, {127, 181}, {130, 182}, {134, 183}, {178, 207}, },
  			{{-1, 28}, {29, 62}, },
  			{{-1, 117}, },
  			{{-1, 171}, {172, 203}, },
  			{{-1, 118}, {170, 202}, },
  			{{-1, 119}, {114, 165}, },
  			{{-1, 120}, {123, 177}, {166, 177}, {173, 177}, {199, 177}, },
  			{{-1, 121}, },
  			{{-1, 122}, {121, 175}, },
  			{{-1, 48}, },
  			{{-1, 20}, },
  			{{-1, 51}, },
  			{{-1, 25}, },
  			{{-1, 107}, {106, 154}, },
  			{{-1, 145}, },
  			{{-1, 101}, },
  			{{-1, 29}, },
  			{{-1, 172}, },
  			{{-1, 123}, {114, 166}, {119, 173}, {165, 199}, },
          };*/
  private static String[] errorMessages;
  /*      {
  			"expecting: 'Package', 'States', 'Helpers', 'Tokens', 'Ignored', 'Productions', EOF",
  			"expecting: pkg id",
  			"expecting: id",
  			"expecting: '{', id",
  			"expecting: 'Tokens'",
  			"expecting: EOF",
  			"expecting: 'States', 'Helpers', 'Tokens', 'Ignored', 'Productions', EOF",
  			"expecting: 'States', 'Tokens', 'Ignored', 'Productions', EOF",
  			"expecting: 'Tokens', 'Ignored', 'Productions', EOF",
  			"expecting: 'Ignored', 'Productions', EOF",
  			"expecting: 'Productions', EOF",
  			"expecting: '.', ';'",
  			"expecting: ';', ','",
  			"expecting: ';'",
  			"expecting: '='",
  			"expecting: 'States', 'Tokens', 'Ignored', 'Productions', id, EOF",
  			"expecting: 'Ignored', 'Productions', '{', id, EOF",
  			"expecting: ';', id",
  			"expecting: id, EOF",
  			"expecting: ';', '[', '(', '|', id, char, dec char, hex char, string",
  			"expecting: '}', ',', '->'",
  			"expecting: ';', '[', '(', '|', '/', id, char, dec char, hex char, string",
  			"expecting: 'T', 'P', ';', '[', '(', '{', '|', id",
  			"expecting: '[', '(', id, char, dec char, hex char, string",
  			"expecting: '[', '(', ')', '|', id, char, dec char, hex char, string",
  			"expecting: ';', '[', ']', '(', ')', '+', '-', '?', '*', '|', '/', id, char, dec char, hex char, string",
  			"expecting: '..', ';', '[', ']', '(', ')', '+', '-', '?', '*', '|', '/', id, char, dec char, hex char, string",
  			"expecting: ';', ')', '|', '/'",
  			"expecting: ';', '[', '(', ')', '|', '/', id, char, dec char, hex char, string",
  			"expecting: ';', '[', '(', ')', '+', '?', '*', '|', '/', id, char, dec char, hex char, string",
  			"expecting: ';', '[', ']', '(', ')', '+', '?', '*', '|', '/', id, char, dec char, hex char, string",
  			"expecting: '}', ','",
  			"expecting: ';', '/'",
  			"expecting: '.'",
  			"expecting: 'T', 'P', '[', ')', '{', id",
  			"expecting: 'T', 'P', ';', '[', ')', '+', '?', '*', '|', id",
  			"expecting: ';', '|'",
  			"expecting: 'T', 'P', ';', '[', '|', id",
  			"expecting: 'T', 'P', ';', '[', ')', '|', id",
  			"expecting: 'T', 'P', id",
  			"expecting: '+', '-'",
  			"expecting: '..', '+', '-'",
  			"expecting: ')'",
  			"expecting: 'T', 'P', ';', '[', '(', ')', '|', '/', id, char, dec char, hex char, string",
  			"expecting: ']'",
  			"expecting: 'T', 'P', '[', ')', id",
  			"expecting: '}'",
  			"expecting: char, dec char, hex char",
  			"expecting: ':'",
          };*/
  private static int[] errors;
  /*      {
  			0, 1, 2, 2, 3, 4, 2, 5, 6, 7, 8, 9, 10, 5, 11, 6, 12, 13, 14, 15, 15, 2, 14, 16, 2, 16, 17, 14, 18, 18, 7, 8, 9, 10, 5, 8, 9, 10, 5, 9, 10, 5, 10, 5, 5, 1, 6, 11, 11, 2, 12, 12, 8, 19, 15, 20, 21, 14, 16, 10, 13, 22, 18, 8, 9, 10, 5, 9, 10, 5, 10, 5, 5, 9, 10, 5, 10, 5, 5, 10, 5, 5, 5, 11, 6, 11, 12, 12, 23, 24, 25, 26, 26, 26, 25, 13, 27, 28, 29, 30, 25, 28, 2, 2, 2, 31, 31, 31, 32, 21, 10, 33, 33, 2, 34, 2, 35, 13, 36, 37, 38, 39, 2, 37, 9, 10, 5, 10, 5, 5, 10, 5, 5, 5, 10, 5, 5, 5, 5, 40, 41, 42, 15, 28, 27, 27, 43, 43, 43, 28, 28, 20, 31, 2, 31, 2, 31, 16, 19, 13, 32, 2, 2, 44, 36, 45, 45, 46, 38, 18, 22, 36, 36, 37, 35, 2, 35, 38, 10, 5, 5, 5, 5, 5, 23, 23, 23, 47, 25, 27, 27, 31, 2, 13, 16, 16, 13, 48, 36, 45, 36, 38, 36, 36, 38, 35, 38, 5, 44, 44, 16, 39, 36, 38, 25, 25, 
          };*/
}
