#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc BoxDialog {frame id} {
    global marker

    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # Init common items

    InitMarkerDialog $frame $id
    PropMenuMarkerDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordBoxCB
    CoordMarkerCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyBoxDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "CloseBoxDialog $frame $id"

    # box menu items

    set marker($frame,$id,scoord) $marker(dialog,dist,system)
    set marker($frame,$id,slabel) $marker(dialog,dist,system)
    set marker($frame,$id,sformat) $marker(dialog,dist,format)

    DistMenuMarkerDialog $frame $mb $id DistBoxCB size scoord sformat
    $mb add cascade -label Size -menu $mb.size
    DistBoxCB $frame $id

    # Init box variables

    EditBoxCB $frame $id
    RotateMarkerCB $frame $id

    # box specific callbacks

    $frame marker $id callback edit EditBoxCB $frame
    $frame marker $id callback edit MoveMarkerCB $frame
    $frame marker $id callback rotate RotateMarkerCB $frame
    $frame marker $id callback delete DeleteBoxDialog $frame

    # Dialog

    CommonMarkerDialog $frame $id
    wm protocol $w WM_DELETE_WINDOW "CloseBoxDialog $frame $id"

    # Size

    label $w.ref.f.widthTitle -text "Width/Height"
    entry $w.ref.f.width -textvariable marker($frame,$id,width) \
	-width 13 
    entry $w.ref.f.height -textvariable marker($frame,$id,height) \
	-width 13 
    label $w.ref.f.sizeCoord -textvariable marker($frame,$id,slabel) \
	-relief groove -width 9 -padx 4
    label $w.ref.f.angleTitle -text "Angle"
    entry $w.ref.f.angle -textvariable marker($frame,$id,angle) \
	-width 13 
    label $w.ref.f.angleUnit -relief groove -width 9 -padx 4 \
	-text "degrees"

    grid $w.ref.f.widthTitle $w.ref.f.width $w.ref.f.height \
	$w.ref.f.sizeCoord -padx 4 -sticky w
    grid $w.ref.f.angleTitle $w.ref.f.angle x $w.ref.f.angleUnit \
	-padx 4 -sticky w

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyBoxDialog $frame $id"
    button $w.buttons.close -text "Close" \
	-command "CloseBoxDialog $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "ApplyBoxDialog $frame $id"

    # some window managers need a hint
    raise $w
}

proc ApplyBoxDialog {frame id} {
    # do this first, since editbox will do a MoveMarkerCB
    ApplyMarkerDialog $frame $id

    EditBoxDialog $frame $id
    RotateMarkerDialog $frame $id
}

proc CloseBoxDialog {frame id} {
    global marker

    $frame marker $id delete callback edit EditBoxCB
    $frame marker $id delete callback edit MoveMarkerCB
    $frame marker $id delete callback rotate RotateMarkerCB
    $frame marker $id delete callback delete DeleteBoxDialog
    DeleteMarkerCBs $frame $id

    DeleteBoxDialog $frame $id
}

proc DeleteBoxDialog {frame id} {
    global marker

    DeleteMarkerDialog $frame $id

    unset marker($frame,$id,width)
    unset marker($frame,$id,height)
    unset marker($frame,$id,angle)
    unset marker($frame,$id,scoord)
    unset marker($frame,$id,sformat)
    unset marker($frame,$id,slabel)
}

proc EditBoxDialog {frame id} {
    global marker

    $frame marker $id box size \
	$marker($frame,$id,width) $marker($frame,$id,height) \
	$marker($frame,$id,scoord) $marker($frame,$id,sformat)
}

proc EditBoxCB {frame id} {
    global marker

    set f [$frame get marker $id box size \
	       $marker($frame,$id,scoord) $marker($frame,$id,sformat)]

    set marker($frame,$id,width) [lindex $f 0]
    set marker($frame,$id,height) [lindex $f 1]
}

proc CoordBoxCB {frame id} {
    CoordMarkerCB $frame $id

    MoveMarkerCB $frame $id
    EditBoxCB $frame $id
    RotateMarkerCB $frame $id
}

proc DistBoxCB {frame id} {
    global marker
    set mb ".mb$id"

    AdjustDist $frame marker($frame,$id,scoord)

    set marker($frame,$id,slabel) $marker($frame,$id,scoord)
    switch -- $marker($frame,$id,scoord) {
	image -
	physical -
	amplifier -
	detector {}
	default {
	    if [$frame has wcs $marker($frame,$id,scoord)] {
		if [$frame has wcs equatorial $marker($frame,$id,scoord)] {
		    set marker($frame,$id,slabel) $marker($frame,$id,sformat)
		} else {
		    set name [$frame get wcs name $marker($frame,$id,scoord)]
		    if {$name != ""} {
			set marker($frame,$id,slabel) $name
		    }
		}
	    }
	}
    }

    MoveMarkerCB $frame $id
    EditBoxCB $frame $id
}

proc BoxDefaultDialog {} {
    global marker
    global ed

    set w ".box"

    set ed(ok) 0
    set ed(width) $marker(box,width)
    set ed(height) $marker(box,height)

    DialogCreate $w "Default Box" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.title -text "Width"
    entry $w.ed.width -textvariable ed(width) -width 10 
    label $w.ed.unit -text "image" -relief groove -width 8
    
    label $w.ed.title2 -text "Height"
    entry $w.ed.height -textvariable ed(height) -width 10 
    label $w.ed.unit2 -text "image" -relief groove -width 8

    grid $w.ed.title $w.ed.width $w.ed.unit -padx 4  -pady 1 -sticky w
    grid $w.ed.title2 $w.ed.height $w.ed.unit2 -padx 4  -pady 1 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.width select range 0 end
    DialogWait $w ed(ok) $w.ed.width
    DialogDismiss $w

    if {$ed(ok)} {
	set marker(box,width) $ed(width)
	set marker(box,height) $ed(height)
    }

    unset ed
}
