// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __callback_h__
#define __callback_h__

#include <tcl.h>

class CallBack {
  Tcl_Interp* interp_;
  char proc_[32];
  char arg_[64];

  CallBack* previous_;
  CallBack* next_;

public:
  CallBack(const CallBack&);
  CallBack(Tcl_Interp*, const char*, const char*);
  CallBack& operator=(const CallBack&);

  int eval(const char*);

  const char* proc() {return proc_;}
  const char* arg() {return arg_;}

  CallBack* previous() {return previous_;}
  void setPrevious(CallBack* cb) {previous_ = cb;}
  CallBack* next() {return next_;}
  void setNext(CallBack* cb) {next_ = cb;}
};

#endif
