/* Copyright (C) 1999-2004
 * Smithsonian Astrophysical Observatory, Cambridge, MA, USA
 * For conditions of distribution and use, see copyright notice in "copyright"
 */

%option noyywrap
%option caseless
%option never-interactive
%option c++

%{
  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>

  #include "util.h"
  #include "ciaoparser.H"

  extern ciaoFlexLexer* ciaolexx;
  extern int ciaosign;
%}

D   [0-9]
E   [Ee][+-]?{D}+

/* rules */

%%

annulus			{return ANNULUS_;}
box			{return BOX_;}
circle			{return CIRCLE_;}
debug			{return DEBUG_;}
ellipse			{return ELLIPSE_;}
off			{return OFF_;}
on			{return ON_;}
pie			{return PIE_;}
point			{return POINT_;}
polygon			{return POLYGON_;}
rotbox			{return ROTBOX_;}
version			{return VERSION_;}

[+-]?{D}+	{ // Integer
		  ciaolval.integer = atoi(yytext);
		  ciaosign = (yytext[0]!='-') ? 1 : -1;
		  return INT;
		}

[+-]?{D}+"."?({E})? |
[+-]?{D}*"."{D}+({E})? { // Real Number
		  ciaolval.real = atof(yytext);
		  return REAL;
		}

{D}+"."?' |
{D}*"."{D}+'	{ // minutes of arc
		  yytext[yyleng-1] = '\0';
		  ciaolval.real = atof(yytext);
		  return ARCMINUTE;
		}	

{D}+"."?\" |
{D}*"."{D}+\"	{ // seconds of arc
		  yytext[yyleng-1] = '\0';
		  ciaolval.real = atof(yytext);
		  return ARCSECOND;
		}

[+-]?{D}+h	{ // hours
		  yytext[yyleng-1] = '\0';
		  ciaolval.integer = atoi(yytext);
		  ciaosign = (yytext[0]!='-') ? 1 : -1;
		  return HOUR;
		}	

{D}+m		{ // minutes
		  yytext[yyleng-1] = '\0';
		  ciaolval.integer = atoi(yytext);
		  return MINUTE;
		}	

{D}+"."?s |
{D}*"."{D}+s	{ // seconds
		  yytext[yyleng-1] = '\0';
		  ciaolval.real = atof(yytext);
		  return SECOND;
		}

[+-]?{D}+:{D}+:{D}+"."? |
[+-]?{D}+:{D}+:{D}*"."{D}+ { // Sexagesimal
		  strncpy(ciaolval.str,yytext,256);
		  return SEXSTR;
		}	

#.*		{ // comment, eat it
		}

[ \t]+		{ // White Spaces
		} 

\n		{ // linefeed
		  return '\n';
		}

\\n		{ // fake line feed
		  return '\n';
		}

.		{ // Else, return the char
		  return yytext[0];
		}

%%
