// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __circle_h__
#define __circle_h__

#include "basecircle.h"

class Circle : public BaseCircle {
public:
  Circle(const Circle&);
  Circle(FrameBase* p, const Vector& ctr, double r,
	 const char* clr, int w, const char* f, 
	 const char* t, unsigned short prop, const char* c,
	 const List<Tag>& tag);

  Marker* dup() {return new Circle(*this);}
  void updateBBox();
  void edit(const Vector&, int);

  double getRadius() {return radii[0];}
  void setRadius(double);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOimage(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif
