'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 2000 Scriptics Corporation.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: source.n,v 1.1.1.1 2004/04/02 22:33:45 joye Exp $
'\" 
.so man.macros
.TH source n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
source \- Evaluate a file or resource as a Tcl script
.SH SYNOPSIS
\fBsource \fIfileName\fR
.sp
\fBsource\fR \fB\-rsrc \fIresourceName \fR?\fIfileName\fR?
.sp
\fBsource\fR \fB\-rsrcid \fIresourceId \fR?\fIfileName\fR?
.BE

.SH DESCRIPTION
.PP
This command takes the contents of the specified file or resource
and passes it to the Tcl interpreter as a text script.  The return
value from \fBsource\fR is the return value of the last command
executed in the script.  If an error occurs in evaluating the contents
of the script then the \fBsource\fR command will return that error.
If a \fBreturn\fR command is invoked from within the script then the
remainder of the file will be skipped and the \fBsource\fR command
will return normally with the result from the \fBreturn\fR command.
.PP
.VS 8.4
The end-of-file character for files is '\\32' (^Z) for all platforms.
The source command will read files up to this character.  This
restriction does not exist for the \fBread\fR or \fBgets\fR commands,
allowing for files containing code and data segments (scripted documents).
If you require a ``^Z'' in code for string comparison, you can use
``\\032'' or ``\\u001a'', which will be safely substituted by the Tcl
interpreter into ``^Z''.
.VE 8.4
.PP
The \fI\-rsrc\fR and \fI\-rsrcid\fR forms of this command are only
available on Macintosh computers.  These versions of the command
allow you to source a script from a \fBTEXT\fR resource.  You may specify
what \fBTEXT\fR resource to source by either name or id.  By default Tcl
searches all open resource files, which include the current
application and any loaded C extensions.  Alternatively, you may
specify the \fIfileName\fR where the \fBTEXT\fR resource can be found.

.SH "SEE ALSO"
file(n), cd(n)

.SH KEYWORDS
file, script
