
// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRScram_BreakStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_BreakElement.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "IIR_Label.hh"
#include "resolution_func.hh"
#include "error_func.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Declaration.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_AboveAttribute.hh"
#include "sstream-wrap.hh"

extern symbol_table sym_tab;

IIRScram_BreakStatement::~IIRScram_BreakStatement() {}

void
IIRScram_BreakStatement::_publish_vhdl(ostream &_vhdl_out) {
  _publish_vhdl_stmt_label(_vhdl_out);
  _vhdl_out << " break " ;
  if ( break_list.num_elements() != 0) {
    break_list._publish_vhdl(_vhdl_out);
  }
  if ( get_condition() != NULL ) {
    _vhdl_out << " when " ;
    get_condition()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " \n" ;
  }
}

void
IIRScram_BreakStatement::_publish_cc(published_file &_cc_out) {
  string signalname ;
  string stateclass ;
  int condn_present = 0 ;
  int i = 0;
  signalname = _get_process_stmt_label()->_to_string();
  int count = 0 ;
  int len = signalname.size(); 
  char *charlabel = new char[len];  
  strcpy(charlabel,signalname.c_str());
  for(i= len-1 ; i>0 ; i--) {
    if (charlabel[i]== '_') count++;
    if (count == 1) break;
  }
  charlabel[i] = '\0';
  stateclass = string(charlabel);
  if(get_condition() != NULL) {
    _cc_out << "if (SAVANT_BOOLEAN_TRUE.vhdlEqual(" ;
    get_condition()->_publish_cc_rvalue(_cc_out);
    _cc_out << ") ){" << NL();
    condn_present = 1;
  }
  _cc_out << "assignSignal((("<< stateclass <<"_state *)getState())->"<< signalname
	  << ", this, EnumerationType(ObjectBase::VARIABLE, "
	  << "1, SavantbooleanType_info), SAVANT_ZERO_TIME, "
	  << "SAVANT_ZERO_TIME, defaultInfo, defaultInfo);"
	  << NL()
	  << "breakflag = 1;  "<< NL() ;
  if(condn_present) {
    _cc_out << "}" << NL();
  }
}

void
IIRScram_BreakStatement::_publish_cc_ams() {
}

void
IIRScram_BreakStatement::_get_list_of_input_signals(set<IIR> *list) {
  if ( get_condition() != NULL) {
    get_condition()->_get_list_of_input_signals(list);
  }
}

void
IIRScram_BreakStatement::_type_check() {
  
  IIR *new_condition = NULL;
  IIR_BreakElement *break_element = break_list.first();
  while ( break_element != NULL) {
    break_element->_type_check();
    break_element = break_list.successor(break_element);
  }
  
  if ( get_condition() != NULL ){
    new_condition = _type_check_and_resolve_boolean_condition( get_condition() );
    ASSERT(new_condition != NULL);
    ASSERT( new_condition->_is_resolved() == TRUE );
    set_condition( new_condition );
  }
}

void
IIRScram_BreakStatement::_set_process_stmt_label(IIR_Label* new_label) {
  _mangled_process_label = new_label;
}

IIR_Label*
IIRScram_BreakStatement::_get_process_stmt_label() {
  return _mangled_process_label;
}

IIR_Boolean
IIRScram_BreakStatement::_is_above_attribute_found() {
  IIR_Boolean retval = FALSE;
  if(get_condition() != NULL) {
    retval = get_condition()->_is_above_attribute_found();
  }
  return retval;
}

void
IIRScram_BreakStatement::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  if(get_condition() != NULL) {
    get_condition()->_build_above_attribute_set(to_build);
  }
}
