
// Copyright (c) 1996-2001 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING
// OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found
// in the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

//---------------------------------------------------------------------------
#include "IIRScram_ConcurrentAssertionStatement.hh"
#include "IIR_AssertionStatement.hh"
#include "IIR_Label.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_WaitStatement.hh"
#ifdef PROCESS_COMBINATION
#include "sstream-wrap.hh"
#include "IIR_Identifier.hh"
#endif


IIRScram_ConcurrentAssertionStatement::~IIRScram_ConcurrentAssertionStatement() {}


void 
IIRScram_ConcurrentAssertionStatement::_publish_vhdl(ostream &_vhdl_out) {

  _publish_vhdl_stmt_label(_vhdl_out);

  if (get_postponed() == true) {
    _vhdl_out << "postponed ";
  }
  _vhdl_out << " assert ";
  get_assertion_condition()->_publish_vhdl(_vhdl_out);

  if(get_report_expression() != NULL) {
    _vhdl_out << "\n";
    _vhdl_out << "   report ";
    get_report_expression()->_publish_vhdl(_vhdl_out);
  }

  if(get_severity_expression() != NULL) {
    _vhdl_out << "\n";
    _vhdl_out << "   severity ";
    get_severity_expression()->_publish_vhdl(_vhdl_out);
  }

  _vhdl_out << ";\n";
}

void
IIRScram_ConcurrentAssertionStatement::_publish_cc( published_file &_cc_out ){
  _publish_cc_assertion_or_report_statement( _cc_out );
}

IIR * 
IIRScram_ConcurrentAssertionStatement::_transmute() {
  IIR_ProcessStatement* pstmt = new IIR_ProcessStatement;
  IIR_WaitStatement* wstmt = new IIR_WaitStatement;
  IIR_AssertionStatement* astmt = new IIR_AssertionStatement;

  copy_location( this, pstmt );
  copy_location( this, wstmt );
  copy_location( this, astmt );

  ASSERT(get_file_name() != NULL);

  pstmt->_set_design_file( _get_design_file( ) );
  pstmt->set_line_number(get_line_number());

  pstmt->set_postponed(get_postponed());
  pstmt->set_label(get_label());

  astmt->_set_design_file( _get_design_file() );
  astmt->set_line_number(get_line_number());

  astmt->set_assertion_condition(get_assertion_condition());
  astmt->set_report_expression(get_report_expression());
  astmt->set_severity_expression(get_severity_expression());

  pstmt->process_statement_part.append(astmt);
  IIR_DesignatorList sensitivity_list;
  _build_sensitivity_list(&sensitivity_list);
  wstmt->sensitivity_list._add_signals_to_sensitivity_list(&sensitivity_list);
  pstmt->process_statement_part.append(wstmt);
  return pstmt;
}


void
IIRScram_ConcurrentAssertionStatement::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  get_assertion_condition()->_build_sensitivity_list(sensitivity_list);
}


void 
IIRScram_ConcurrentAssertionStatement::_type_check(){
  if( get_assertion_condition() != NULL ){
    _type_check_assertion_condition();
  }

  if( get_report_expression() != NULL ){
    _type_check_report_expression();
  }

  if( get_severity_expression() != NULL ){
    _type_check_severity_expression();
  }
}


#ifdef PROCESS_COMBINATION
void 
IIRScram_ConcurrentAssertionStatement::
_static_elaborate(IIR_ArchitectureDeclaration *arch, 
		  IIR_DeclarationList *cfglist,
		  char *hier_location) {
  ostringstream newname;
  IIR_Label *label;
  IIR_Char *text;

  newname << hier_location;
  label = get_label();
  if (label != NULL) {
    text = label->get_declarator()->get_text();
    for( IIR_Int32 i = 0; i < label->get_declarator()->get_text_length(); i++ ){
      newname << text[i];
    }
  }
  else {
    label = new IIR_Label;
    copy_location( this, label );
    newname << hier_location << this;
  }
  text = newname.str();

#ifdef DEBUG_ELAB
  cout << "elaborated a concurrent assertion named " << text << "\n";
#endif
  label->set_declarator(IIR_Identifier::get(text, strlen(text)));
  
  set_label(label);
}


IIR*
IIRScram_ConcurrentAssertionStatement::_clone() {
  IIR *cstmt;
  cstmt = _transmute();
  cstmt = cstmt->_clone();
  return cstmt;
}
#endif

visitor_return_type *IIRScram_ConcurrentAssertionStatement::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ConcurrentAssertionStatement(this, arg);
};
