// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_XorOperator.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_XorOperator::~IIRScram_XorOperator() {}

void 
IIRScram_XorOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " xor ";
}

const string &
IIRScram_XorOperator::_get_cc_operator_name() const {
  static const string operator_name = "vhdlXor";
  return operator_name;
}

IIR*
IIRScram_XorOperator::_clone() {
  IIR_XorOperator *clone = new IIR_XorOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_XorOperator::_get_operator_precedence(){
  return IIRScram::LOGICAL_OPERATOR ;
}

bool
IIRScram_XorOperator::_is_associative(IIR_Kind oper_kind){
  switch(oper_kind) {                                                        
  case IIR_OR_OPERATOR:
  case IIR_NAND_OPERATOR:
  case IIR_NOR_OPERATOR:
  case IIR_AND_OPERATOR:
  case IIR_XNOR_OPERATOR:
    return FALSE;                                                             
  default:
    return TRUE;                                                             
  }                 
}

IIR_Boolean
IIRScram_XorOperator::_is_logical_operator(){
  return TRUE ;
}

visitor_return_type *
IIRScram_XorOperator::_accept_visitor( node_visitor *visitor, 
				       visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_XorOperator(this, arg);
}
