/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_EDIT_DIALOG_H__
#define __SG_EDIT_DIALOG_H__

#include "sg_dataset.h"
#include "sg_layer.h"

GtkWidget*	sg_edit_columns_dialog 		(SGdataset *dataset,
						 SGlayerType layer_type);
SGdataset*	sg_edit_columns_update 		(void);

void		sg_edit_data_dialog 		(SGdataset *dataset,
						 SGlayerType layer_type);

GtkWidget*	sg_edit_function_dialog 	(SGdataset *dataset);
SGdataset*	sg_edit_function_update 	(void);

GtkWidget*	sg_edit_3d_dialog 		(SGdataset *dataset,
						 SGlayerType layer_type);
SGdataset*	sg_edit_3d_update 		(void);

GtkWidget*	sg_edit_exp_dialog 		(SGdataset *dataset,
						 SGlayerType layer_type);
SGdataset*	sg_edit_exp_update 		(void);

#endif /* __SG_EDIT_DIALOG_H__ */
