/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLOT_FILE_H__
#define __SG_PLOT_FILE_H__

#include <gtkextra/gtkextra.h>
#include "sg_layer.h"
#include "sg_dataset.h"
#include "sg_plot.h"

typedef struct _SGplotfile SGplotfile;

struct _SGplotfile
{
  gchar *filename;

  SGplot *plot;

  gboolean in_project;

  FILE *file;

  void (*save_plot) 			(SGplotfile *file);
  void (*save_layer) 			(SGplotfile *file,
  					 SGlayer *layer); 
  void (*save_dataset) 			(SGplotfile *file, 
					 SGdataset *data,
					 gboolean save_points); 
  void (*save_axis) 			(SGplotfile *file,
  					 GtkPlotAxis *axis); 

  void (*set_line_style) 		(SGplotfile *file,
  					 GtkPlotLine line); 
  void (*set_symbol_style) 		(SGplotfile *file, 
                                         GtkPlotSymbol symbol); 
  void (*put_text) 			(SGplotfile *file,
  					 GtkPlotText *text); 
  void (*put_child) 			(SGplotfile *file,
  					 GtkPlotCanvasChild *child); 

};

SGplotfile* 	sg_plot_file_new		(SGplot *plot, 
						 gchar *filename);
void    	sg_plot_file_export		(SGplotfile *file,
						 gboolean in_project);
void		sg_plot_file_export_data	(SGplotfile *file, 
						 SGdataset *dataset, 
						 gboolean save_points);
void    	sg_plot_file_destroy		(SGplotfile *file);

#endif /* __SG_PLOT_FILE_H__ */
