/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include "sg_project_file_xml.h"
#include "sg.h"
#include "sg_file.h"

gboolean
sg_project_file_export_xml (gchar *filename)
{  
  GList *list;
  FILE *file;

  file = sg_fopen(filename, "w");
  if (!file){
       g_warning("ERROR: Cannot write to file: %s", filename);
       return FALSE;
  }
  fprintf(file,"<?xml version=\"1.0\"?>\n");
  fprintf(file,"<sg:Project xmlns:sg=\"http://scigraphica.sourceforge.net\">\n");

  fprintf(file, "  <sg:Summary>\n");
  fprintf(file, "    <sg:Item>\n");
  fprintf(file, "      <sg:name>application</sg:name>\n");
  fprintf(file, "      <sg:val-string>scigraphica</sg:val-string>\n");
  fprintf(file, "    </sg:Item>\n");
  fprintf(file, "    <sg:Item>\n");
  fprintf(file, "      <sg:name>author</sg:name>\n");
  fprintf(file, "      <sg:val-string>%s</sg:val-string>\n", g_get_real_name());
  fprintf(file, "    </sg:Item>\n");
  fprintf(file, "  </sg:Summary>\n");
  fprintf(file, "  <sg:Environment LastWorksheet=\"%d\" LastMatrix=\"%d\" LastPlot=\"%d\" LastDataset=\"%d\" LastFunction=\"%d\" LastExpession=\"%d\" />\n", last_worksheet, last_matrix, last_plot, last_dataset, last_function, last_expression);

  list = worksheets;
  while(list){
    gboolean saved = TRUE;

    saved = sg_worksheet_file_export_xml((SGworksheet *)list->data, filename, 
                                         NULL, file);

    if(!saved){
       if(file) fclose(file);
       return FALSE;
    }

    list = list->next;
  }

  list = functions;
  while(list){
    SGdataset *aux;
    SGplotfile *aux_file;
 
    aux = (SGdataset *)list->data;

    aux_file = sg_plot_file_new_xml(NULL, NULL, file); 
    aux_file->save_dataset(aux_file, aux, FALSE); 
    sg_plot_file_destroy(aux_file);

    list = list->next;
  }

  list = expressions;
  while(list){
    SGdataset *aux;
    SGplotfile *aux_file;
 
    aux = (SGdataset *)list->data;

    aux_file = sg_plot_file_new_xml(NULL, NULL, file); 
    aux_file->save_dataset(aux_file, aux, FALSE); 
    sg_plot_file_destroy(aux_file);

    list = list->next;
  }

  list = datasets;
  while(list){
    SGdataset *aux;
    SGplotfile *aux_file;
 
    aux = (SGdataset *)list->data;

    aux_file = sg_plot_file_new_xml(NULL, NULL, file); 
    aux_file->save_dataset(aux_file, aux, FALSE); 
    sg_plot_file_destroy(aux_file);

    list = list->next;
  }

  list = plots;
  while(list){
    gboolean saved = TRUE;

    saved = sg_plot_file_export_xml((SGplot *)list->data, filename, file, TRUE);

    if(!saved){
       if(file) sg_fclose(file);
       return FALSE;
    }

    list = list->next;
  }

  fprintf(file, "</sg:Project>\n");

  sg_fclose(file);
  return TRUE;
}


