/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_TEXT_DIALOG_H__
#define __SG_TEXT_DIALOG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>

#define SG_TYPE_TEXT_DIALOG              (sg_text_dialog_get_type ())
#define SG_TEXT_DIALOG(obj)              (GTK_CHECK_CAST ((obj), SG_TYPE_TEXT_DIALOG, SGtextdialog))
#define SG_TEXT_DIALOG_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_TEXT_DIALOG, SGtextdialogClass))
#define GTK_IS_TEXT_DIALOG(obj)          (GTK_CHECK_TYPE ((obj), GTK_TYPE_TEXT_DIALOG))
#define GTK_IS_TEXT_DIALOG_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_TEXT_DIALOG))

typedef struct _SGtextdialog SGtextdialog;
struct _SGtextdialog
{
  GtkWindow window;

  GtkWidget *main_box;

  GtkPlotText *text;

  GtkWidget *fg_combo;
  GtkWidget *bg_combo;
  GtkWidget *text_frame;
  GtkWidget *font_combo;
  GtkWidget *border_combo;
  GtkWidget *text_entry; 
  GtkWidget *angle_spin;
  GtkWidget *center_item;
  GtkWidget *transparent_item;

  GtkWidget *ok_button;
  GtkWidget *apply_button;
  GtkWidget *cancel_button;
};


GtkType    sg_text_dialog_get_type       (void);
GtkWidget* sg_text_dialog_new            (GtkPlotText *title);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __SG_TEXT_DIALOG_H__ */

