#!/usr/bin/perl -w

# basic testing of SDL::Event

use Test::More tests => 3;
use strict;
use vars qw/@INC/;

BEGIN
  {
  unshift @INC, ('../blib/lib');
  unshift @INC, ('../blib/arch');
  chdir 't' if -d 't';
  use_ok( 'SDL::Event' ); 
  }
  
can_ok ('SDL::Event', qw/
	new 
	type pump poll wait set set_unicode set_key_repeat
	active_gain active_state key_state key_sym key_name key_mod
	key_unicode key_scancode motion_state
	motion_x motion_y motion_xrel motion_yrel
	button button_state button_x button_y
	/);

my @sym = ();
# These are exported by default, so main:: should know about them
foreach my $s (qw/
        &SDL_IGNORE &SDL_ENABLE &SDL_QUERY
	&SDL_ACTIVEEVENT &SDL_KEYDOWN &SDL_KEYUP
	&SDL_MOUSEMOTION &SDL_MOUSEBUTTONDOWN
	&SDL_MOUSEBUTTONUP &SDL_QUIT &SDL_SYSWMEVENT
	&SDL_APPMOUSEFOCUS &SDL_APPINPUTFOCUS
	&SDL_APPACTIVE &SDL_PRESSED &SDL_RELEASED
	&SDLK_BACKSPACE &SDLK_TAB &SDLK_CLEAR
	&SDLK_RETURN &SDLK_PAUSE &SDLK_ESCAPE
	&SDLK_SPACE &SDLK_EXCLAIM &SDLK_QUOTEDBL
	&SDLK_HASH &SDLK_DOLLAR &SDLK_AMPERSAND
	&SDLK_QUOTE &SDLK_LEFTPAREN &SDLK_RIGHTPAREN
	&SDLK_ASTERISK &SDLK_PLUS &SDLK_COMMA
	&SDLK_MINUS &SDLK_PERIOD &SDLK_SLASH
	&SDLK_0 &SDLK_1 &SDLK_2
	&SDLK_3 &SDLK_4 &SDLK_5
	&SDLK_6 &SDLK_7 &SDLK_8
	&SDLK_9 &SDLK_COLON &SDLK_SEMICOLON
	&SDLK_LESS &SDLK_EQUALS &SDLK_GREATER
	&SDLK_QUESTION &SDLK_AT &SDLK_LEFTBRACKET
	&SDLK_BACKSLASH &SDLK_RIGHTBRACKET &SDLK_CARET
	&SDLK_UNDERSCORE &SDLK_BACKQUOTE &SDLK_a
	&SDLK_b &SDLK_c &SDLK_d
	&SDLK_e &SDLK_f &SDLK_g
	&SDLK_h &SDLK_i &SDLK_j
	&SDLK_k &SDLK_l &SDLK_m
	&SDLK_n &SDLK_o &SDLK_p
	&SDLK_q &SDLK_r &SDLK_s
	&SDLK_t &SDLK_u &SDLK_v
	&SDLK_w &SDLK_x &SDLK_y
	&SDLK_z &SDLK_DELETE &SDLK_KP0
	&SDLK_KP1 &SDLK_KP2 &SDLK_KP3
	&SDLK_KP4 &SDLK_KP5 &SDLK_KP6
	&SDLK_KP7 &SDLK_KP8 &SDLK_KP9
	&SDLK_KP_PERIOD &SDLK_KP_DIVIDE &SDLK_KP_MULTIPLY
	&SDLK_KP_MINUS &SDLK_KP_PLUS &SDLK_KP_ENTER
	&SDLK_KP_EQUALS &SDLK_UP &SDLK_DOWN
	&SDLK_RIGHT &SDLK_LEFT &SDLK_INSERT
	&SDLK_HOME &SDLK_END &SDLK_PAGEUP
	&SDLK_PAGEDOWN &SDLK_F1 &SDLK_F2
	&SDLK_F3 &SDLK_F4 &SDLK_F5
	&SDLK_F6 &SDLK_F7 &SDLK_F8
	&SDLK_F9 &SDLK_F10 &SDLK_F11
	&SDLK_F12 &SDLK_F13 &SDLK_F14
	&SDLK_F15 &SDLK_NUMLOCK &SDLK_CAPSLOCK
	&SDLK_SCROLLOCK &SDLK_RSHIFT &SDLK_LSHIFT
	&SDLK_RCTRL &SDLK_LCTRL &SDLK_RALT
	&SDLK_LALT &SDLK_RMETA &SDLK_LMETA
	&SDLK_LSUPER &SDLK_RSUPER &SDLK_MODE
	&SDLK_HELP &SDLK_PRINT &SDLK_SYSREQ
	&SDLK_BREAK &SDLK_MENU &SDLK_POWER
	&SDLK_EURO &KMOD_NONE &KMOD_NUM
	&KMOD_CAPS &KMOD_LCTRL &KMOD_RCTRL
	&KMOD_RSHIFT &KMOD_LSHIFT &KMOD_RALT
	&KMOD_LALT &KMOD_CTRL &KMOD_SHIFT
	&KMOD_ALT
       /)
  {
  my $i = $s;
  $i =~ s/^[\&]//;
  push @sym, $i;
  }
can_ok ('main', @sym);


