/***************************************************************************
                          player_timer.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "player.h"



void Player::process_row() {

        parser.parse_row(data.position.pattern,data.position.row);

	data.position.row++;

	if (data.position.row>=song->get_pattern_length(data.position.pattern)) {

                if (data.parameters.mode==PLAY_SONG) {

                	int current_order=data.position.order;
                	printf("order %i\n",data.position.order);
			data.position.order=song->get_next_order(data.position.order);	
			
			if (current_order>=data.position.order) finished=true;

			if (data.position.order!=-1) {

				data.position.pattern=song->get_order(data.position.order);
			}
		}

		data.position.row=0;
	}

	data.variables.calculate_real_increment();
	data.variables.next_row_msecs+=data.variables.real_increment;
}

void Player::update_timer(int p_msecs_elapsed) {

	int queue_time=(p_msecs_elapsed-data.variables.msecs_elapsed);


        if (lock!=NULL) lock->grab();

	if ((data.position.order==-1) && (data.parameters.mode==PLAY_SONG)) {

		reset_internal();
	}

	if (data.parameters.mode!=PLAY_NOTHING) {

                long i;
		int last_event=0;
		
		if (old_mode==PLAY_NOTHING) {

                        data.variables.next_row_msecs=data.variables.msecs_elapsed;
			process_row();		
		}

		for (i=data.variables.msecs_elapsed;i<p_msecs_elapsed;i++) {
		
                        last_event++;

			if (i>data.variables.next_row_msecs) {

                                data.variables.msecs_elapsed+=last_event;
   			        queue.move_priorities(last_event);
				queue_time-=last_event;
				process_row();
				last_event=0;
			}
		}
	}
	
	queue.move_priorities(queue_time);
	data.variables.msecs_elapsed+=queue_time;


	//TO CHANGE!

	queue.delete_extra_events(0,"pitch virtual");	                                   	
	while (!queue.is_empty() && (queue.get_head_time()<0)) {

		Event *tmp_event;

		tmp_event=queue.pop();
		tmp_event->execute();
		delete tmp_event;
	}

	old_mode=data.parameters.mode;

        if (lock!=NULL) lock->release();
}