/***************************************************************************
                         directoryview.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307   *
 *   USA.                                                                  *
 *                                                                         *
 *   For license exceptions see LICENSE.EXC file, attached with the source *
 *   code.                                                                 *
 *                                                                         *
 ***************************************************************************/

#ifndef __DIRECTORYVIEW_H__
#define __DIRECTORYVIEW_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE 
#include <klistview.h>
#include <kio/job.h>

class ImageViewer;
class ListItem;
class ImageListView;
class MainWindow;
class Directory;

class KActionCollection;
class KAction;
class KDirWatch;
class KListView;
class KPopupMenu;
class KIO::Job;

class QDragEnterEvent;
class QDropEvent;
class QDragMoveEvent;
class QDragLeaveEvent;
class QMouseEvent;
class QStringList;
class QString;
class QProgressDialog;
class QPopupMenu;
class QDir;
class QFileInfo;
class QPoint;


class DirectoryView : public KListView
{
 Q_OBJECT

public:
	DirectoryView (QWidget * parent, ImageViewer * iv, 
			ImageListView * imageList, MainWindow * mw);

	virtual ~DirectoryView();
	
	/**
		the drag'n'drop events
	*/
	void contentsDragEnterEvent (QDragEnterEvent * event);
	void contentsDropEvent (QDropEvent * event);
	void contentsDragMoveEvent (QDragMoveEvent * e);
	void contentsDragLeaveEvent (QDragLeaveEvent *);
	void contentsMouseMoveEvent (QMouseEvent *e);
	
	/**
		the mouse event
	*/	
	void contentsMousePressEvent (QMouseEvent* e);
	void contentsMouseReleaseEvent(QMouseEvent* e);
	virtual void contentsMouseDoubleClickEvent ( QMouseEvent * e );
	/**
		init the menus
	*/
	void initMenu(KActionCollection *actionCollection);

	/**
		copy a list of local (ie file:/) urls into  the dest directory
	*/
	void copy(const QStringList& uris, const QString& dest);
	/**
		move a list of local (ie file:/) urls into  the dest directory
	*/
	void move(const QStringList& uris, const QString& dest);

	/**	
		@return true if the user is drropping files
	*/
	bool isDropping();

	/**
		return true if it have to show the hidden directories
	*/
	void setShowHiddenDir(bool show);
	bool showHiddenDir();

	/**
		return true if it have to show the hidden files
	*/
	void setShowHiddenFile(bool show);
	bool showHiddenFile();
	
	/**
		return true if it have to show the directories
	*/
	void setShowDir(bool show);
	bool showDir();
  
	/**
		return true if it have to load the first image of the selected
		directory
	*/
	void setLoadFirstImage(bool load);
	bool loadFirstImage();
	
	/**
		return true if it have to show ALL files
	*/
	void setShowAllFile(bool show);
	inline bool showAllFile() {return __showAllFile__;};

	int filter();
	bool isImage(QFileInfo *info);
	bool isImage(const QString& info);
	
	QPixmap* imagePixmap(){return image_pixmap;};

	ListItem* getDir(const QString& dirfullname);
	void removeDir(const QString& path);
	
	ListItem* itemAt ( const QPoint & viewPos ) const;
	ListItem* currentItem () const;
	ListItem* firstChild() const;

	static const int COLUMN_NAME=0;
	static const int COLUMN_TYPE=1;
	static const int COLUMN_SIZE=2;
	static const int COLUMN_SELECT=3;

	int getIconSize();

private:
	QString getDestName(const QString& orgFile, const QString& destDir);
	
	enum OperationMode{NONE, COPY, MOVE};
	
	bool copy (QString *dep, QString *dest);
	bool move (QString *dep, QString *dest);
	void copyNext();
	void moveNext();

	bool __showHiddenDir__, __showHiddenFile__,  __showDir__,
		__showAllFile__, __loadfirstimage__;
	bool dropping;

	bool autoSkip;
	bool replaceAll;
	int autoopenTime;
	int totalFiles;

	QString currentItemName;
	QString dirOrg, dirDest;

	OperationMode currentOperation;
	QPtrList<QString>* fileToProcess;
	QString *destDir;
	
	QString lastDestDir;

	ImageViewer *iv;
	ImageListView *imageList;
	MainWindow *mw;

	QTimer *autoopen_timer;
	ListItem *dropItem;
	QPtrList < ListItem > oldCurrents;
	ListItem *oldCurrent;

	QProgressDialog *copyProgress;
	KPopupMenu *popup;
	ListItem *clickedItem;
	KDirWatch *dirWatch;
	
	QPixmap *image_pixmap;

public slots:
	void startWatchDir(QString);
	void stopWatchDir(QString);

	void startWatchDir();
	void stopWatchDir();

	void slotDirInfo();
	void slotDirProperty();

	void slotShowItem (QListViewItem * item);
	void openFolder ();

	void slotNewDir (QListViewItem *item);
	void slotNewDir ();
	void slotNewAlbum (QListViewItem *item);
	void slotNewAlbum ();
	void slotNewCDArchive();
	
	void slotSuppr (QListViewItem *item);
	void slotSuppr ();
	void slotTrash (QListViewItem *item);
	void slotTrash ();
	void slotRename (QListViewItem *item);
	void slotRename ();
	void slotDirPasteFiles();
	
	void recursivelyOpen(QListViewItem *item);
	void recursivelyOpen();

	void slotDirCopy();
	void slotDirMove();
  
	void slotSelectionChanged ();
	
	void goToNextDir();
	void goToPreviousDir();

protected slots:
	void copyingDone( KIO::Job *);
	void movingDone( KIO::Job *);
	void renameDone( KIO::Job *);

	void copyingDirDone( KIO::Job *);
	void movingDirDone( KIO::Job *);

protected:
	QString shrinkdn(const QString& str);
	void updateActions(ListItem *item);
	QDragObject * dragObject ();
	
	void initSelectedListItem();
	void initSelectedListItem(ListItem *item);
	void restoreSelectedListItem();
	
	KActionCollection *actionCollection;
	

};

#endif
