%{

#include <stdlib.h>
#include <stdio.h>
#include <obstack.h>
#include "xmalloc.h"
#include "symbol.h"
#include "scanner.h"

/* An implementation of a symbol */

/* Allocation using obstack */

#define obstack_chunk_alloc xmalloc
#define obstack_chunk_free free

static struct obstack stack[1];

void
symbol_init()
{
  obstack_init(stack);
}

struct symbol 
{
  const char sym[1];
};

symbol_t 
make_symbol(const char *name)
{
  return (symbol_t)obstack_copy0(stack, name, strlen(name));
}

const char *
symbol_name(symbol_t symbol)
{
  return symbol->sym;
}

%}

%union {
  symbol_t id;
}

%token UNUSED
%token <id> IDENTIFIER
%token CLASS COMMON ALIAS SENSITIVITY DOMINANCE CATEGORY LEVEL

%start mls
%%

mls			: sensitivities dominance opt_categories 
                          levels base_perms
			;
sensitivities	 	: sensitivity_def 
			| sensitivities sensitivity_def
			;
sensitivity_def		: SENSITIVITY identifier alias_def ';'
			| SENSITIVITY identifier ';'
	                ;
alias_def		: ALIAS names
			;
dominance		: DOMINANCE identifier 
                        | DOMINANCE '{' identifier_list '}' 
			;
opt_categories          : categories
                        |
                        ;
categories 		: category_def 
			| categories category_def
			;
category_def		: CATEGORY identifier alias_def ';'
			| CATEGORY identifier ';'
			;
levels	 		: level_def 
			| levels level_def
			;
level_def		: LEVEL identifier ':' id_comma_list ';'
			| LEVEL identifier ';' 
						;
base_perms		: opt_common_base av_base
			;
opt_common_base         : common_base
                        |
                        ;
common_base		: common_base_def
			| common_base common_base_def
			;
common_base_def	        : COMMON identifier '{' perm_base_list '}'
			;
av_base		        : av_base_def
			| av_base av_base_def
			;
av_base_def		: CLASS identifier '{' perm_base_list '}'
                        | CLASS identifier
			;
perm_base_list		: perm_base
			| perm_base_list perm_base
			;
perm_base		: identifier ':' identifier
                        | identifier ':' '{' identifier_list '}'
			;

id_comma_list           : identifier
			| id_comma_list ',' identifier
			;

tilde			: '~'
			;
asterisk		: '*'
			;
names           	: identifier
			| nested_id_set
			| asterisk
			| tilde identifier
			| tilde nested_id_set
                        | identifier '-' identifier 
			;

identifier_list		: identifier
			| identifier_list identifier
			;
nested_id_set           : '{' nested_id_list '}'
                        ;
nested_id_list          : nested_id_element | nested_id_list nested_id_element
                        ;
nested_id_element       : identifier | '-' identifier | nested_id_set
                        ;
identifier		: IDENTIFIER
                        ;
