/***************************************************************************
    smb4knetworkitems  -  Network items used by the Smb4KScanner class
    to pass and store data.
                             -------------------
    begin                : Mi Jun 2 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// application specific includes
#include "smb4knetworkitems.h"


/****************************************************************************
   Constructor for the Smb4KWorkgroupItem class.
****************************************************************************/

Smb4KWorkgroupItem::Smb4KWorkgroupItem( const QString &name, const QString &master, const QString &masterIP ) 
: m_name( name ), m_master( master ), m_ip( masterIP )
{
  m_pseudo = false;
}

/****************************************************************************
   Destructor for the Smb4KWorkgroupItem class.
****************************************************************************/

Smb4KWorkgroupItem::~Smb4KWorkgroupItem()
{
}


/****************************************************************************
   Set the pseudo value to TRUE.
****************************************************************************/

void Smb4KWorkgroupItem::setPseudo()
{
  m_pseudo = true;
}


/****************************************************************************
   Constructors for the Smb4KHostItem class.
****************************************************************************/

Smb4KHostItem::Smb4KHostItem( const QString &workgroup, const QString &name, const QString &comment, const QString &ip )
: m_workgroup( workgroup ), m_name( name ), m_comment( comment ), m_ip( ip )
{
}


/****************************************************************************
   Destructor for the Smb4KHostItem class.
****************************************************************************/

Smb4KHostItem::~Smb4KHostItem()
{
}


/****************************************************************************
  Sets the server string of this host.
****************************************************************************/

void Smb4KHostItem::setServerString( const QString &server )
{
  m_server_string = server;
}


/****************************************************************************
  Sets the OS string of this host.
****************************************************************************/

void Smb4KHostItem::setOSString( const QString &os )
{
  m_os_string = os;
}


/****************************************************************************
   Constructor for the Smb4KShareItem class.
****************************************************************************/

Smb4KShareItem::Smb4KShareItem( const QString &workgroup, const QString &host, const QString &name, const QString &type, const QString &comment )
: m_workgroup( workgroup ), m_host( host ), m_name( name ), m_type( type ), m_comment( comment )
{
}


/****************************************************************************
   Destructor for the Smb4KShareItem class.
****************************************************************************/

Smb4KShareItem::~Smb4KShareItem()
{
}


/****************************************************************************
   Constructor for the Smb4KPreviewItem class.
****************************************************************************/

Smb4KPreviewItem::Smb4KPreviewItem( const QString &host, const QString &share, const QString &path, const QString &name, bool file )
: m_host( host ), m_share( share ), m_path( path ), m_name( name ), m_isFile( file )
{
}


/****************************************************************************
   Destructor for the Smb4KPreviewItem class.
****************************************************************************/

Smb4KPreviewItem::~Smb4KPreviewItem()
{
}


/****************************************************************************
   Sets the item to be a file or directory.
****************************************************************************/

void Smb4KPreviewItem::setIsFile( bool sw )
{
  m_isFile = sw;
}
