/***************************************************************************
                          smb4kbookmarkeditor  -  description
                             -------------------
    begin                : Di Okt 5 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qvaluelist.h>
 
// KDE includes
#include <klocale.h>
#include <kaction.h>
#include <kactionclasses.h>

// application specific includes
#include "smb4kbookmarkeditor.h"
#include "../core/smb4kbookmark.h"
#include "../smb4k.h"

Smb4KBookmarkEditor::Smb4KBookmarkEditor( QWidget *parent, const char *name )
: KDialogBase( Plain, i18n( "Bookmark Editor" ), Ok|Cancel, Ok, parent, name, false, true )
{
  setWFlags( Qt::WDestructiveClose );

  QFrame *frame = plainPage();
  QGridLayout *layout = new QGridLayout( frame );
  layout->setSpacing( 5 );

  m_view = new KListView( frame );
  m_view->addColumn( i18n( "Bookmarks" ), -1 );
  m_view->setResizeMode( QListView::LastColumn );

  KAction *a = new KAction( i18n( "Remove" ), "remove", Key_Delete, this, SLOT( slotRemoveClicked() ), sapp->actionCollection(), "remove_bookmark" );
  KAction *b = new KAction( i18n( "Remove All" ), "editdelete", CTRL+Key_X, this, SLOT( slotDeleteAllClicked() ), sapp->actionCollection(), "remove_all_bookmarks" );
  a->setGroup( "BookmarkEditor" );
  b->setGroup( "BookmarkEditor" );
  
  QValueList<Smb4KBookmark *> bookmarks = sapp->core()->bookmarkHandler()->getBookmarks();
  
  for ( QValueList<Smb4KBookmark *>::ConstIterator it = bookmarks.begin(); it != bookmarks.end(); ++it )
  {
    QListViewItem *item = new QListViewItem( m_view, (*it)->getShare() );
    item->setPixmap( 0, SmallIcon( "folder_green" ) );
  }

  layout->addWidget( m_view, 0, 0, 0 );

  kapp->config()->setGroup( "General Options" );
  setInitialSize( kapp->config()->readSizeEntry( "Bookmark Editor Geometry", 0L ) );
  
  connect( m_view, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint &, int ) ), this, SLOT( slotRightButtonPressed( QListViewItem *, const QPoint &, int ) ) );
  
  connect( this, SIGNAL( okClicked() ),  this, SLOT( slotOkClicked() ) );
  connect( this, SIGNAL( cancelClicked() ), this, SLOT( slotCancelClicked() ) );
}


Smb4KBookmarkEditor::~Smb4KBookmarkEditor()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KBookmarkEditor::slotRightButtonPressed( QListViewItem *item, const QPoint &pos, int )
{
  KActionMenu *menu = new KActionMenu( this, "BookmarkEditorPopupMenu" );
  
  if ( !item )
  {
    sapp->actionCollection()->action( "remove_bookmark" )->setEnabled( false );
  }
  else
  {
    sapp->actionCollection()->action( "remove_bookmark" )->setEnabled( true );
  }
  
  if ( m_view->childCount() == 0 )
  {
    sapp->actionCollection()->action( "remove_all_bookmarks" )->setEnabled( false );
  }
  else
  {
    sapp->actionCollection()->action( "remove_all_bookmarks" )->setEnabled( true );
  }
    
  menu->insert( sapp->actionCollection()->action( "remove_bookmark" ) );
  menu->insert( sapp->actionCollection()->action( "remove_all_bookmarks" ) );
  
  menu->popup( pos );
}


void Smb4KBookmarkEditor::slotRemoveClicked()
{
  if ( m_view->currentItem() )
  {
    delete m_view->currentItem();
  }
}


void Smb4KBookmarkEditor::slotDeleteAllClicked()
{
  m_view->clear();
}


void Smb4KBookmarkEditor::slotOkClicked()
{
  KActionPtrList list = sapp->actionCollection()->actions( "BookmarkEditor" );
  
  for ( KActionPtrList::Iterator it = list.begin(); it != list.end(); ++it )
  {
    delete *it;
  }
  
  QValueList<Smb4KBookmark *> bookmarks;
  
  if ( m_view->childCount() != 0 )
  {
    QListViewItemIterator it( m_view );
    
    while( it.current() )
    {
      bookmarks.append( new Smb4KBookmark( it.current()->text( 0 ), QString::null ) );
      ++it;
    }
  }
  
  sapp->core()->bookmarkHandler()->writeBookmarkList( bookmarks );
}


void Smb4KBookmarkEditor::slotCancelClicked()
{
  KActionPtrList list = sapp->actionCollection()->actions( "BookmarkEditor" );
  
  for ( KActionPtrList::Iterator it = list.begin(); it != list.end(); ++it )
  {
    sapp->actionCollection()->kaccel()->remove( (*it)->name() );
    sapp->actionCollection()->remove( *it );
  }
}
