/***************************************************************************
                          smb4kbookmarkeditor  -  description
                             -------------------
    begin                : Di Okt 5 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KBOOKMARKEDITOR_H
#define SMB4KBOOKMARKEDITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kdialogbase.h>
#include <klistview.h>

class Smb4KBookmarkEditor : public KDialogBase
{
  Q_OBJECT
  
  public:
    /**
     * The constructor.
     */
    Smb4KBookmarkEditor( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KBookmarkEditor(); 
    
  protected slots:
    /**
     * This slot is activated whenever the right mouse button
     * has been pressed.
     */
    void slotRightButtonPressed ( QListViewItem *item, const QPoint &pos, int col );
    /**
     * This slot is activated whenever the remove button of the 
     * menu is clicked.
     */
    void slotRemoveClicked();
    /**
     * This slot is activated whenever the 'Remove All' button of
     * the menu has been clicked.
     */
    void slotDeleteAllClicked();
    /**
     * This slot is activated if the OK button has been clicked.
     */
    void slotOkClicked();
    /**
     * This slot is activated if the Cancel button has been clicked.
     */    
    void slotCancelClicked();
     
  private:
    /**
     * The listview.
     */
    KListView *m_view;
};

#endif
