/*
 * PPMDVFileInput.cc -- Generates a DV Pump output from a PPM FILE Input
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include "PPMDVFileInput.h"

/** PPMDVFileInput implementation - Connverts a PPM stream to RAW DV output on 
	the pump.
*/

PPMDVFileInput::PPMDVFileInput( ) : 
	file( stdin ), 
	output_ppm( false ),
	output_preview( false )
{
	image = new uint8_t[ 720 * 576 * 3 ];
}

PPMDVFileInput::PPMDVFileInput( DVEncoderParams &_params ) : 
	DVEncoder( _params ),
	file( stdin ), 
	output_ppm( false ),
	output_preview( false )
{
	SetParams( _params );
	image = new uint8_t[ 720 * 576 * 3 ];
}

PPMDVFileInput::~PPMDVFileInput( ) 
{
	delete image;
}

void PPMDVFileInput::SetPPMOutput( bool _output_ppm )
{
	output_ppm = _output_ppm;
}

void PPMDVFileInput::SetPPMPreview( bool _output )
{
	output_preview = _output;
}

bool PPMDVFileInput::ReadFrame( Frame &frame )
{
	int width = GetWidth( );
	int height = GetHeight( );

	if ( output_ppm && output_preview )
	{
		width /= 4;
		height /= 4;
	}

	bool obtained = ReadPPM( image, width, height );

	if ( obtained && !output_ppm )
	{
		EncodeRGB( frame, image );
		EncodeAudio( frame );
	}
	else if ( obtained )
	{
		fprintf( stdout, "P6\n%d %d\n255\n", width, height );
		fwrite( image, width * height * 3, 1, stdout );
	}

	return obtained;
}

void PPMDVFileInput::SetFile( FILE *_file )
{
	file = _file;
}

FILE *PPMDVFileInput::GetFile( )
{
	return file;
}
