/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __AG_DEFS_H__
#define __AG_DEFS_H__


#include <gtk/gtk.h>


/* 
 * Struct for the text preferences
 */
typedef struct {
	
	GdkColor    fg;           /* foreground color */
	GdkColor    er;           /* error color */ 
	GdkColor    cu;           /* cursor color */
	GdkColor    bg;           /* background color */
	gchar       fname[100];   /* Font Name */     
	GdkFont    *font;         /* Font */
	
} AgTextPref; 


/* 
 * Struct for the mode preferences 
 */
typedef struct {
	
	gchar    format[5];     /* Format */
	gchar    size[5];       /* Format size */
	gchar    angle[5];      /* Angle messure */
	
} AgModePref; 



/* error struct definition */
typedef struct {
	
	gint  state;
	gint  start;
	gint  end;
  
} AgError;




enum {
	RAD,
	DEG,
	GRAD
};


enum {
	STD,
	ENG,
	FIX,
	SCI,
	HEX,
	BIN,
	OCT
};


/* Maximum of digits on a formated number string */
#define MAX_FORMAT_SIZE 50

/* Maximum of bits in double */
#define MAX_FORMAT_BITS 32

/**
 * Keymap by Jan Struyf
 **/
void
ag_set_button_map(gint id, GtkWidget* button);

GtkWidget*
ag_get_button_map(gint id);

GtkWidget*
ag_get_button_map_char(gchar ch);

#define AG_KEY_NONE	-1
#define AG_KEY_0	0
#define AG_KEY_1	1
#define AG_KEY_2	2
#define AG_KEY_3	3
#define AG_KEY_4	4
#define AG_KEY_5	5
#define AG_KEY_6	6
#define AG_KEY_7	7
#define AG_KEY_8	8
#define AG_KEY_9	9
#define AG_KEY_DOT	10
#define AG_KEY_DEL	11
#define AG_KEY_AC	12
#define AG_KEY_EXE	13
#define AG_KEY_MUL	14
#define AG_KEY_DIV	15
#define AG_KEY_POW	16
#define AG_KEY_MINUS	17
#define AG_KEY_PLUS	18
#define AG_KEY_P_OPEN	19
#define AG_KEY_P_CLOSE	20
#define AG_KEY_FAC	21
#define AG_KEY_BACKWARD	22
#define AG_KEY_FORWARD	23
#define AG_KEY_H_UP	24
#define AG_KEY_H_DOWN	25

#define AG_NB_KEYS	26

#endif  /* __AG_DEFS_H__ */


