<?php
/*
 * $Horde: accounts/lib/Driver/localhost.php,v 1.7.2.1 2003/01/19 06:53:21 ericr Exp $
 *
 * Copyright 2002-2003 Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 *
 * Implements the Accounts API for IMAP servers with unix accounts on
 * the localhost machine (same machine as the web server).  Should work
 * for local unix accounts, nis/nis+ accounts, or any PAM oriented accounts
 * that appear as local accounts on the local machine.  The exception is
 * the quota support.  See that routine for additional comments.
 *
 *
 * @author  Eric Rostetter <eric.rosttter@physics.utexas.edu>
 * @version $Revision: 1.7.2.1 $
 * @since   Accounts 2.1
 * @package accounts
 */

class Accounts_Driver_localhost extends Accounts_Driver {

    /**
     * Hash containing connection parameters.
     *
     * @var array $params
     */
    var $params = array();


    /**
     * Constructor
     *
     * @access public
     *
     * @param optional array $params  Hash containing connection parameters.
     */
    function Accounts_Driver_localhost($params = array())
    {
        $this->params = $params;
        if (!array_key_exists('quota_path', $this->params)) {
            $this->params['quota_path'] = 'quota';
        }
        if (!array_key_exists('grep_path', $this->params)) {
            $this->params['grep_path'] = 'grep';
        }
    }

    /**
     * Implement the Quota API for IMAP servers with a unix quota command.
     * This requires a modified "quota" command that allows the httpd server
     * account to get quotas for other users...  It also requires that your
     * web server and imap server be the same server or at least have shared
     * authentication and file servers (e.g. via NIS/NFS).  And last, it (as
     * written) requires the posix php extensions.
     *
     * You must configure this in accounts/config/conf.php.  You must
     * pass the path to your quota and grep commands as parameters.  An example
     * config would be something like:
     *
     *   'quota' => array(
     *     'driver' => 'command',
     *     'params' => array(
     *       'quota_path' => '/usr/bin/quota',
     *       'grep_path'  => '/bin/grep'))
     *
     * @access public
     *
     * @return mixed    The Quota Array (bytes used, limit) or false for error.
     */
    function getQuota($username, $realm)
    {
        // this won't work if we don't have posix extensions
        if (!extension_loaded('posix')) {
           return false;
        }

        $user = strtolower($username);
        $passwd_array = posix_getpwnam($user);
        $homedir = split( "/", $passwd_array['dir'] );

        $cmdline = $this->params['quota_path'] . " -u $user 2>&1 | " .
                   $this->params['grep_path'] . " $homedir[1]";
        $junk = exec( $cmdline, $quota_data, $return_code);
        if ( $return_code == 0 && count($quota_data) == 1 ) {
           $quota = split( "[[:blank:]]+", trim($quota_data[0]) );
           return array('used' => $quota[1]*1024, 'limit' => $quota[2]*1024);
        }
        return false;
    }


    function getFullname($username, $realm)
    {
        // this won't work if we don't have posix extensions
        if (!extension_loaded('posix')) {
            return false;
        }

        $user = strtolower($username);
        $passwd_array = posix_getpwnam($user);
        $gecos_array = explode(",", $passwd_array['gecos']);
        return $gecos_array[0];
    }


    function getHome($username, $realm)
    {
        // this won't work if we don't have posix extensions
        if (!extension_loaded('posix')) {
           return false;
        }

        $user = strtolower($username);
        $passwd_array = posix_getpwnam($user);
        return $passwd_array['dir'];
    }


    function getShell($username, $realm)
    {
        // this won't work if we don't have posix extensions
        if (!extension_loaded('posix')) {
           return false;
        }

        $user = strtolower($username);
        $passwd_array = posix_getpwnam($user);
        return $passwd_array['shell'];
    }
}
